/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.util.log.XQLogImpl;

public class TerminateStepService
implements XQService {
    private static XQLog m_log = XQLogImpl.getCategoryLog((int)128);
    private static final String PARAM_SINK_MSG = "MessageSink";
    public static final String PROCESS_TERMINATED = "ProcessTerminated";
    public static final String PROCESS_EXITED = "ProcessExited";

    public void init(XQInitContext initial) throws XQServiceException {
    }

    public void service(XQServiceContext svcCtx) throws XQServiceException {
        boolean messageSink = svcCtx.getParameters().getBooleanParameter(PARAM_SINK_MSG, 1);
        if (messageSink) {
            this.messageSink(svcCtx);
        } else {
            this.exitItinerary(svcCtx);
        }
    }

    private void messageSink(XQServiceContext svcCtx) {
        XQEnvelope envelope = svcCtx.getNextIncoming();
        String messageId = null;
        try {
            messageId = (String)envelope.getMessage().getHeaderValue("JMSMessageID");
        }
        catch (Throwable e) {
            // empty catch block
        }
        m_log.logDebug("Acting as a message sink for message: " + messageId);
        svcCtx.clearOutgoing();
        svcCtx.clearFaults();
        svcCtx.getParameters().setBooleanParameter(PROCESS_TERMINATED, 1, true);
    }

    private void exitItinerary(XQServiceContext svcCtx) {
        if (svcCtx.getProcessContext() != null) {
            m_log.logDebug("Exiting the itinerary: " + svcCtx.getProcessContext().getName());
            XQEnvelope envelope = svcCtx.getNextIncoming();
            envelope.clearAddresses();
            svcCtx.addOutgoing(envelope);
            svcCtx.getParameters().setBooleanParameter(PROCESS_EXITED, 1, true);
        }
    }

    public void destroy() {
    }
}

