/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.process.engine.ProcessEngine;
import com.sonicsw.esb.process.engine.bootstrap.PEConfigUtil;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xqimpl.config.XQContainerConfig;
import com.sonicsw.xqimpl.config.XQIntrinsicServiceConfig;
import com.sonicsw.xqimpl.config.XQServiceApplicationConfig;
import com.sonicsw.xqimpl.service.ContainerLifeCycleManager;
import com.sonicsw.xqimpl.service.ESBSpringUtils;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQServiceApplication;
import com.sonicsw.xqimpl.util.ClassLoaderManager;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

class XQAppManager {
    private Map<String, XQServiceApplication> m_serviceAppMap = new TreeMap<String, XQServiceApplication>(new ServiceStartupPriorityComparator());
    private Map<String, Integer> m_serviceStartupPriorityMap = new HashMap<String, Integer>();
    private boolean m_initialized = false;
    private String[][] m_ids;
    private int m_serviceCount = 0;
    private static XQLog log = XQLogImpl.getCategoryLog((int)1024);
    private int m_numberOfHiddenServicesInitialized = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int init(XQContainerConfig config, ICanonicalName mfComponentCanonicalName, String mfFailoverIdentity, XQAccessorFactory accessorFactory, XQMessageFactory messageFactory, ContainerLifeCycleManager containerLifeCycle, ConfigurableApplicationContext rootAppContext) {
        if (!this.m_initialized) {
            String xqContainerName = config.getXQContainerName();
            Map<String, XQServiceApplication> map = this.m_serviceAppMap;
            synchronized (map) {
                List intrinsics = XQContainer.getIntrinsicServices();
                ListIterator it = intrinsics.listIterator();
                while (it.hasNext()) {
                    XQIntrinsicServiceConfig conf = (XQIntrinsicServiceConfig)it.next();
                    this.initializeHiddenComponent(conf.getServiceName(), conf.getListeners(), config, mfComponentCanonicalName, mfFailoverIdentity, messageFactory, conf.getDescription());
                }
                if (XQContainer.isTestContainer()) {
                    this.initializeHiddenComponent("DebugServiceInterceptor", 100, config, mfComponentCanonicalName, mfFailoverIdentity, messageFactory, "Run and Debug");
                    this.initializeHiddenComponent("DebugInternalStepInterceptor", 100, config, mfComponentCanonicalName, mfFailoverIdentity, messageFactory, "Run and Debug for Internal steps types");
                }
                for (String appName : config.getServiceApplications()) {
                    XQServiceApplicationConfig serviceAppConfig = config.getServiceApplication(appName);
                    this.m_serviceStartupPriorityMap.put(appName, serviceAppConfig.getStartupPriorityLevel());
                }
                Iterator serviceAppConfigs = config.getServiceApplications().iterator();
                TreeMap<String, XQServiceApplication> serviceAppMap = new TreeMap<String, XQServiceApplication>(new ServiceStartupPriorityComparator());
                while (serviceAppConfigs.hasNext()) {
                    String appName = (String)serviceAppConfigs.next();
                    XQServiceApplicationConfig serviceAppConfig = config.getServiceApplication(appName);
                    XQServiceApplication app = null;
                    try {
                        app = new XQServiceApplication();
                        app.preInit(serviceAppConfig, mfComponentCanonicalName, mfFailoverIdentity, xqContainerName);
                        serviceAppMap.put(appName, app);
                    }
                    catch (Throwable thrown) {
                        log.logError("Error initializing service application " + serviceAppConfig.getServiceApplicationName());
                        log.logError(thrown);
                        if (app == null) continue;
                        containerLifeCycle.registerInitError(app, thrown);
                    }
                }
                ClassLoaderManager.getInstance().commitAllClassLoaders();
                ApplicationContext sharedAppContext = this.initializeApplicationContext(rootAppContext);
                for (XQServiceApplication serviceApp : serviceAppMap.values()) {
                    String appName = serviceApp.getName();
                    serviceApp.setApplicationContext(sharedAppContext);
                    try {
                        serviceApp.instantiateService(messageFactory);
                        this.m_serviceAppMap.put(appName, serviceApp);
                    }
                    catch (Throwable thrown) {
                        log.logError("Error initializing service application " + appName);
                        log.logError(thrown);
                        containerLifeCycle.registerInitError(serviceApp, thrown);
                    }
                }
                for (XQServiceApplication serviceApp : this.m_serviceAppMap.values()) {
                    serviceApp.initializeInterceptors(this);
                }
                for (XQServiceApplication serviceApp : this.m_serviceAppMap.values()) {
                    try {
                        serviceApp.setInitFailed(false);
                        serviceApp.postInit(messageFactory, accessorFactory, containerLifeCycle);
                    }
                    catch (Throwable e) {
                        serviceApp.setInitFailed(true);
                        log.logError("Error initializing service application " + serviceApp.getName());
                        log.logError(e);
                        containerLifeCycle.registerInitError(serviceApp, e);
                    }
                }
                this.m_ids = new String[this.m_serviceAppMap.size()][2];
                int i = 0;
                Iterator<String> serviceAppNames = this.m_serviceAppMap.keySet().iterator();
                while (serviceAppNames.hasNext()) {
                    this.m_ids[i][0] = serviceAppNames.next();
                    XQServiceApplication serviceApp = this.m_serviceAppMap.get(this.m_ids[i][0]);
                    this.m_ids[i++][1] = serviceApp.getServiceType();
                }
            }
            this.m_initialized = true;
            this.m_serviceCount = this.m_serviceAppMap.size() - this.m_numberOfHiddenServicesInitialized;
        }
        return this.m_serviceAppMap.size() - this.m_numberOfHiddenServicesInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationContext initializeApplicationContext(ConfigurableApplicationContext rootCtx) {
        ClassLoader previousLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)ClassLoaderManager.getInstance().getDefaultClassLoader());
        try {
            GenericApplicationContext sharedCtx = ESBSpringUtils.createApplicationContext("ESBSharedApplicationContext");
            sharedCtx.setParent((ApplicationContext)rootCtx);
            ESBSpringUtils.readBeanConfigurationsFromClassPath("classpath*:config/esb/containerAppContext.xml", (BeanDefinitionRegistry)sharedCtx);
            if (rootCtx.containsBean("sharedApplicationContextConfigs")) {
                List configs = (List)rootCtx.getBean("sharedApplicationContextConfigs");
                ESBSpringUtils.readBeanConfigurations(configs, (BeanDefinitionRegistry)sharedCtx);
            }
            sharedCtx.refresh();
            ProcessEngine engine = PEConfigUtil.getProcessEngine((ConfigurableApplicationContext)sharedCtx);
            if (engine != null) {
                XQContainer.getInstance().processEngine = engine;
            }
            GenericApplicationContext genericApplicationContext = sharedCtx;
            return genericApplicationContext;
        }
        finally {
            ClassLoaderManager.setThreadContextClassLoader((ClassLoader)previousLoader);
        }
    }

    private void initializeHiddenComponent(String componentName, int numListeners, XQContainerConfig config, ICanonicalName mfComponentCanonicalName, String mfFailoverIdentity, XQMessageFactory messageFactory, String errorString) {
        XQServiceApplicationConfig srvConfig = new XQServiceApplicationConfig();
        srvConfig.setServiceName(componentName);
        srvConfig.setInstances(numListeners);
        srvConfig.setServiceApplicationName(componentName);
        XQParametersImpl srvConfigParameters = new XQParametersImpl();
        srvConfig.setParameters(srvConfigParameters);
        try {
            XQServiceApplication app = new XQServiceApplication();
            app.preInit(srvConfig, mfComponentCanonicalName, mfFailoverIdentity, config.getName());
            app.instantiateService(messageFactory);
            this.m_serviceAppMap.put(srvConfig.getServiceApplicationName(), app);
            ++this.m_numberOfHiddenServicesInitialized;
        }
        catch (Throwable thrown) {
            log.logError("Error initializing: " + componentName + " Due to: " + thrown.getMessage());
            log.logError("This will result in " + errorString + " not to function in this container");
            log.logDebug(thrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        Map<String, XQServiceApplication> map = this.m_serviceAppMap;
        synchronized (map) {
            Iterator<String> serviceAppNames = this.m_serviceAppMap.keySet().iterator();
            while (serviceAppNames.hasNext()) {
                XQServiceApplication serviceApp = this.m_serviceAppMap.get(serviceAppNames.next());
                try {
                    serviceApp.start();
                }
                catch (Throwable thrown) {
                    log.logError("Error starting service application " + serviceApp.getName());
                    log.logError(thrown);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        Map<String, XQServiceApplication> map = this.m_serviceAppMap;
        synchronized (map) {
            XQServiceApplication serviceApp;
            Iterator<String> serviceAppNames = this.m_serviceAppMap.keySet().iterator();
            while (serviceAppNames.hasNext()) {
                serviceApp = this.m_serviceAppMap.get(serviceAppNames.next());
                if (serviceApp.getServiceType().equalsIgnoreCase("AsynchServiceType")) continue;
                try {
                    serviceApp.stop();
                    serviceApp.releaseTransientEndpoints();
                }
                catch (Throwable thrown) {
                    log.logError("Error stopping service application " + serviceApp.getName());
                    log.logError(thrown);
                }
            }
            serviceAppNames = this.m_serviceAppMap.keySet().iterator();
            while (serviceAppNames.hasNext()) {
                serviceApp = this.m_serviceAppMap.get(serviceAppNames.next());
                if (!serviceApp.getServiceType().equalsIgnoreCase("AsynchServiceType")) continue;
                try {
                    serviceApp.stop();
                }
                catch (Throwable thrown) {
                    log.logError("Error stopping service application " + serviceApp.getName());
                    log.logError(thrown);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Map<String, XQServiceApplication> map = this.m_serviceAppMap;
        synchronized (map) {
            Iterator<String> serviceAppNames = this.m_serviceAppMap.keySet().iterator();
            while (serviceAppNames.hasNext()) {
                XQServiceApplication serviceApp = this.m_serviceAppMap.get(serviceAppNames.next());
                try {
                    serviceApp.destroy();
                }
                catch (Throwable thrown) {
                    log.logError("Error destroying service application " + serviceApp.getName());
                    log.logError(thrown);
                }
            }
            this.m_serviceAppMap.clear();
        }
        this.m_initialized = false;
    }

    public Object invokeMethod(String[] serviceId, String methodName, String[] paramTypes, Object[] paramVals) throws Exception {
        XQServiceApplication serviceApp = this.m_serviceAppMap.get(serviceId[0]);
        if (serviceApp != null) {
            return serviceApp.invokeMethod(methodName, paramTypes, paramVals);
        }
        return null;
    }

    public String[][] getServicesInfo() {
        return this.m_ids;
    }

    public XQServiceApplication getServiceApplication(String serviceName) {
        return this.m_serviceAppMap.get(serviceName);
    }

    int getServiceCount() {
        return this.m_serviceCount;
    }

    class ServiceStartupPriorityComparator
    implements Comparator<String> {
        ServiceStartupPriorityComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            Integer p1 = (Integer)XQAppManager.this.m_serviceStartupPriorityMap.get(o1);
            Integer p2 = (Integer)XQAppManager.this.m_serviceStartupPriorityMap.get(o2);
            if (p1 == null) {
                p1 = Integer.MIN_VALUE;
            }
            if (p2 == null) {
                p2 = Integer.MIN_VALUE;
            }
            if (p1 < p2) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

