/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.client.ESBInteractorFactory;
import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.run.RunContext;
import com.sonicsw.esb.run.impl.util.RunUtils;
import com.sonicsw.esb.run.util.XQMessageUtil;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQState;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xq.connector.jms.JMSEndpointStandalone;
import com.sonicsw.xq.connector.jms.messagingbean.Session;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.endpoint.IJMSEntryEndpointState;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointContextContainer;
import com.sonicsw.xqimpl.endpoint.container.InvocationEndpointManager;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import com.sonicsw.xqimpl.service.CriticalException;
import com.sonicsw.xqimpl.service.InvalidStateException;
import com.sonicsw.xqimpl.service.MessageAlreadyRejected;
import com.sonicsw.xqimpl.service.MessageHandler;
import com.sonicsw.xqimpl.service.MessageSendingHelper;
import com.sonicsw.xqimpl.service.RejectedMessageDispatcher;
import com.sonicsw.xqimpl.service.ServiceLifeCycleManager;
import com.sonicsw.xqimpl.service.ServiceMessageHandler;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQServiceConstants;
import com.sonicsw.xqimpl.service.XQServiceMetrics;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class XQDispatcher {
    private static XQLog log = XQLogImpl.getCategoryLog((int)128);
    private ClassLoader m_classLoader;
    private ServiceMessageHandler m_handler;
    private XQEndpointManager m_endpointManager;
    private XQParameters m_environment;
    private XQServiceConfig m_config;
    private LinkedList<EndpointContextContainer> m_endpointContexts = new LinkedList();
    private XQMessageFactory m_messageFactory;
    private XQAccessorFactory m_accessorFactory;
    private XQAddressFactory m_addressFactory;
    protected XQAddress m_rmeAddress;
    private String m_description;
    private String m_mfContainerName;
    private String m_mfFailoverIdentity;
    private String m_serviceName;
    private String m_serviceAppName;
    private int m_numListeners;
    private int m_numConcurrentCalls;
    private XQDispatch m_eventDispatcher;
    private ServiceLifeCycleManager m_lifeCycleManager;
    private XQEnvelopeFactory m_envelopeFactory;
    private ESBInteractorFactory m_interactorFactory;
    private RejectedMessageDispatcher m_rejectedMessageDispatcher;
    private XQAddress m_serviceAddress;
    private static String REPLYTO_HEADER_NAME = "REPLY_TO_NGSO";
    private static String LG_CORRELATION_HEADER_NAME = "LG_Header";
    private XQServiceMetrics m_metricsHelper;
    private XQServiceMetrics.Statistic m_messagesReceivedStatistic;
    private XQServiceMetrics.Statistic m_messagesReceivedIntraContainerStatistic;
    private XQServiceMetrics.Statistic m_messagesFaultedStatistic;
    private XQServiceMetrics.Statistic m_messagesSentToOutboxStatistic;
    private XQServiceMetrics.Statistic m_averageProcessingTimeStatistic;
    private XQServiceMetrics.Statistic m_messagesPerSecondStatistic;
    private XQServiceMetrics.Statistic m_messagesPerMinuteStatistic;
    private XQServiceMetrics.Statistic m_messagesPerHourStatistic;
    private XQServiceMetrics.Statistic m_listenersRefreshIntervalMaxActive;
    private XQServiceMetrics.UsageStatisticProvider m_listenerUsageTime;
    private XQServiceMetrics.UsageStatisticProvider m_listenerAverageUsageTime;

    public ServiceMessageHandler getServiceHandler() {
        return this.m_handler;
    }

    public XQLifeCycleManager getLifeCycleManager() {
        return this.m_lifeCycleManager;
    }

    public XQEndpointManager getEndpointManager() {
        return this.m_endpointManager;
    }

    public RejectedMessageDispatcher getRMEDispatcher() {
        return this.m_rejectedMessageDispatcher;
    }

    public void init(XQService service, XQServiceConfig config, XQEndpointManager endpointManager, XQMessageFactory messageFactory, XQAccessorFactory accessorFactory, XQAddressFactory addressFactory, XQParameters environment, XQDispatch eventDispatcher, EnvelopeFactory envelopeFactory, ClassLoader classloader, ServiceLifeCycleManager serviceLifeCycle, XQServiceMetrics metricsHelper, ESBInteractorFactory interactorFactory) throws Exception {
        this.m_config = config;
        this.m_endpointManager = endpointManager;
        this.m_messageFactory = messageFactory;
        this.m_accessorFactory = accessorFactory;
        this.m_addressFactory = addressFactory;
        this.m_envelopeFactory = envelopeFactory;
        this.m_environment = environment;
        this.m_serviceAddress = this.m_addressFactory.getSelfAddress();
        this.m_classLoader = classloader;
        this.m_metricsHelper = metricsHelper;
        this.m_messagesReceivedStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_RECEIVED);
        this.m_messagesReceivedIntraContainerStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_RECEIVED_INTRACONTAINER);
        this.m_messagesFaultedStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_FAULTED);
        this.m_averageProcessingTimeStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.AVERAGE_PROCESSING_TIME);
        this.m_messagesPerSecondStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_RECEIVED_PER_SECOND);
        this.m_messagesPerMinuteStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_RECEIVED_PER_MINUTE);
        this.m_messagesPerHourStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_RECEIVED_PER_HOUR);
        this.m_messagesSentToOutboxStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_SENT_TO_OUTBOX);
        this.m_listenersRefreshIntervalMaxActive = this.m_metricsHelper.getStatistic(XQServiceMetrics.LISTENERS_REFRESH_INTERVAL_MAX_ACTIVE);
        this.m_mfContainerName = this.m_environment.getParameter("SonicXQ.ContainerName", 1);
        this.m_mfFailoverIdentity = this.m_environment.getParameter("SonicXQ.FailoverIdentity", 1);
        this.m_serviceAppName = this.m_environment.getParameter("SonicXQ.ApplicationName", 1);
        this.m_serviceName = this.m_environment.getParameter("SonicXQ.ServiceName", 1);
        this.m_description = "XQDispatcher for application " + this.m_serviceAppName;
        this.m_rmeAddress = config.getRejectedMessageEndpoint();
        this.m_rejectedMessageDispatcher = new RejectedMessageDispatcher(this.m_metricsHelper);
        this.m_numListeners = Integer.parseInt(this.m_environment.getParameter("SonicXQ.Listeners", 1, "1"));
        this.m_numConcurrentCalls = Integer.parseInt(this.m_environment.getParameter("SonicXQ.ConcurrentCalls", 1, "1"));
        String resourcesName = "service " + this.m_serviceName;
        this.m_listenerUsageTime = new XQServiceMetrics.UsageStatisticProvider(resourcesName, this.m_numListeners);
        this.m_metricsHelper.setListenerUsage(this.m_listenerUsageTime);
        this.m_listenerAverageUsageTime = new XQServiceMetrics.UsageStatisticProvider(resourcesName, this.m_numListeners);
        this.m_metricsHelper.setListenerAverageUsage(this.m_listenerAverageUsageTime);
        this.m_eventDispatcher = eventDispatcher;
        this.m_lifeCycleManager = serviceLifeCycle;
        this.m_interactorFactory = interactorFactory;
        this.m_handler = new ServiceMessageHandler(service, this.m_serviceName, this.m_numConcurrentCalls, this.m_classLoader);
        this.m_handler.init(this.m_environment, this.m_endpointManager, this.m_messageFactory, envelopeFactory, this.m_accessorFactory, this.m_addressFactory, this.m_rmeAddress, this.m_eventDispatcher, this.m_lifeCycleManager, this.m_metricsHelper, this.m_rejectedMessageDispatcher, this.m_interactorFactory);
        String entryEndpoint = this.m_config.getEntryEndpoint();
        this.m_handler.setEntryEndpoint(entryEndpoint);
        this.addEndpointContextContainers(this.m_serviceAppName, entryEndpoint, this.m_numListeners);
    }

    public void addEndpointContextContainers(String svcAppName, Endpoint entryEndpt, int numListeners) {
        for (int i = 0; i < numListeners; ++i) {
            EndpointContextContainer ecc = new EndpointContextContainer(svcAppName + "_" + i, entryEndpt.getName(), this);
            ((InvocationEndpointManager)ecc.getEndpointRegistry()).registerEndpoint(entryEndpt.getName(), entryEndpt);
            this.m_endpointContexts.add(ecc);
        }
    }

    public void addEndpointContextContainers(String svcAppName, String entryEndpt, int numListeners) {
        for (int i = 0; i < numListeners; ++i) {
            EndpointContextContainer ecc = new EndpointContextContainer(svcAppName + "_" + i, entryEndpt, this);
            this.m_endpointContexts.add(ecc);
        }
    }

    protected void startEndpointContextContainers(String svcAppName, String entryEndpt) {
        try {
            for (EndpointContextContainer context : this.m_endpointContexts) {
                boolean hit = false;
                if (context.getName().startsWith(svcAppName + "_")) {
                    try {
                        Integer.parseInt(context.getName().substring(svcAppName.length() + 1));
                        hit = true;
                    }
                    catch (Throwable t) {
                        continue;
                    }
                }
                if (!hit) continue;
                context.start();
            }
        }
        catch (Exception e) {
            log.logError(this.toString() + " unable to start message listeners");
            log.logError((Throwable)e);
        }
    }

    protected void stopEndpointContextContainers(String svcAppName, String entryEndpt, boolean noWait) {
        try {
            for (EndpointContextContainer context : this.m_endpointContexts) {
                boolean hit = false;
                if (context.getName().startsWith(svcAppName + "_")) {
                    try {
                        Integer.parseInt(context.getName().substring(svcAppName.length() + 1));
                        hit = true;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (!hit) continue;
                context.stop(noWait);
            }
        }
        catch (Exception e) {
            log.logError(this.toString() + " unable to stop message listeners");
            log.logError((Throwable)e);
        }
    }

    protected void destroyEndpointContextContainers(String svcAppName, String entryEndpt) {
        try {
            Iterator contexts = this.m_endpointContexts.iterator();
            while (contexts.hasNext()) {
                boolean hit = false;
                EndpointContextContainer context = (EndpointContextContainer)contexts.next();
                if (context.getName().startsWith(svcAppName + "_")) {
                    try {
                        Integer.parseInt(context.getName().substring(svcAppName.length() + 1));
                        hit = true;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (!hit) continue;
                context.destroy();
                contexts.remove();
            }
        }
        catch (Exception e) {
            log.logError(this.toString() + " unable to stop message listeners");
            log.logError((Throwable)e);
        }
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getMFContainerName() {
        return this.m_mfContainerName;
    }

    public String getMFFailoverIdentity() {
        return this.m_mfFailoverIdentity;
    }

    public String getServiceAppName() {
        return this.m_serviceAppName;
    }

    public XQAddress getServiceAddress() {
        return this.m_serviceAddress;
    }

    public XQServiceConfig getServiceConfig() {
        return this.m_config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(EsbMessageExchange mex) {
        XQMessage message = mex.getInputMessage();
        EndpointContextContainer endpointContext = mex.getEndpointContext();
        if (XQContainer.isWaitForServiceToStartBeforeICMDispatch() && this.isIntraContainer(message)) {
            this.waitIfServiceStarting(message, endpointContext);
        }
        this.checkStopStatesOnInbound(message, endpointContext);
        ServiceMessageHandler handler = this.m_handler;
        XQMessageFactoryImpl newMessageFactory = new XQMessageFactoryImpl();
        try {
            XQAddress replyTo = message.getReplyTo();
            newMessageFactory.setReplyTo(replyTo);
            if (endpointContext != null && replyTo != null) {
                try {
                    if (replyTo.getType() == 0) {
                        endpointContext.addEndpoint(replyTo.getName());
                    }
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            }
            newMessageFactory.setCorrelationId(message.getCorrelationId());
            if (endpointContext != null) {
                newMessageFactory.setEndpointRegistry(endpointContext.getEndpointRegistry());
            }
        }
        catch (XQMessageException ex) {
            // empty catch block
        }
        XQParametersImpl params = new XQParametersImpl(this.m_environment);
        String uuid = this.getJERIUUID(message);
        RunContext runContext = this.getRunContext(message);
        this.setupMessageEnvironment(message, endpointContext, uuid, runContext);
        boolean responsibleForCleanup = RunUtils.setupJERIEnvironment(message);
        try {
            MessageHandler.SendBox sendBox = null;
            try {
                long startTime = System.currentTimeMillis();
                mex.populate((XQParameters)params, (EnvelopeFactory)this.m_envelopeFactory, newMessageFactory, this.m_rmeAddress, mex.isInProcess());
                sendBox = ((MessageHandler)handler).handleMessage(mex);
                this.updateMessagesReceivedStats(XQContainer.useIntraContainer());
                this.updateProcessingTimeStats(startTime);
            }
            catch (MessageAlreadyRejected msgRejected) {
            }
            catch (InvalidStateException invalidStateExcp) {
                if (this.handleServiceAborted(mex)) {
                    if (responsibleForCleanup) {
                        RunUtils.cleanupJERIEnvironment(message);
                    }
                    return;
                }
                throw invalidStateExcp;
            }
            catch (CriticalException e) {
                throw e;
            }
            catch (Throwable thrown) {
                this.m_rejectedMessageDispatcher.sendMessageToRME(thrown, message, mex.getRMEAddress(), "MESSAGE_RECEIPT_FAILURE", (XQParameters)params, endpointContext, mex.getMessageFactory(), this.m_description);
            }
            this.checkAbortingStateOnOutbound();
            if (sendBox != null) {
                XQAddress rmeAddress = mex.getRMEAddress();
                if (rmeAddress == null) {
                    rmeAddress = this.m_rmeAddress;
                }
                this.setupOutboundMessages(sendBox, uuid, runContext, (XQMessageInternal)message);
                this.setActionalHeaders(sendBox, message);
                if (!mex.isInProcess()) {
                    this.sendOutboxAndFaultMessages(sendBox, mex, (XQParameters)params, rmeAddress);
                } else {
                    mex.setSendBox(sendBox);
                }
            }
        }
        finally {
            if (responsibleForCleanup) {
                RunUtils.cleanupJERIEnvironment(message);
            }
        }
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.m_description + ": onMessage: done: returning");
        }
    }

    private void waitIfServiceStarting(XQMessage message, EndpointContextContainer endpointContext) {
        boolean waitForServiceToStart;
        boolean bl = waitForServiceToStart = this.m_lifeCycleManager.getCurrentServiceState() == XQState.STARTING || this.m_lifeCycleManager.getCurrentServiceState() != XQState.STARTED && this.m_lifeCycleManager.getContainerLifeCycleManager().getCurrentContainerState() == XQState.STARTING;
        if (waitForServiceToStart) {
            try {
                String entryEndpointName = endpointContext.getEntryEndpointName();
                long timeout = ((JMSEndpoint)endpointContext.getEndpoint(entryEndpointName)).getSendTimeout();
                log.logInformation(this.m_serviceName + " has not yet started.  Waiting up to " + timeout + " milliseconds (Send Timeout of endpoint " + entryEndpointName + ")" + " for service to start before sending message to service via intracontainer.");
                this.m_lifeCycleManager.waitForServiceStartedStateOrTimeout(timeout);
            }
            catch (XQEndpointCreationException e) {
                log.logWarning((Throwable)e);
            }
        }
    }

    private void sendOutboxAndFaultMessages(MessageHandler.SendBox sendBox, EsbMessageExchange mex, XQParameters params, XQAddress rmeAddress) {
        XQMessage message = mex.getInputMessage();
        try {
            mex.setXQParameters(params);
            List<XQEnvelope> mailbox = sendBox.getFaultbox();
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": onMessage sending " + (mailbox != null ? mailbox.size() : 0) + " fault message(s)");
            }
            if (mailbox != null && !mailbox.isEmpty()) {
                this.m_messagesFaultedStatistic.increment();
                MessageSendingHelper.sendEnvelopes(mailbox, mex, this.toString(), null);
            }
            mex.setXQParameters(params);
            mailbox = sendBox.getOutbox();
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": onMessage sending " + (mailbox != null ? mailbox.size() : 0) + " outbox message(s)");
            }
            if (mailbox != null && mailbox.size() > 0) {
                int count = MessageSendingHelper.sendEnvelopes(mailbox, mex, this.toString(), null);
                this.m_messagesSentToOutboxStatistic.updateValue(count);
            }
        }
        catch (MessageAlreadyRejected msgRejected) {
        }
        catch (CriticalException e) {
            throw e;
        }
        catch (Throwable thrown) {
            this.m_rejectedMessageDispatcher.sendMessageToRME(thrown, message, rmeAddress, "MESSAGE_SEND_FAILURE", params, mex.getEndpointContext(), mex.getMessageFactory(), this.m_description);
        }
    }

    void incrementFaultStatistic() {
        this.m_messagesFaultedStatistic.increment();
    }

    void updateOutboxStatistic(int count) {
        this.m_messagesSentToOutboxStatistic.updateValue(count);
    }

    private boolean isIntraContainer(XQMessage message) {
        if (message instanceof XQMessageInternal) {
            Object sender = ((XQMessageInternal)message).getSidebandProperty("SonicESB.IntraContainerSender");
            return sender != null;
        }
        return false;
    }

    private void updateMessagesReceivedStats(boolean intracontainer) {
        this.m_messagesReceivedStatistic.increment();
        this.m_messagesPerSecondStatistic.increment();
        this.m_messagesPerMinuteStatistic.increment();
        this.m_messagesPerHourStatistic.increment();
        if (intracontainer) {
            this.m_messagesReceivedIntraContainerStatistic.increment();
        }
    }

    private void updateProcessingTimeStats(long startTime) {
        long execTime = System.currentTimeMillis() - startTime;
        this.m_averageProcessingTimeStatistic.updateValue(execTime);
    }

    private String getActionalHeaderFromMsg(XQMessage message, String headerName) {
        String headerValue = null;
        try {
            if (message.containsHeader(headerName)) {
                headerValue = message.getStringHeader(headerName);
                log.logDebug("Actional related Header in incoming message " + headerName + " = " + headerValue);
            }
        }
        catch (XQMessageException e) {
            log.logDebug((Throwable)e);
        }
        return headerValue;
    }

    private void setActionalHeaders(MessageHandler.SendBox sendBox, XQMessage inputMsg) {
        try {
            String inputMsgLGHeader = this.getActionalHeaderFromMsg(inputMsg, LG_CORRELATION_HEADER_NAME);
            ESBVisitor visitor = ((XQMessageInternal)inputMsg).getVisitor();
            if (inputMsgLGHeader == null || visitor != null) {
                return;
            }
            boolean incomingMsgHasTrust = inputMsgLGHeader.indexOf("TrustSignature=") != -1;
            String lgReplyToHeader = this.getActionalHeaderFromMsg(inputMsg, REPLYTO_HEADER_NAME);
            List<XQEnvelope> mailbox = sendBox.getOutbox();
            if (mailbox != null && mailbox.size() > 0) {
                for (XQEnvelope env : mailbox) {
                    XQMessage outputMsg = env.getMessage();
                    if (incomingMsgHasTrust) {
                        outputMsg.removeHeader(LG_CORRELATION_HEADER_NAME);
                        continue;
                    }
                    outputMsg.setStringHeader(LG_CORRELATION_HEADER_NAME, inputMsgLGHeader);
                    if (lgReplyToHeader == null) continue;
                    outputMsg.setStringHeader(REPLYTO_HEADER_NAME, lgReplyToHeader);
                }
            }
        }
        catch (XQMessageException e) {
            log.logDebug((Throwable)e);
        }
    }

    private void setupMessageEnvironment(XQMessage message, EndpointContextContainer endpointContext, String uuid, RunContext runContext) {
        try {
            XQMessageInternal internalMsg = (XQMessageInternal)message;
            if (internalMsg.getSidebandProperty("SonicESB.OriginalEntryEndpoint") == null && endpointContext != null && endpointContext.getEntryEndpointName() != null) {
                internalMsg.addSidebandProperty("SonicESB.OriginalEntryEndpoint", endpointContext.getEntryEndpointName());
            }
            if (internalMsg.getSidebandProperty("SonicESB.CurrentEntryEndpoint") == null && endpointContext != null && endpointContext.getEntryEndpointName() != null) {
                internalMsg.addSidebandProperty("SonicESB.CurrentEntryEndpoint", endpointContext.getEntryEndpointName());
            }
            internalMsg.addSidebandProperty("SonicESB.BOX_TYPE", XQServiceConstants.INBOX);
            if (internalMsg.getSidebandProperty("SonicESB.JERI_UUID") == null && uuid != null) {
                internalMsg.addSidebandProperty("SonicESB.JERI_UUID", uuid);
            }
            if (internalMsg.getSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID") == null && runContext != null) {
                internalMsg.addSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID", runContext);
            }
        }
        catch (Throwable e) {
            log.logDebug(e);
        }
    }

    private void setupOutboundMessages(MessageHandler.SendBox sendBox, String uuid, RunContext runContext, XQMessageInternal message) {
        if (runContext != null && uuid != null) {
            String entryEndpointName = (String)message.getSidebandProperty("SonicESB.OriginalEntryEndpoint");
            List<XQEnvelope> mailbox = sendBox.getOutbox();
            if (mailbox != null && mailbox.size() > 0) {
                this.addRuleInfoToList(mailbox, uuid, runContext, entryEndpointName);
            }
            if ((mailbox = sendBox.getFaultbox()) != null && mailbox.size() > 0) {
                this.addRuleInfoToList(mailbox, uuid, runContext, entryEndpointName);
            }
        }
    }

    private void addRuleInfoToList(List<XQEnvelope> mailbox, String uuid, RunContext runContext, String entryEndpointName) {
        for (XQEnvelope env : mailbox) {
            XQMessageInternal msg = (XQMessageInternal)env.getMessage();
            msg.addSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID", runContext);
            msg.addSidebandProperty("SonicESB.JERI_UUID", uuid);
            msg.addSidebandProperty("SonicESB.OriginalEntryEndpoint", entryEndpointName);
        }
    }

    private String getJERIUUID(XQMessage msg) {
        String result = XQMessageUtil.getUUIDFromMessage(msg);
        if (result == null) {
            try {
                if (msg.containsHeader("SonicESB.REMOTE_JERI_UUID")) {
                    result = (String)msg.removeHeader("SonicESB.REMOTE_JERI_UUID");
                }
            }
            catch (XQMessageException e) {
                log.logDebug((Throwable)e);
            }
            catch (Throwable e) {
                log.logDebug(e);
            }
        }
        return result;
    }

    private RunContext getRunContext(XQMessage msg) {
        RunContext result = XQMessageUtil.getRunContextFromMessage(msg);
        try {
            byte[] testContextBytes;
            if (result == null && (testContextBytes = RunUtils.retrieveRunContext(msg)) != null) {
                result = RunUtils.unserializeRunContext(testContextBytes);
            }
        }
        catch (IOException e) {
            log.logDebug((Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.logDebug((Throwable)e);
            return null;
        }
        catch (XQMessageException e) {
            log.logDebug((Throwable)e);
            return null;
        }
        catch (Throwable e) {
            log.logDebug(e);
            return null;
        }
        return result;
    }

    public void onMessageImmediate(EsbMessageExchange mex) throws Throwable {
        this.checkAbortingStateOnInbound();
        ServiceMessageHandler handler = this.m_handler;
        XQMessage message = mex.getInputMessage();
        XQMessageFactoryImpl newMessageFactory = new XQMessageFactoryImpl();
        try {
            newMessageFactory.setReplyTo(message.getReplyTo());
            newMessageFactory.setCorrelationId(message.getCorrelationId());
        }
        catch (XQMessageException ex) {
            // empty catch block
        }
        XQParametersImpl params = new XQParametersImpl(this.m_environment);
        String uuid = this.getJERIUUID(message);
        RunContext runContext = this.getRunContext(message);
        this.setupMessageEnvironment(message, null, uuid, runContext);
        MessageHandler.SendBox sendBox = null;
        try {
            long startTime = System.currentTimeMillis();
            mex.populate((XQParameters)params, (EnvelopeFactory)this.m_envelopeFactory, newMessageFactory, this.m_rmeAddress, mex.isInProcess());
            sendBox = ((MessageHandler)handler).handleMessageImmediate(mex);
            this.updateMessagesReceivedStats(true);
            this.updateProcessingTimeStats(startTime);
        }
        catch (InvalidStateException invalidStateExcp) {
            if (this.handleServiceAborted(mex)) {
                return;
            }
            throw invalidStateExcp;
        }
        this.checkAbortingStateOnOutbound();
        if (sendBox != null) {
            this.setupOutboundMessages(sendBox, uuid, runContext, (XQMessageInternal)message);
            this.setActionalHeaders(sendBox, message);
            if (!mex.isInProcess()) {
                this.sendOutboxFaultMessagesImmediate(sendBox, mex);
            } else {
                mex.setSendBox(sendBox);
            }
        }
    }

    public XQParameters getBasicParameters() {
        return this.m_environment;
    }

    private void sendOutboxFaultMessagesImmediate(MessageHandler.SendBox sendBox, EsbMessageExchange mex) throws Throwable {
        try {
            List<XQEnvelope> envList;
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": onMessage: Regular Message: sending message(s)");
            }
            if ((envList = sendBox.getFaultbox()) != null && envList.size() > 0) {
                MessageSendingHelper.sendEnvelopesImmediate(envList, mex, this.toString(), null);
            }
            if ((envList = sendBox.getOutbox()) != null && envList.size() > 0) {
                MessageSendingHelper.sendEnvelopesImmediate(envList, mex, this.toString(), null);
            }
        }
        catch (Exception e) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": onMessageImmediate: caught exception: returning." + e.getMessage());
            }
            log.logError(this + " - ERROR: processing message.");
            throw e;
        }
    }

    public void start() {
        try {
            for (EndpointContextContainer context : this.m_endpointContexts) {
                context.start();
            }
        }
        catch (Exception e) {
            log.logError(this.toString() + " - ERROR: starting service.");
            log.logError((Throwable)e);
            this.m_lifeCycleManager.setLastError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            for (EndpointContextContainer context : this.m_endpointContexts) {
                context.stop();
            }
        }
        catch (Exception e) {
            log.logError(this.toString() + " unable to stop message listeners");
            log.logError((Throwable)e);
            this.m_lifeCycleManager.setLastError(e);
        }
        finally {
            if (this.m_lifeCycleManager.wasServiceAborted()) {
                this.m_handler.releaseAllLocks();
            }
        }
    }

    public void destroy() {
        this.m_handler.destroy();
        ListIterator iterator = this.m_endpointContexts.listIterator();
        while (iterator.hasNext()) {
            EndpointContextContainer context = (EndpointContextContainer)iterator.next();
            context.destroy();
            iterator.remove();
        }
        this.m_handler = null;
        this.m_accessorFactory = null;
        this.m_addressFactory = null;
        this.m_environment = null;
        this.m_endpointManager = null;
        this.m_messageFactory = null;
        this.m_lifeCycleManager = null;
        this.m_metricsHelper = null;
    }

    public void releaseTransientEndpoints() {
        if (this.m_endpointManager != null) {
            this.m_endpointManager.releaseTransientEndpoints();
        }
    }

    public String toString() {
        return this.m_description;
    }

    private void checkStopStatesOnInbound(XQMessage message, EndpointContextContainer endpointContext) {
        boolean isNotRunning;
        boolean dontProcessIncomingMsg = false;
        boolean aborting = false;
        boolean isContainer = true;
        boolean isContainerStopping = this.m_lifeCycleManager.getContainerLifeCycleManager().getCurrentContainerState() == XQState.STOPPING;
        XQState serviceState = this.m_lifeCycleManager.getCurrentServiceState();
        boolean isServiceRunning = serviceState == XQState.STARTED;
        boolean bl = isNotRunning = isContainerStopping || !isServiceRunning;
        if (isContainerStopping) {
            aborting = this.m_lifeCycleManager.getContainerLifeCycleManager().isContainerAborting();
        } else if (!isServiceRunning) {
            isContainer = false;
            aborting = this.m_lifeCycleManager.wasServiceAborted();
        }
        if (isNotRunning) {
            dontProcessIncomingMsg = this.m_config.getServiceType().equalsIgnoreCase("AsynchServiceType") || XQContainer.isIntraContainerMessageAcceptedOnStop() && this.isIntraContainer(message) ? aborting : true;
        }
        if (dontProcessIncomingMsg) {
            Session session;
            IJMSEntryEndpointState ees;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            InvalidStateException ise = isContainer || aborting ? new InvalidStateException("Not processing incoming message", this.m_serviceName, isContainer, aborting, serviceState == XQState.STOPPED) : new InvalidStateException("Not processing incoming message", this.m_serviceName, serviceState.toString());
            log.logDebug(ise.getMessage());
            if (isContainerStopping && (endpointContext.getQualityofService() == XQQualityofService.BEST_EFFORT || endpointContext.getQualityofService() == XQQualityofService.AT_LEAST_ONCE || endpointContext.getQualityofService() == XQQualityofService.AT_LEAST_ONCE_FAST) && !Boolean.getBoolean("com.sonicsw.xqimpl.service.disableConsumerCloseOnStop") && (ees = JMSEndpointStandalone.getJMSEntryEndpointState()) != null && (session = ees.getSession()) != null) {
                log.logInformation("Closing session '" + session.getSessionName() + "' to release further message consumption.");
                session.closeSession(false);
            }
            throw ise;
        }
    }

    private void checkAbortingStateOnInbound() {
        boolean aborting = false;
        boolean isContainer = true;
        if (this.m_lifeCycleManager.getContainerLifeCycleManager().isContainerAborting()) {
            aborting = true;
        } else if (this.m_lifeCycleManager.isServiceAborting()) {
            isContainer = false;
            aborting = true;
        }
        if (aborting) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            InvalidStateException ise = new InvalidStateException("Not processing incoming message", this.m_serviceName, isContainer, true, false);
            log.logDebug(ise.getMessage());
            throw ise;
        }
    }

    private void checkAbortingStateOnOutbound() {
        boolean aborting = false;
        boolean isContainer = true;
        if (this.m_lifeCycleManager.getContainerLifeCycleManager().wasContainerAborted()) {
            aborting = true;
        } else if (this.m_lifeCycleManager.wasServiceAborted()) {
            aborting = true;
            isContainer = false;
        }
        if (aborting) {
            InvalidStateException ise = new InvalidStateException("Not sending messages to fault/rme/exit", this.m_serviceName, isContainer, true, this.m_lifeCycleManager.getCurrentServiceState() == XQState.STOPPED);
            log.logDebug(ise.getMessage());
            throw ise;
        }
    }

    private boolean handleServiceAborted(EsbMessageExchange mex) {
        if (this.m_lifeCycleManager.getCurrentServiceState() == XQState.STOPPED && this.m_lifeCycleManager.wasServiceAborted()) {
            if (this.m_config.getEntryEndpoint() != null) {
                try {
                    log.logInformation("The service " + this.m_serviceName + " is aborted. Since the service has " + "an entry endpoint this message is being addressed to this endpoint");
                    XQAddress entryEPAddr = (XQAddress)this.m_environment.getParameterObject("SonicXQ.EntryEndpointAddress", 3);
                    String sender = "Redirect message for aborted service " + this.m_serviceName;
                    XQMessage message = mex.getInputMessage();
                    if (mex.getEndpointContext() != null) {
                        ArrayList<XQEnvelope> mailbox = new ArrayList<XQEnvelope>(1);
                        mailbox.add(this.m_envelopeFactory.createTargetedEnvelope(entryEPAddr, message));
                        this.addProcessMetadata(mex);
                        MessageSendingHelper.sendEnvelopes(mailbox, mex, sender, null);
                    } else {
                        mex.setExchangeImmediate(true);
                        mex.setDestinationAddress(entryEPAddr);
                        this.addProcessMetadata(mex);
                        MessageSendingHelper.sendToAddress(mex, sender);
                    }
                    return true;
                }
                catch (Throwable e) {
                    String errMsg = "The service " + this.m_serviceName + " is aborted. Error while attempting " + "to address message to its entry endpoint";
                    log.logError(errMsg);
                    throw new IllegalStateException(errMsg);
                }
            }
            String errMsg = "The service " + this.m_serviceName + " is aborted. Since the service is not " + "configured with an entry endpoint this message is being rejected";
            log.logError(errMsg);
            throw new IllegalStateException(errMsg);
        }
        return false;
    }

    private void addProcessMetadata(EsbMessageExchange mex) throws Throwable {
        Token token = (Token)mex.getXQParameters().getParameterObject("SonicESB.process.Token", 3);
        if (token != null) {
            ActivityNode node = ((XQProcessInstance)token.getProcessInstance()).getActiveEsbNode(token);
            XQContainer.getProcessEngine().getProcessInstanceSerializerFactory().createProcessInstanceSerializer().serialize(node, token);
        }
    }

    public void incremementListenerStatistics(Object listenerId) {
        this.m_listenersRefreshIntervalMaxActive.increment();
        this.m_listenerUsageTime.registerResourceStart(listenerId);
        this.m_listenerAverageUsageTime.registerResourceStart(listenerId);
    }

    public void decrementListenerStatistics(Object listenerId) {
        this.m_listenersRefreshIntervalMaxActive.decrement();
        this.m_listenerUsageTime.registerResourceEnd(listenerId);
        this.m_listenerAverageUsageTime.registerResourceEnd(listenerId);
    }

    class Debug {
        protected static final boolean DEBUG = false;

        Debug() {
        }
    }
}

