/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.interceptor.XQInterceptorService;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameterInfo;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceEx;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xq.XQState;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQServiceApplicationConfig;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.config.XQServiceTypeConfig;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.service.ContainerLifeCycleManager;
import com.sonicsw.xqimpl.service.ESBInteractorFactoryImpl;
import com.sonicsw.xqimpl.service.ESBSpringUtils;
import com.sonicsw.xqimpl.service.InstanceMetricCapable;
import com.sonicsw.xqimpl.service.ServiceLifeCycleManager;
import com.sonicsw.xqimpl.service.XQAppManager;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQDispatchImpl;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQEndpointManagerImpl;
import com.sonicsw.xqimpl.service.XQInitServiceContextImpl;
import com.sonicsw.xqimpl.service.XQRegistry;
import com.sonicsw.xqimpl.service.XQServiceChain;
import com.sonicsw.xqimpl.service.XQServiceMetrics;
import com.sonicsw.xqimpl.service.XQServiceNotifications;
import com.sonicsw.xqimpl.util.ClassLoaderManager;
import com.sonicsw.xqimpl.util.Holder;
import com.sonicsw.xqimpl.util.ValidationException;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.XQValidatingParams;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.util.spring.AutoWireableByType;
import com.sonicsw.xqimpl.util.spring.SonicContextLocator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ResourceLoader;

class XQServiceApplication {
    private int m_numListeners;
    private int m_numConcurrentCalls;
    private XQDispatcher m_dispatcher;
    private String m_appName;
    private String m_serviceName;
    private String m_serviceClassName;
    private XQValidatingParams m_params;
    private XQDispatch m_asyncDispatcher;
    private String m_serviceType;
    private HashMap<String, Method> m_methodCache = new HashMap();
    private ClassLoader m_classLoader;
    private ApplicationContext m_parentAppContext;
    private ApplicationContext m_appContext;
    private static XQLog log = XQLogImpl.getCategoryLog((int)1024);
    private XQService m_service = null;
    private Class m_serviceClass;
    private XQService m_baseService = null;
    private XQServiceConfig m_serviceConfig;
    private XQParametersImpl m_environment;
    private ServiceLifeCycleManager m_lifeCycleManager;
    private boolean m_initFailed;
    private boolean m_isBPEService;
    private final XQServiceMetrics m_metricsHelper = new XQServiceMetrics();
    private final XQServiceNotifications m_notificationsHelper = new XQServiceNotifications();
    private int m_startupPriorityLevel;

    public void preInit(XQServiceApplicationConfig config, ICanonicalName mfComponentCanonicalName, String mfFailoverIdentity, String xqContainerName) throws XQServiceException {
        this.m_numListeners = config.getInstances();
        this.m_appName = config.getServiceApplicationName();
        this.m_serviceName = config.getServiceName();
        this.m_startupPriorityLevel = config.getStartupPriorityLevel();
        if (this.m_numListeners <= 0) {
            throw new XQServiceException("The number of listeners for service '" + this.m_serviceName + "' must be greater than 0.");
        }
        XQParametersImpl serviceAppParams = config.getParameters();
        XQConfigManager configManager = XQConfigManager.getInstance(null);
        try {
            this.m_serviceConfig = configManager.lookupServiceConfig(this.m_serviceName);
        }
        catch (XQConfigurationException e) {
            try {
                configManager.lookupProcessConfig(this.m_serviceName);
                throw new XQServiceException("Deployed process '" + this.m_serviceName + "' does not have an entry endpoint - no listeners started.");
            }
            catch (XQConfigurationException ne) {
                throw new XQServiceException("Unable to find service in Directory", (Throwable)e);
            }
        }
        this.m_numConcurrentCalls = config.getConcurrentCallCount();
        int n = this.m_numConcurrentCalls = this.m_numConcurrentCalls == 0 ? this.m_numListeners : this.m_numConcurrentCalls;
        if (this.m_serviceConfig.isHidden() || this.m_serviceConfig.isBPEServiceType()) {
            this.m_numConcurrentCalls = -1;
        }
        if (this.m_numConcurrentCalls < -1) {
            throw new XQServiceException("The number of concurrent calls for service '" + this.m_serviceName + "' cannot be " + this.m_numConcurrentCalls + ".");
        }
        if (!this.m_serviceConfig.isHidden() || this.m_serviceConfig.isBPEServiceType()) {
            log.logInformation("Initializing " + this.displayServiceName());
        }
        XQParameters serviceParams = this.m_serviceConfig.getParameters();
        XQServiceTypeConfig serviceTypeConfig = null;
        try {
            serviceTypeConfig = configManager.lookupServiceTypeConfig(this.m_serviceConfig.getServiceType());
        }
        catch (XQConfigurationException e) {
            throw new XQServiceException("Unable to find serviceType in Directory", (Throwable)e);
        }
        this.m_serviceType = this.m_serviceConfig.getServiceType();
        this.m_serviceClassName = serviceTypeConfig.getClassname();
        this.m_isBPEService = serviceTypeConfig.isBPEServiceType();
        log.logDebug("Service classname: " + this.m_serviceClassName);
        String domainName = null;
        String containerName = null;
        String componentName = null;
        String serviceInstanceName = null;
        if (mfComponentCanonicalName != null) {
            domainName = mfComponentCanonicalName.getDomainName();
            containerName = mfComponentCanonicalName.getContainerName();
            componentName = mfComponentCanonicalName.getComponentName();
            serviceInstanceName = (mfFailoverIdentity != null ? mfFailoverIdentity : containerName) + "." + componentName + "." + this.m_serviceName;
        }
        this.m_environment = new XQParametersImpl();
        this.m_environment.setParameterObject("SonicXQ.ExitEndpointList", 3, new ArrayList(this.m_serviceConfig.getExitEndpoints()));
        this.m_environment.setParameterObject("SonicXQ.FaultEndpointAddress", 3, (Object)this.m_serviceConfig.getFaultEndpoint());
        this.m_environment.setParameterObject("SonicXQ.RejectedMessageEndpointAddress", 3, (Object)this.m_serviceConfig.getRejectedMessageEndpoint());
        this.m_environment.setParameter("SonicXQ.WSDLUrlContents", 2, null, this.m_serviceConfig.getWSDLUrl());
        this.m_environment.setParameter("SonicXQ.ServiceType", 1, this.m_serviceConfig.getServiceType());
        this.m_environment.setParameter("SonicXQ.ContainerName", 1, containerName);
        if (null != mfFailoverIdentity) {
            this.m_environment.setParameter("SonicXQ.FailoverIdentity", 1, mfFailoverIdentity);
        }
        this.m_environment.setParameter("SonicXQ.DomainName", 1, domainName);
        this.m_environment.setParameter("SonicXQ.xqContainerName", 1, xqContainerName);
        this.m_environment.setParameter("SonicXQ.ComponentName", 1, componentName);
        this.m_environment.setParameter("SonicXQ.ApplicationName", 1, this.m_appName);
        this.m_environment.setParameter("SonicXQ.Listeners", 1, String.valueOf(this.m_numListeners));
        this.m_environment.setParameter("SonicXQ.ConcurrentCalls", 1, String.valueOf(this.m_numConcurrentCalls));
        this.m_environment.setParameter("SonicXQ.ServiceName", 1, this.m_serviceName);
        this.m_environment.setParameter("SonicXQ.ServiceInstanceName", 1, serviceInstanceName);
        this.m_notificationsHelper.setEnvironment((XQParameters)this.m_environment);
        XQValidatingParams params = serviceTypeConfig.getParameters();
        this.m_params = params == null ? new XQValidatingParams() : (XQValidatingParams)params.clone();
        this.m_params.setParent((XQParameters)this.m_environment);
        if (serviceParams != null) {
            this.m_params.override(serviceParams);
        }
        if (serviceAppParams != null) {
            this.m_params.override((XQParameters)serviceAppParams);
        }
        this.m_classLoader = ClassLoaderManager.getInstance().getClassLoader(this.m_serviceConfig, serviceTypeConfig);
    }

    private String displayServiceName() {
        if (!this.m_serviceConfig.isHidden()) {
            return "Service `" + this.m_serviceName + "`";
        }
        if (this.m_serviceConfig.isBPEServiceType()) {
            return "Deployed process `" + this.m_serviceName + "`";
        }
        throw new IllegalStateException();
    }

    public void setApplicationContext(ApplicationContext appContext) {
        this.m_parentAppContext = appContext;
    }

    void instantiateService(XQMessageFactory messageFactory) throws XQServiceException {
        ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)this.m_classLoader);
        try {
            this.m_params.validate();
            this.m_asyncDispatcher = new XQDispatchImpl();
            ((XQDispatchImpl)this.m_asyncDispatcher).init(this.m_serviceName, messageFactory, (XQParameters)this.m_environment, this.m_metricsHelper);
            this.m_serviceClass = Class.forName(this.m_serviceClassName, true, this.m_classLoader);
            this.initializeApplicationContext();
            Object serviceInstance = this.m_appContext != null ? this.getServiceBean() : this.m_serviceClass.newInstance();
            this.m_baseService = this.m_service = (XQService)serviceInstance;
        }
        catch (ValidationException e) {
            throw new XQServiceException("Invalid parameters passed to service", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new XQServiceException("Unable to find service class", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new XQServiceException("Service class must implement XQService", (Throwable)e);
        }
        catch (Exception e) {
            throw new XQServiceException("Error instantiating service application", (Throwable)e);
        }
        finally {
            ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
        }
        if (!this.m_serviceConfig.isHidden() || this.m_serviceConfig.isBPEServiceType()) {
            String initInfo = this.displayServiceName() + " initialized: " + (this.m_serviceConfig.getEntryEndpoint() != null ? this.m_numListeners + " thread(s) listening on Endpoint " + this.m_serviceConfig.getEntryEndpoint() : "Entry Endpoint is null");
            initInfo = initInfo + ".  Startup priority level is '" + this.m_startupPriorityLevel + "'.";
            if (!this.m_serviceConfig.isBPEServiceType()) {
                initInfo = initInfo + "  Concurrent calls are " + (this.m_numConcurrentCalls == -1 ? "unlimited" : "'" + this.m_numConcurrentCalls + "'") + ".";
            }
            log.logInformation(initInfo);
        }
    }

    private void initializeApplicationContext() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.m_parentAppContext == null) {
            return;
        }
        GenericApplicationContext ctx = ESBSpringUtils.createApplicationContext("ESBServiceApplicationContext_" + this.m_serviceName);
        ctx.setClassLoader(this.m_classLoader);
        ctx.setResourceLoader((ResourceLoader)Class.forName("com.sonicsw.xqimpl.util.spring.SonicResourceLoader", true, this.m_classLoader).newInstance());
        ctx.setParent(this.m_parentAppContext);
        ctx.getBeanFactory().registerSingleton("initParameters", (Object)this.m_params);
        PropertyPlaceholderConfigurer propertyProcessor = new PropertyPlaceholderConfigurer();
        propertyProcessor.setProperties(this.getServiceProperties());
        propertyProcessor.setOrder(Integer.MIN_VALUE);
        propertyProcessor.setIgnoreUnresolvablePlaceholders(true);
        ctx.getBeanFactory().registerSingleton("servicePropertyConfigurer", (Object)propertyProcessor);
        String locatorKey = "ESBServiceApplicationContext_LocatorKey_" + this.m_serviceName;
        RootBeanDefinition locatorBeanDef = new RootBeanDefinition(SonicContextLocator.class, 2);
        ctx.registerBeanDefinition(locatorKey, (BeanDefinition)locatorBeanDef);
        ESBSpringUtils.readBeanConfigurationsFromClassPath("classpath*:config/esb/serviceAppContext.xml", (BeanDefinitionRegistry)ctx);
        ESBSpringUtils.readBeanConfigurationsFromClassPath("classpath*:META-INF/sonic/*.xml", (BeanDefinitionRegistry)ctx);
        if (ctx.getBeanNamesForType(this.m_serviceClass).length == 0) {
            int autowired = AutoWireableByType.class.isAssignableFrom(this.m_serviceClass) ? 2 : 0;
            RootBeanDefinition beanDef = new RootBeanDefinition(this.m_serviceClass, autowired);
            ctx.registerBeanDefinition(this.m_serviceName, (BeanDefinition)beanDef);
        }
        ctx.refresh();
        this.m_appContext = ctx;
    }

    private Properties getServiceProperties() {
        Properties props = new Properties();
        Iterator iter = this.m_environment.getAllInfo(1);
        while (iter.hasNext()) {
            XQParameterInfo info = (XQParameterInfo)iter.next();
            props.put(info.getName(), info.getValue());
        }
        props.put("SonicXQ.ServiceClassName", this.m_serviceClassName);
        return props;
    }

    private Object getServiceBean() throws XQServiceException {
        Map serviceBeans = XQServiceEx.class.isAssignableFrom(this.m_serviceClass) ? this.m_appContext.getBeansOfType(XQServiceEx.class) : this.m_appContext.getBeansOfType(XQService.class);
        if (serviceBeans.size() != 1) {
            throw new XQServiceException("Found '" + serviceBeans.size() + "' instances of service class: " + this.m_serviceClassName);
        }
        Object serviceInstance = serviceBeans.values().iterator().next();
        log.logDebug("Obtained service instance from application context.");
        return serviceInstance;
    }

    public void initializeInterceptors(XQAppManager appManager) {
        List interceptors = this.m_serviceConfig.getInterceptorServices();
        if (XQContainer.isTestContainer()) {
            interceptors.add("DebugServiceInterceptor");
        }
        if (interceptors.size() == 0) {
            return;
        }
        boolean serviceChained = false;
        XQServiceChain chain = new XQServiceChain(this.m_service);
        for (String interceptorServiceName : interceptors) {
            XQServiceApplication interceptorApp = appManager.getServiceApplication(interceptorServiceName);
            if (interceptorApp == null) continue;
            XQService interceptorService = interceptorApp.m_baseService;
            if (interceptorService instanceof XQInterceptorService) {
                chain.addInterceptorService((XQInterceptorService)interceptorService);
                serviceChained = true;
                continue;
            }
            log.logWarning("Specified service is not an interceptor: " + interceptorServiceName);
        }
        if (serviceChained) {
            this.m_service = chain;
        }
    }

    public void postInit(XQMessageFactory messageFactory, XQAccessorFactory accessorFactory, ContainerLifeCycleManager containerLifeCycle) throws XQServiceException {
        XQEndpointManagerImpl endpointManager;
        this.m_lifeCycleManager = new ServiceLifeCycleManager(this, containerLifeCycle, this.m_notificationsHelper, log);
        XQAddressFactoryImpl addressFactory = null;
        try {
            XQAddress entryEndpointAddress = null;
            String entryEndpointName = this.m_serviceConfig.getEntryEndpoint();
            endpointManager = new XQEndpointManagerImpl(this.m_serviceName, entryEndpointName);
            addressFactory = new XQAddressFactoryImpl(this.m_serviceName, 1, endpointManager);
            if (entryEndpointName != null) {
                entryEndpointAddress = addressFactory.createAddress(entryEndpointName, 0);
            }
            this.m_environment.setParameterObject("SonicXQ.EntryEndpointAddress", 3, (Object)entryEndpointAddress);
        }
        catch (XQAddressNotFoundException e) {
            throw new XQServiceException("Unable to find Entry Endpoint (" + this.m_serviceConfig.getEntryEndpoint() + ") address in Directory", (Throwable)e);
        }
        EnvelopeFactory envelopeFactory = new EnvelopeFactory();
        envelopeFactory.init(addressFactory);
        ESBInteractorFactoryImpl interactorFactory = new ESBInteractorFactoryImpl((XQParameters)this.m_params, this.m_asyncDispatcher);
        Iterator exits = this.m_serviceConfig.getExitEndpoints().iterator();
        while (exits.hasNext()) {
            envelopeFactory.addOutputAddress((XQAddress)exits.next());
        }
        envelopeFactory.setFaultAddress(this.m_serviceConfig.getFaultEndpoint());
        ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)this.m_classLoader);
        try {
            this.m_dispatcher = new XQDispatcher();
            this.m_dispatcher.init(this.m_service, this.m_serviceConfig, endpointManager, messageFactory, accessorFactory, addressFactory, (XQParameters)this.m_environment, this.m_asyncDispatcher, envelopeFactory, this.m_classLoader, this.m_lifeCycleManager, this.m_metricsHelper, interactorFactory);
            XQRegistry.instance().registerService(this.m_serviceName, this.m_dispatcher);
            this.m_service.init((XQInitContext)new XQInitServiceContextImpl((XQParameters)this.m_params, addressFactory, endpointManager, envelopeFactory, messageFactory, this.m_asyncDispatcher, this.m_dispatcher, interactorFactory));
            this.m_lifeCycleManager.setServiceState(XQState.STOPPED);
        }
        catch (Exception e) {
            throw new XQServiceException("Error starting service application", (Throwable)e);
        }
        finally {
            ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(String methodName, String[] paramTypes, Object[] paramVals) throws Exception {
        Method method;
        if (methodName == null) {
            return null;
        }
        String methodKey = methodName;
        Class[] paramClasses = null;
        if (paramTypes != null) {
            paramClasses = new Class[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                try {
                    paramClasses[i] = paramTypes[i].equals(Boolean.TYPE.getName()) ? Boolean.TYPE : (paramTypes[i].equals(Integer.TYPE.getName()) ? Integer.TYPE : (paramTypes[i].equals(Long.TYPE.getName()) ? Long.TYPE : (paramTypes[i].equals(Double.TYPE.getName()) ? Double.TYPE : (paramTypes[i].equals(Float.TYPE.getName()) ? Float.TYPE : (paramTypes[i].equals(Byte.TYPE.getName()) ? Byte.TYPE : (paramTypes[i].equals(Character.TYPE.getName()) ? Character.TYPE : (paramTypes[i].equals(Void.TYPE.getName()) ? Void.TYPE : Class.forName(paramTypes[i], true, this.m_classLoader))))))));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    paramClasses[i] = paramVals[i].getClass();
                }
                methodKey = methodKey + ":" + paramTypes[i];
            }
        } else {
            paramClasses = new Class[]{};
        }
        if ((method = this.m_methodCache.get(methodKey)) == null) {
            method = this.m_serviceClass.getMethod(methodName, paramClasses);
            this.m_methodCache.put(methodKey, method);
        }
        if (paramVals != null && paramVals.length == 0) {
            paramVals = null;
        }
        Object[] params = null;
        if (paramVals != null) {
            params = new Object[paramVals.length];
            for (int i = 0; i < paramVals.length; ++i) {
                Holder holder = (Holder)paramVals[i];
                try {
                    if (paramVals[i] == null) continue;
                    params[i] = holder.getObject(this.m_classLoader);
                    continue;
                }
                catch (Exception e) {
                    log.logError("Unable to deserialize parameter value for " + paramVals[i]);
                    log.logError((Throwable)e);
                    params[i] = paramVals[i];
                }
            }
        }
        Object obj = null;
        ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)this.m_classLoader);
        try {
            obj = method.invoke((Object)this.m_baseService, params);
        }
        finally {
            ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
        }
        return obj == null ? obj : new Holder(obj);
    }

    public String getServiceType() {
        return this.m_serviceType;
    }

    public XQLifeCycleManager getLifeCycleManager() {
        return this.m_lifeCycleManager;
    }

    public boolean isBPEService() {
        return this.m_isBPEService;
    }

    public boolean isUnlimitedConcurrentCalls() {
        return this.m_numConcurrentCalls == -1;
    }

    void start() throws Throwable {
        if (this.m_initFailed) {
            log.logWarning("Cannot start service " + this.m_serviceName + " due to initialization error.");
            return;
        }
        try {
            this.m_lifeCycleManager.setServiceState(XQState.STARTING);
            if (this.m_asyncDispatcher != null) {
                ((XQDispatchImpl)this.m_asyncDispatcher).start();
            }
            if (this.m_service != null && this.m_service instanceof XQServiceEx) {
                ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)this.m_classLoader);
                try {
                    ((XQServiceEx)this.m_service).start();
                }
                catch (Error err) {
                    log.logError("Error thrown by XQServiceEx start method");
                    throw err;
                }
                catch (RuntimeException excp) {
                    log.logError("Exception thrown by XQServiceEx start method");
                    throw excp;
                }
                finally {
                    ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
                }
            }
            if (this.m_dispatcher != null) {
                this.m_dispatcher.start();
            }
            this.m_lifeCycleManager.setServiceState(XQState.STARTED);
            this.m_notificationsHelper.sendNotification("Started");
            log.logDebug("Service " + this.m_serviceName + " has been started successfuly");
        }
        catch (Throwable thrown) {
            this.m_notificationsHelper.sendErrorNotification("StartFailure", thrown);
            this.m_lifeCycleManager.setServiceState(XQState.STOPPED);
            throw thrown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws Throwable {
        if (this.m_initFailed) {
            log.logWarning("Stop not called on service " + this.m_serviceName + " as it was " + " not started due to an initialization error.");
            return;
        }
        try {
            this.m_lifeCycleManager.setServiceState(XQState.STOPPING);
            if (this.m_service != null && this.m_service instanceof XQServiceEx) {
                ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)this.m_classLoader);
                try {
                    ((XQServiceEx)this.m_service).stop();
                }
                catch (Throwable e) {
                    log.logError("The following exception was thrown by XQServiceEx stop method for " + this.m_serviceName + ". Continuing with the attempt to stop the service application");
                    log.logError(e);
                    this.m_lifeCycleManager.setLastError(e);
                }
                finally {
                    ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
                }
            }
            if (this.m_dispatcher != null) {
                this.m_dispatcher.stop();
            }
            if (this.m_asyncDispatcher != null) {
                ((XQDispatchImpl)this.m_asyncDispatcher).stop();
            }
            this.m_lifeCycleManager.setServiceState(XQState.STOPPED);
            this.m_notificationsHelper.sendNotification("Stopped");
            log.logDebug("Service " + this.m_serviceName + " has been stopped successfuly");
        }
        catch (Throwable thrown) {
            this.m_notificationsHelper.sendErrorNotification("StopFailure", thrown);
            this.m_lifeCycleManager.setLastError(thrown);
            throw thrown;
        }
        finally {
            this.m_lifeCycleManager.setServiceState(XQState.STOPPED);
        }
    }

    void destroy() {
        XQRegistry.instance().unregisterService(this.m_serviceName);
        if (this.m_dispatcher != null) {
            this.m_dispatcher.destroy();
        }
        if (this.m_asyncDispatcher != null) {
            ((XQDispatchImpl)this.m_asyncDispatcher).destroy();
        }
        this.m_methodCache = null;
    }

    void releaseTransientEndpoints() {
        if (this.m_dispatcher != null) {
            this.m_dispatcher.releaseTransientEndpoints();
        }
    }

    protected String getName() {
        return this.m_appName;
    }

    String getServiceName() {
        return this.m_serviceName;
    }

    XQServiceNotifications getNotificationsHelper() {
        return this.m_notificationsHelper;
    }

    void setInitFailed(boolean value) {
        this.m_initFailed = value;
    }

    void enableInstanceMetric(IMetricsRegistrar metricsRegistrar, IMetricIdentity id) {
        IStatistic stat = null;
        if (this.m_metricsHelper.managesMetric(id)) {
            stat = this.m_metricsHelper.enableInstanceMetric(id);
        } else if (InstanceMetricCapable.class.isAssignableFrom(this.m_serviceClass)) {
            stat = ((InstanceMetricCapable)this.m_baseService).enableInstanceMetric(id);
        }
        if (stat != null) {
            metricsRegistrar.registerMetric(MetricsFactory.createMetricIdentity((IMetricIdentity)id, (String)this.getServiceName()), stat);
        }
    }

    void disableInstanceMetric(IMetricsRegistrar metricsRegistrar, IMetricIdentity id) {
        if (this.m_metricsHelper.managesMetric(id)) {
            this.m_metricsHelper.disableInstanceMetric(id);
        } else if (InstanceMetricCapable.class.isAssignableFrom(this.m_serviceClass)) {
            ((InstanceMetricCapable)this.m_baseService).disableInstanceMetric(id);
        }
        metricsRegistrar.unregisterMetric(MetricsFactory.createMetricIdentity((IMetricIdentity)id, (String)this.m_serviceName));
    }
}

