/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.ws.addressing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

public class AddressingUtils {
    private static final Set ADDRESSING_NS_SET = new HashSet();
    private static final Set ADDRESSING_FAULT_SET = new HashSet();
    private static final Set ADDRESSING_ANON_URI_SET = new HashSet();
    private static final HashMap ADDRESSING_BINDING_URI_SET = new HashMap();
    private static final Set ADDRESSING_ACTION_QNAME_SET = new HashSet();
    public static final String NS_URI_WSAW_2006_05 = "http://www.w3.org/2006/05/addressing/wsdl";
    public static final String NS_URI_WSA_POLICY_2004_08 = "http://schemas.xmlsoap.org/ws/2004/08/addressing/policy";

    public static Iterator getAddressingURIs() {
        return ADDRESSING_NS_SET.iterator();
    }

    public static Iterator getAddressingBindingURIs() {
        return ADDRESSING_BINDING_URI_SET.keySet().iterator();
    }

    public static String getDefaultNS() {
        String nsURI = System.getProperty("addressing.namespace.URI");
        if (nsURI != null) {
            return nsURI;
        }
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    }

    public static boolean isAddressingNS(String s) {
        return ADDRESSING_NS_SET.contains(s);
    }

    public static boolean isAddressingBindingNS(String s) {
        return s != null && AddressingUtils.addressingNSFromBindingNS(s) != null;
    }

    public static String addressingNSFromBindingNS(String s) {
        String addNS = (String)ADDRESSING_BINDING_URI_SET.get(s);
        return addNS;
    }

    public static boolean isAnonymousURI(String s) {
        return ADDRESSING_ANON_URI_SET.contains(s);
    }

    public static boolean isFaultURI(String s) {
        return ADDRESSING_FAULT_SET.contains(s);
    }

    public static boolean isActionQName(String s) {
        return ADDRESSING_ACTION_QNAME_SET.contains(s);
    }

    public static QName getResponseRelationshipType(String nsURI) {
        if (nsURI.equals("http://schemas.xmlsoap.org/ws/2003/03/addressing")) {
            return new QName(nsURI, "Response");
        }
        return new QName(nsURI, "Reply");
    }

    public static String getAnonymousRoleURI(String namespaceURI) {
        if ("http://www.w3.org/2005/08/addressing".equals(namespaceURI)) {
            return "http://www.w3.org/2005/08/addressing/anonymous";
        }
        return namespaceURI + "/role/anonymous";
    }

    static {
        ADDRESSING_ACTION_QNAME_SET.add(new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Action").toString());
        ADDRESSING_ACTION_QNAME_SET.add(new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Action").toString());
        ADDRESSING_ACTION_QNAME_SET.add(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action").toString());
        ADDRESSING_ACTION_QNAME_SET.add(new QName("http://www.w3.org/2005/08/addressing", "Action").toString());
        ADDRESSING_NS_SET.add("http://schemas.xmlsoap.org/ws/2003/03/addressing");
        ADDRESSING_NS_SET.add("http://schemas.xmlsoap.org/ws/2004/03/addressing");
        ADDRESSING_NS_SET.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        ADDRESSING_NS_SET.add("http://www.w3.org/2005/08/addressing");
        ADDRESSING_BINDING_URI_SET.put("http://schemas.xmlsoap.org/ws/2003/03/addressing/wsdl", "http://schemas.xmlsoap.org/ws/2003/03/addressing");
        ADDRESSING_BINDING_URI_SET.put("http://schemas.xmlsoap.org/ws/2004/03/addressing/wsdl", "http://schemas.xmlsoap.org/ws/2004/03/addressing");
        ADDRESSING_BINDING_URI_SET.put("http://schemas.xmlsoap.org/ws/2004/08/addressing/wsdl", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        ADDRESSING_BINDING_URI_SET.put(NS_URI_WSA_POLICY_2004_08, "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        ADDRESSING_BINDING_URI_SET.put("http://www.w3.org/2005/08/addressing/wsdl", "http://www.w3.org/2005/08/addressing");
        ADDRESSING_BINDING_URI_SET.put(NS_URI_WSAW_2006_05, "http://www.w3.org/2005/08/addressing");
        ADDRESSING_FAULT_SET.add("http://schemas.xmlsoap.org/ws/2003/03/addressing/fault");
        ADDRESSING_FAULT_SET.add("http://schemas.xmlsoap.org/ws/2004/03/addressing/fault");
        ADDRESSING_FAULT_SET.add("http://schemas.xmlsoap.org/ws/2004/08/addressing/fault");
        ADDRESSING_FAULT_SET.add("http://www.w3.org/2005/08/addressing/fault");
        ADDRESSING_ANON_URI_SET.add("http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous");
        ADDRESSING_ANON_URI_SET.add("http://schemas.xmlsoap.org/ws/2004/03/addressing/role/anonymous");
        ADDRESSING_ANON_URI_SET.add("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
        ADDRESSING_ANON_URI_SET.add("http://www.w3.org/2005/08/addressing/anonymous");
    }
}

