/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import modelobjects.expr.Expression;
import modelobjects.expr.PostEvalConverter;
import modelobjects.expr.RootObjectReference;
import modelobjects.util.PropertiesAccess;

public class PropertyExpression
extends Expression {
    protected boolean caseSensitive;
    protected String propertyName;
    protected Expression base;
    private Class cachedObjClass;
    private PropertyDescriptor cachedPropDesc;
    private Field cachedField;
    private static Map beanInfoHash;

    public PropertyExpression(String propertyName, Expression base, boolean caseSensitive) {
        this.propertyName = propertyName;
        this.base = base == null ? new RootObjectReference() : base;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean isPropertyExpression() {
        return true;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.cachedPropDesc;
    }

    @Override
    protected Object eval1(Object rootObject, PostEvalConverter cvtr, int rule) throws Exception {
        Object baseValue;
        Object object = baseValue = this.base == null ? rootObject : this.base.eval(rootObject, cvtr, rule);
        if (baseValue == null) {
            throw new NullPointerException("Null base for " + this.propertyName);
        }
        if (baseValue instanceof Dictionary) {
            return this.getDictionaryValue((Dictionary)baseValue, this.propertyName);
        }
        if (baseValue instanceof PropertiesAccess) {
            return ((PropertiesAccess)baseValue).getProperty(this.propertyName);
        }
        if ("length".equals(this.propertyName) && baseValue.getClass().isArray()) {
            return new Integer(Array.getLength(baseValue));
        }
        if (rule == Expression.SCRIPT_EVAL && "length".equals(this.propertyName) && baseValue instanceof Vector) {
            return new Integer(((Vector)baseValue).size());
        }
        PropertyDescriptor propDesc = this.getPropertyDescriptor(baseValue);
        if (propDesc == null) {
            Field field = this.getPropertyField(baseValue);
            if (field == null) {
                throw new RuntimeException("No such property: " + this.propertyName + " in " + baseValue.getClass());
            }
            return field.get(baseValue);
        }
        Method getterMethod = propDesc.getReadMethod();
        if (getterMethod == null) {
            throw new RuntimeException("No read method for: " + this.propertyName);
        }
        return getterMethod.invoke(baseValue, null);
    }

    public String toString() {
        if (this.base instanceof RootObjectReference) {
            return this.propertyName;
        }
        return this.base.toString() + "." + this.propertyName;
    }

    private boolean equiv(String s1, String s2) {
        if (s1 == s2 || s1.equals(s2)) {
            return true;
        }
        if (this.caseSensitive) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    private Object getDictionaryValue(Dictionary dict, String propName) {
        Object val = dict.get(propName);
        if (val == null && !this.caseSensitive) {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!propName.equals(key)) continue;
                val = dict.get(key);
                break;
            }
        }
        return val;
    }

    private Field getPropertyField(Object baseObj) {
        String propName = this.propertyName;
        Class<?> objClass = baseObj.getClass();
        if (objClass == this.cachedObjClass) {
            return this.cachedField;
        }
        for (Field field : objClass.getFields()) {
            String name = field.getName();
            if (!this.equiv(name, propName)) continue;
            this.cachedObjClass = objClass;
            this.cachedField = field;
            return field;
        }
        return null;
    }

    private synchronized BeanInfo getBeanInfo(Class objClass) {
        BeanInfo result;
        if (beanInfoHash == null) {
            beanInfoHash = new Hashtable();
        }
        if ((result = (BeanInfo)beanInfoHash.get(objClass)) == null) {
            try {
                result = Introspector.getBeanInfo(objClass);
                beanInfoHash.put(objClass, result);
            }
            catch (IntrospectionException noBeanInfo) {
                System.out.println("Introspection error: " + noBeanInfo);
            }
        }
        return result;
    }

    private PropertyDescriptor getPropertyDescriptor(Object baseObj) {
        String propName = this.propertyName;
        Class<?> objClass = baseObj.getClass();
        while (objClass != null) {
            if (objClass == this.cachedObjClass) {
                return this.cachedPropDesc;
            }
            String propertyName = this.propertyName;
            BeanInfo bInfo = this.getBeanInfo(objClass);
            if (bInfo != null) {
                PropertyDescriptor[] descs = bInfo.getPropertyDescriptors();
                int numProps = descs == null ? 0 : descs.length;
                for (int i = 0; i < numProps; ++i) {
                    PropertyDescriptor desc = descs[i];
                    String name = desc.getName();
                    if (!this.equiv(name, propName)) continue;
                    this.cachedObjClass = objClass;
                    this.cachedPropDesc = desc;
                    return desc;
                }
            }
            objClass = null;
        }
        return null;
    }
}

