/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import java.beans.BeanInfo;
import modelobjects.expr.EvaluationResult;
import modelobjects.expr.Expression;
import modelobjects.expr.PropertyExpression;
import modelobjects.template.TemplateProcessor;
import modelobjects.util.PropertiesAccess;

class BeanWrapper
implements PropertiesAccess {
    private Object bean;
    private transient BeanInfo beanInfo;

    BeanWrapper(Object bean) {
        this.bean = bean;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (this.bean == null) {
            return null;
        }
        PropertyExpression propExpr = new PropertyExpression(propertyName, null, true);
        EvaluationResult evalResult = propExpr.evaluate(this.bean, Expression.SCRIPT_EVAL);
        if (evalResult.getException() != null) {
            if (TemplateProcessor.isStackTraceOnErrorEnabled()) {
                evalResult.getException().printStackTrace(System.err);
            } else {
                System.err.println(evalResult.getException().getMessage());
            }
        }
        return evalResult.getValue();
    }

    Object getBean() {
        return this.bean;
    }
}

