/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;

abstract class TagParser {
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';

    abstract TemplateFragment extractFragment(TemplateParser var1, int var2);

    TagParser() {
    }

    static int tagEndPos(int startPos, char[] source, int sourceLength) {
        char quoteChar = '\"';
        boolean inString = false;
        block5: for (int i = startPos; i < sourceLength; ++i) {
            switch (source[i]) {
                case '>': {
                    if (inString) continue block5;
                    return i;
                }
                case '\\': {
                    if (!inString) continue block5;
                    ++i;
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    if (!inString) {
                        inString = true;
                        quoteChar = source[i];
                        continue block5;
                    }
                    if (source[i] != quoteChar) continue block5;
                    inString = false;
                }
            }
        }
        return -1;
    }

    static int nextTagPos(int startPos, char[] source, int sourceLength) {
        for (int i = startPos; i < sourceLength; ++i) {
            if (source[i] != '<') continue;
            return i;
        }
        return -1;
    }

    boolean tagNameMatches(char[] source, int startPos, int len, String upperName, String lowerName) {
        int a = startPos + 1;
        int n = upperName.length();
        for (int i = 0; i < n && a < len; ++a, ++i) {
            char c = source[a];
            if (c == upperName.charAt(i) || c == lowerName.charAt(i)) continue;
            return false;
        }
        return a < len && !Character.isLetterOrDigit(source[a]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TagAttribute[] collectAttributes(String attrsString, char[] source, int pos) {
        StreamTokenizer toks = new StreamTokenizer(new StringReader(attrsString));
        toks.resetSyntax();
        toks.eolIsSignificant(false);
        toks.whitespaceChars(32, 32);
        toks.whitespaceChars(9, 9);
        toks.whitespaceChars(10, 10);
        toks.whitespaceChars(13, 13);
        toks.wordChars(97, 122);
        toks.wordChars(65, 90);
        toks.wordChars(48, 57);
        toks.wordChars(95, 95);
        toks.quoteChar(34);
        toks.quoteChar(39);
        toks.wordChars(46, 46);
        toks.wordChars(45, 45);
        Vector<TagAttribute> collectedAttrs = new Vector<TagAttribute>(4);
        int ttype = 0;
        boolean hadErrors = false;
        while (ttype != -1) {
            String attrValue;
            String attrName;
            block6: {
                attrName = "";
                attrValue = null;
                try {
                    block8: {
                        block9: {
                            block7: {
                                ttype = toks.nextToken();
                                if (ttype == -1) break;
                                if (ttype != -3 && ttype != 39 && ttype != 34) break block7;
                                attrValue = toks.sval;
                                ttype = toks.nextToken();
                                if (ttype != 61) break block8;
                                break block9;
                            }
                            hadErrors = true;
                            continue;
                        }
                        attrName = attrValue;
                        ttype = toks.nextToken();
                        if (ttype == -3 || ttype == 39 || ttype == 34) {
                            attrValue = toks.sval;
                            break block6;
                        } else {
                            hadErrors = true;
                            continue;
                        }
                    }
                    toks.pushBack();
                }
                catch (IOException ioe) {
                    continue;
                }
            }
            collectedAttrs.addElement(new TagAttribute(attrName, attrValue));
        }
        if (hadErrors) {
            System.err.println("Error parsing attributes in '" + attrsString + "' on line " + TemplateParser.lineNumber(source, pos));
        }
        Object[] result = new TagAttribute[collectedAttrs.size()];
        collectedAttrs.copyInto(result);
        return result;
    }

    static class TagAttribute {
        private String attrName;
        private String attrValue;

        TagAttribute(String attrName, String attrValue) {
            this.attrName = attrName;
            this.attrValue = attrValue;
        }

        String getAttrName() {
            return this.attrName;
        }

        String getAttrValue() {
            return this.attrValue;
        }
    }
}

