/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.expr.EvaluationResult;
import modelobjects.expr.Expression;
import modelobjects.template.TemplateException;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateProcessor;

class VariableFragment
extends TemplateFragment {
    private String varName;
    private String varType;
    private String sourceExprString;
    private Expression sourceExpression;

    VariableFragment(int startPos, int endPos, String varName, String varType, String sourceExprString, Expression sourceExpression) {
        super(startPos, endPos);
        this.varName = varName;
        this.varType = varType;
        this.sourceExprString = sourceExprString;
        this.sourceExpression = sourceExpression;
    }

    @Override
    void processFragment(TemplateProcessor processor) throws TemplateException {
        EvaluationResult evalResult = this.sourceExpression.evaluate(processor, processor.getPostEvalConverter(), Expression.SCRIPT_EVAL);
        String message = "expr = '" + this.sourceExprString + "'";
        if (evalResult.getException() != null) {
            processor.reportError(this, evalResult.getException(), message);
        }
        Object objValue = evalResult.getValue();
        if (!processor.isVariableDefined(this.varName)) {
            processor.recordVariable(this, this.varName, this.varType, objValue);
        } else {
            processor.setVariable(this.varName, objValue);
        }
    }

    String getVarName() {
        return this.varName;
    }

    String getVarType() {
        return this.varType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("<VARIABLE");
        buf.append(" [" + this.startPos + ".." + this.endPos + "] ");
        buf.append(this.varName);
        buf.append("=");
        buf.append("'");
        buf.append(this.sourceExprString);
        buf.append("'");
        if (this.varType != null) {
            buf.append(" TYPE=");
            buf.append('\"' + this.varType + '\"');
        }
        buf.append(">");
        return buf.toString();
    }
}

