/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.model;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class XQMessageBulkOperation {
    private XQMessage m_message;
    private String m_condition;
    private boolean m_isHeaders;
    private Action m_action = Action.INCLUDE;
    protected static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);
    protected static boolean s_debugLogEnabled = s_log.isDebugLoggingEnabled();
    int fetchCounter = 0;
    List m_collection = null;

    public List<Object> getValue() throws XQMessageException {
        if (this.m_isHeaders) {
            return this.toHeadersCollection();
        }
        return this.toPartsCollection();
    }

    public Object getEach() throws XQMessageException {
        if (this.m_collection == null) {
            this.m_collection = this.getValue();
        }
        if (this.fetchCounter >= this.m_collection.size()) {
            return null;
        }
        return this.m_collection.get(this.fetchCounter++);
    }

    public XQMessageBulkOperation(XQMessage message, String condition, boolean isHeaders) {
        this.m_message = message;
        this.m_condition = condition;
        this.m_isHeaders = isHeaders;
    }

    public XQMessage getMessage() {
        return this.m_message;
    }

    public String getCondition() {
        return this.m_condition;
    }

    public boolean isHeaders() {
        return this.m_isHeaders;
    }

    public void setAction(Action action) {
        this.m_action = action;
    }

    public void doAction(XQMessage message) throws XQMessageException {
        if (this.m_condition == null || "".equals(this.m_condition.trim())) {
            return;
        }
        if (this.m_action == Action.DELETE) {
            if (this.m_isHeaders) {
                this.deleteHeaders(message);
            } else {
                this.deleteParts(message);
            }
        } else if (this.m_action == Action.INCLUDE && this.m_message != message) {
            if (this.m_isHeaders) {
                this.copyHeaders(message);
            } else {
                this.copyParts(message);
            }
        }
    }

    private void copyParts(XQMessage message) throws XQMessageException {
        if ("*".equals(this.m_condition)) {
            for (int i = 0; i < this.m_message.getPartCount(); ++i) {
                XQPart part = this.m_message.getPart(i);
                this.addPartWithLogging(message, part);
            }
        } else {
            Pattern partFilter = Pattern.compile(this.m_condition);
            for (int i = 0; i < this.m_message.getPartCount(); ++i) {
                XQPart part = this.m_message.getPart(i);
                String contentId = part.getContentId();
                if (!partFilter.matcher(contentId == null ? "" : contentId).matches()) continue;
                this.addPartWithLogging(message, part);
            }
        }
    }

    private void addPartWithLogging(XQMessage message, XQPart part) throws XQMessageException {
        this.addPart(message, part);
        if (s_debugLogEnabled) {
            s_log.logDebug("Adding part: " + part.getContentId());
        }
    }

    private void addPart(XQMessage message, XQPart part) throws XQMessageException {
        String cid = part.getContentId();
        if (message.doesPartExist(cid)) {
            message.replacePart(part, cid);
        } else {
            message.addPart(part);
        }
    }

    private void deleteParts(XQMessage message) throws XQMessageException {
        if ("*".equals(this.m_condition)) {
            message.removeAllParts();
            s_log.logDebug("Deleted all parts");
        } else {
            Pattern partFilter = Pattern.compile(this.m_condition);
            ArrayList<String> partList = new ArrayList<String>();
            for (int i = 0; i < message.getPartCount(); ++i) {
                XQPart part = message.getPart(i);
                String contentID = part.getContentId();
                if (!partFilter.matcher(contentID == null ? "" : contentID).matches()) continue;
                partList.add(contentID);
            }
            for (String contentID : partList) {
                message.removePart(contentID);
                if (!s_debugLogEnabled) continue;
                s_log.logDebug("Deleted part: " + contentID);
            }
        }
    }

    private void copyHeaders(XQMessage message) throws XQMessageException {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        if ("*".equals(this.m_condition)) {
            Iterator headerNameIter = this.m_message.getHeaderNames();
            while (headerNameIter.hasNext()) {
                String headerName = (String)headerNameIter.next();
                this.addHeaderWithLogging(headerMap, headerName);
            }
        } else {
            Pattern headerFilter = Pattern.compile(this.m_condition);
            Iterator headerNameIter = this.m_message.getHeaderNames();
            while (headerNameIter.hasNext()) {
                String headerName = (String)headerNameIter.next();
                if (!headerFilter.matcher(headerName).matches()) continue;
                this.addHeaderWithLogging(headerMap, headerName);
            }
        }
        message.setHeaderValues(headerMap);
    }

    private void addHeaderWithLogging(Map<String, Object> headerMap, String headerName) throws XQMessageException {
        headerMap.put(headerName, this.m_message.getHeaderValue(headerName));
        if (s_debugLogEnabled) {
            s_log.logDebug("Added header: " + headerName);
        }
    }

    private void deleteHeaders(XQMessage message) throws XQMessageException {
        if ("*".equals(this.m_condition)) {
            XQMessageBulkOperation.deleteAllHeaders(message);
            s_log.logDebug("Deleted all non-JMS headers");
        } else {
            ArrayList<String> toRemove = new ArrayList<String>();
            Pattern headerFilter = Pattern.compile(this.m_condition);
            Iterator headerNameIter = message.getHeaderNames();
            while (headerNameIter.hasNext()) {
                String headerName = (String)headerNameIter.next();
                if (!headerFilter.matcher(headerName).matches()) continue;
                if (!headerName.startsWith("JMS")) {
                    toRemove.add(headerName);
                    if (!s_debugLogEnabled) continue;
                    s_log.logDebug("Deleted header: " + headerName);
                    continue;
                }
                if (!s_debugLogEnabled) continue;
                s_log.logDebug("Ignoring JMS header: " + headerName);
            }
            for (String headerName : toRemove) {
                message.removeHeader(headerName);
            }
        }
    }

    public static void deleteAllHeaders(XQMessage message) throws XQMessageException {
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator headerNameIter = message.getHeaderNames();
        while (headerNameIter.hasNext()) {
            String headerName = (String)headerNameIter.next();
            if (headerName.startsWith("JMS")) continue;
            toRemove.add(headerName);
        }
        for (String headerName : toRemove) {
            message.removeHeader(headerName);
        }
    }

    private List<Object> toHeadersCollection() throws XQMessageException {
        ArrayList<Object> headers = new ArrayList<Object>();
        if ("*".equals(this.m_condition)) {
            Iterator headerNameIter = this.m_message.getHeaderNames();
            while (headerNameIter.hasNext()) {
                String headerName = (String)headerNameIter.next();
                this.addHeaderAndDebug(headerName, headers);
            }
        } else {
            Pattern headerFilter = Pattern.compile(this.m_condition);
            Iterator headerNameIter = this.m_message.getHeaderNames();
            while (headerNameIter.hasNext()) {
                String headerName = (String)headerNameIter.next();
                if (!headerFilter.matcher(headerName).matches()) continue;
                this.addHeaderAndDebug(headerName, headers);
            }
        }
        return headers;
    }

    private void addHeaderAndDebug(String headerName, List<Object> headers) throws XQMessageException {
        headers.add(this.m_message.getHeaderValue(headerName));
        if (s_debugLogEnabled) {
            s_log.logDebug("Collecting header: " + headerName);
        }
    }

    private List<Object> toPartsCollection() throws XQMessageException {
        ArrayList<Object> parts = new ArrayList<Object>();
        if ("*".equals(this.m_condition)) {
            for (int i = 0; i < this.m_message.getPartCount(); ++i) {
                XQPart part = this.m_message.getPart(i);
                XQMessageBulkOperation.addContentWithLogging(part, parts);
            }
        } else {
            Pattern partFilter = Pattern.compile(this.m_condition);
            for (int i = 0; i < this.m_message.getPartCount(); ++i) {
                XQPart part = this.m_message.getPart(i);
                String contentId = part.getContentId();
                if (!partFilter.matcher(contentId == null ? "" : contentId).matches()) continue;
                XQMessageBulkOperation.addContentWithLogging(part, parts);
            }
        }
        return parts;
    }

    private static void addContentWithLogging(XQPart part, List<Object> parts) {
        parts.add(part.getContent());
        if (s_debugLogEnabled) {
            s_log.logDebug("Collecting part: " + part.getContentId());
        }
    }

    public static enum Action {
        INCLUDE,
        DELETE;

    }
}

