/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.jeri.jms;

import com.sonicsw.esb.jeri.IExporterSource;
import com.sonicsw.esb.jeri.JERIException;
import com.sonicsw.esb.jeri.jms.JMSContainerServerEndpoint;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Session;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;

public class JMSPreferredSessionTracker
implements IExporterSource {
    private static JMSPreferredSessionTracker m_tracker = null;
    private Map m_sessions = new Hashtable();
    private Map m_exporters = new Hashtable();

    public static synchronized JMSPreferredSessionTracker getInstance() {
        if (m_tracker == null) {
            m_tracker = new JMSPreferredSessionTracker();
        }
        return m_tracker;
    }

    public void addSession(String uuid, Session session) {
        this.m_sessions.put(uuid, session);
    }

    public void addExporter(String uuid, Session session) {
        this.m_exporters.put(uuid, session);
    }

    public Session getSession(String uuid) {
        return (Session)this.m_sessions.get(uuid);
    }

    public void removeInvocation(String uuid) {
        this.m_sessions.remove(uuid);
        this.m_exporters.remove(uuid);
    }

    public Exporter getExporter(String uuid) throws JERIException {
        Session session = (Session)this.m_exporters.get(uuid);
        if (session == null) {
            throw new JERIException("Unable to locate connected session with id: " + uuid);
        }
        try {
            return new BasicJeriExporter((ServerEndpoint)new JMSContainerServerEndpoint(session, uuid), (InvocationLayerFactory)new BasicILFactory(), false, false);
        }
        catch (JMSException e) {
            JERIException jeriException = new JERIException(e.getMessage());
            jeriException.initCause((Throwable)e);
            throw jeriException;
        }
    }
}

