/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.actional.lg.visitor;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.FaultNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.RejectStepNode;
import com.sonicsw.esb.itinerary.model.ResubmitNode;
import com.sonicsw.esb.itinerary.model.RethrowNode;
import com.sonicsw.esb.process.engine.ProcessChangeListener;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.TerminateNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import java.util.HashMap;
import java.util.Map;

public class ActionalProcessChangeListener
implements ProcessChangeListener {
    private ESBVisitor m_actionalVisitor;

    public ActionalProcessChangeListener(ESBVisitor actionalVisitor) {
        this.m_actionalVisitor = actionalVisitor;
    }

    @Override
    public void activityClosed(Token token, ActivityNode node) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (node instanceof FaultNode || node instanceof ResubmitNode || node instanceof RethrowNode || node instanceof RejectStepNode || node instanceof TerminateNode) {
            EsbMessageExchange emex = (EsbMessageExchange)token.getData();
            XQMessage xqMsg = emex.getInputMessage();
            XQParameters params = emex.getXQParameters();
            ProcessInstanceProps pip = procInst.getProcessInstanceProperties();
            String processName = null;
            if (params != null) {
                processName = params.getParameter("SonicXQ.ProcessName", 1);
            }
            Map<String, Object> visitorParams = this.initVisitorParams(node, token);
            if (processName != null) {
                visitorParams.put("ESBVisitor.PARAM_PROCESS_NAME", processName);
            }
            visitorParams.put("ESBVisitor.PARAM_XQ_PARAMETERS", params);
            visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", xqMsg);
            visitorParams.put("End SI", "true");
            this.m_actionalVisitor.receivedByStep(visitorParams);
        }
    }

    @Override
    public void activityStarted(Token token, ActivityNode node) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (node instanceof FaultNode || node instanceof ResubmitNode || node instanceof RethrowNode || node instanceof RejectStepNode || node instanceof TerminateNode || node instanceof ItineraryEndNode && token.isTokenOfType(Token.Type.FAULT, false) && !procInst.isSubProcess()) {
            EsbMessageExchange emex = (EsbMessageExchange)token.getData();
            XQMessage xqMsg = emex.getInputMessage();
            XQParameters params = emex.getXQParameters();
            ProcessInstanceProps pip = procInst.getProcessInstanceProperties();
            XQAddress faultAddress = pip.getFaultAddress();
            String processName = null;
            if (params != null) {
                processName = params.getParameter("SonicXQ.ProcessName", 1);
            }
            Map<String, Object> visitorParams = this.initVisitorParams(node, token);
            if (node instanceof ItineraryEndNode) {
                visitorParams.put("ESBVisitor.PARAM_STEP_NAME", this.pseudoOpName(token, node));
            }
            if (processName != null) {
                visitorParams.put("ESBVisitor.PARAM_PROCESS_NAME", processName);
            }
            visitorParams.put("ESBVisitor.PARAM_XQ_PARAMETERS", emex.getXQParameters());
            visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", xqMsg);
            if (node instanceof ItineraryEndNode && faultAddress != null) {
                ((XQMessageInternal)xqMsg).removeSidebandProperty("SonicESB.LG_REPORT_FAILURE");
                visitorParams.put("ESBVisitor.PARAM_FAULT_ADDRESS", faultAddress);
            }
            this.m_actionalVisitor.sentToStep(visitorParams);
            this.m_actionalVisitor.receivedByStep(visitorParams);
            if (node instanceof ItineraryEndNode) {
                visitorParams.put("End SI", "true");
                this.m_actionalVisitor.receivedByStep(visitorParams);
            }
        }
    }

    private Map<String, Object> initVisitorParams(ActivityNode node, Token token) {
        HashMap<String, Object> visitorParams = new HashMap<String, Object>();
        visitorParams.put("ESBVisitor.PARAM_SERVICE_NAME", this.pseudoGroupName(token, node));
        return visitorParams;
    }

    @Override
    public void activityTerminated(Token token, ActivityNode activity) {
    }

    @Override
    public void errorOccurred(Token token, String message) {
    }

    @Override
    public void processStateChanged(Token token, ProcessState newState) {
    }

    @Override
    public void transitionFired(Token token, ActivityEdge transition) {
    }

    private String pseudoOpName(Token token, ActivityNode node) {
        if (node instanceof FaultNode) {
            return "(Fault)";
        }
        if (node instanceof RejectStepNode) {
            return "(Reject)";
        }
        if (node instanceof RethrowNode) {
            return "(Rethrow)";
        }
        if (node instanceof ResubmitNode) {
            return "(Resubmit)";
        }
        if (node instanceof TerminateNode) {
            return "(Terminate)";
        }
        if (node instanceof ItineraryEndNode) {
            if (token.isTokenOfType(Token.Type.RME, false)) {
                return "(Reject)";
            }
            if (token.isTokenOfType(Token.Type.FAULT, false)) {
                return "(Fault)";
            }
            return "(???)";
        }
        return null;
    }

    private String pseudoGroupName(Token token, ActivityNode node) {
        if (node instanceof FaultNode) {
            return "(InternalStep.Fault)";
        }
        if (node instanceof RejectStepNode) {
            return "(InternalStep.Reject)";
        }
        if (node instanceof RethrowNode) {
            return "(InternalStep.Rethrow)";
        }
        if (node instanceof ResubmitNode) {
            return "(InternalStep.Resubmit)";
        }
        if (node instanceof TerminateNode) {
            return "(InternalStep.Terminate)";
        }
        if (node instanceof ItineraryEndNode) {
            if (token.isTokenOfType(Token.Type.RME, false)) {
                return "(TerminalRejectGroup)";
            }
            if (token.isTokenOfType(Token.Type.FAULT, false)) {
                return "(TerminalFaultGroup)";
            }
            return "(???)";
        }
        return null;
    }
}

