/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xqimpl.config.IEndpointConfigImpl;
import com.sonicsw.xqimpl.config.XQConfiguration;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.envelope.IXQAddressImpl;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQEndpointManagerImpl;
import com.sonicsw.xqimpl.service.XQRegistry;
import com.sonicsw.xqimpl.util.XQParametersImpl;

public class EndpointUtils {
    public static Endpoint getTransientEndpoint(XQAddress address) {
        if (!(address instanceof IXQAddressImpl)) {
            return null;
        }
        XQConfiguration xqconfig = ((IXQAddressImpl)address).getConfig();
        if (xqconfig == null || !(xqconfig instanceof IEndpointConfigImpl)) {
            return null;
        }
        IEndpointConfigImpl config = (IEndpointConfigImpl)xqconfig;
        String transientEndpointServiceInstanceName = config.getParameters().getParameter("TransientEndpointServiceName", 1);
        if (transientEndpointServiceInstanceName == null) {
            return null;
        }
        String endpointName = address.getName();
        XQDispatcher transientDispatcher = XQRegistry.instance().lookupService(transientEndpointServiceInstanceName);
        XQEndpointManagerImpl owner = (XQEndpointManagerImpl)transientDispatcher.getEndpointManager();
        Endpoint endpoint = (Endpoint)owner.getTransientEndpoint(endpointName);
        return endpoint;
    }

    public static boolean isTransientEndpoint(Endpoint ep) {
        XQEndpointConfig config = ep.getConfig();
        if (config == null) {
            return false;
        }
        XQParametersImpl parms = config.getParameters();
        return parms != null && parms.getParameter("TransientEndpointServiceName", 1) != null;
    }
}

