/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.ExpressionException;
import com.sonicsw.esb.expression.def.EsbdlExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.esb.expression.def.el.IndexConstructProcessor;

public class EsbdlExpressionDefProcessor
extends ExpressionDefProcessorBase
implements ExpressionDefProcessor,
IndexConstructProcessor.Callback {
    private EsbdlExpressionDef m_expressionDef;
    private int m_paramType;

    public EsbdlExpressionDefProcessor() {
    }

    public EsbdlExpressionDefProcessor(String remaining) {
        super(remaining);
        this.m_expressionDef = new EsbdlExpressionDef();
    }

    @Override
    public ExpressionDef getExpressionDef(String strExpression, boolean isRValue) {
        this.m_expressionDef.setRValue(isRValue);
        IndexConstructProcessor.processIndexConstruct(this.m_remaining, this);
        return this.m_expressionDef;
    }

    @Override
    public String getStringRepresentation(ExpressionDef expressionDef) {
        assert (expressionDef instanceof EsbdlExpressionDef);
        EsbdlExpressionDef esbdlExpression = (EsbdlExpressionDef)expressionDef;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("${esbdl.");
        if (this.isDefined(esbdlExpression.getInputParamName())) {
            sbuf.append("input['");
            sbuf.append(EsbdlExpressionDefProcessor.getString(esbdlExpression.getInputParamName()));
        } else if (this.isDefined(esbdlExpression.getOutputParamName())) {
            sbuf.append("output['");
            sbuf.append(EsbdlExpressionDefProcessor.getString(esbdlExpression.getOutputParamName()));
        } else if (this.isDefined(esbdlExpression.getFaultParamName())) {
            sbuf.append("fault['");
            sbuf.append(EsbdlExpressionDefProcessor.getString(esbdlExpression.getFaultParamName()));
        } else {
            throw new ExpressionException("Required information has not been populated to generate a valid esbdl expression");
        }
        if (expressionDef.isRValue()) {
            if (esbdlExpression.isCollection()) {
                sbuf.append("'].append}");
            } else {
                sbuf.append("']}");
            }
        } else if (esbdlExpression.isCollection()) {
            sbuf.append("'].each}");
        } else {
            sbuf.append("'].value}");
        }
        return sbuf.toString();
    }

    @Override
    public void setIndex(int index) {
    }

    @Override
    public void setIndex(String indexName) {
        if (this.m_paramType == 0) {
            this.m_expressionDef.setInputParamName(EsbdlExpressionDefProcessor.getExpressionObjOrStr(indexName));
        } else if (this.m_paramType == 1) {
            this.m_expressionDef.setOutputParamName(EsbdlExpressionDefProcessor.getExpressionObjOrStr(indexName));
        } else if (this.m_paramType == 2) {
            this.m_expressionDef.setFaultParamName(EsbdlExpressionDefProcessor.getExpressionObjOrStr(indexName));
        }
    }

    @Override
    public void setSource(String source) {
        if ("input".equals(source)) {
            this.m_paramType = 0;
        } else if ("output".equals(source)) {
            this.m_paramType = 1;
        } else if ("fault".equals(source)) {
            this.m_paramType = 2;
        } else if (source.endsWith(".each")) {
            this.m_expressionDef.setCollectionType(true);
        } else if (source.endsWith(".append")) {
            this.m_expressionDef.setCollectionType(true);
        }
    }

    @Override
    public void setFunction(String function) {
    }

    @Override
    public void setEmbeddedExpression(String expression) {
        String fullExpression = "${" + expression + "}";
        ExpressionDef expressionDef = s_expressionDefProcessorFactory.getExpressionDefProcessor(fullExpression).getExpressionDef(fullExpression, false);
        if (this.m_paramType == 0) {
            this.m_expressionDef.setInputParamName(expressionDef);
        } else if (this.m_paramType == 1) {
            this.m_expressionDef.setOutputParamName(expressionDef);
        } else if (this.m_paramType == 2) {
            this.m_expressionDef.setFaultParamName(expressionDef);
        }
    }
}

