/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.model.XQMessageBulkOperation;
import com.sonicsw.esb.itinerary.mapping.DefaultMappingRuleList;
import com.sonicsw.esb.itinerary.mapping.DefaultOutputMappingRule;
import com.sonicsw.esb.itinerary.mapping.MappingUtils;
import com.sonicsw.esb.itinerary.mapping.XQMsgBulkOperationAction;
import com.sonicsw.esb.process.mapping.InputMappingRule;
import com.sonicsw.esb.process.mapping.InvocationContext;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.MappingException;
import com.sonicsw.esb.process.mapping.MappingRule;
import com.sonicsw.esb.process.mapping.MappingRuleList;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.mapping.ParameterValue;
import com.sonicsw.esb.process.mapping.ParameterValueMap;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class InputMapperHelper {
    private MappingRuleList m_rulesList = new DefaultMappingRuleList(0);
    private static XQMessageFactory s_msgFactory = new XQMessageFactoryImpl();

    public void addInputMappingRule(InputMappingRule mapRule) {
        this.m_rulesList.addMappingRule(mapRule);
    }

    public MappingRuleList getInputRules() {
        return this.m_rulesList;
    }

    public ParameterValueMap mapInput(XQMessage msg, MappingContext mappingCtx) {
        XQMessage inputMsg = msg;
        mappingCtx.addObject(XQMessage.class, msg);
        MessageMapper msgMapper = (MessageMapper)mappingCtx.getObject(MessageMapper.class, true);
        boolean cloneMessage = Boolean.valueOf(msgMapper.getProperties().getProperty("cloneMessage"));
        XQServiceContext ctx = mappingCtx.getServiceContext();
        if (cloneMessage) {
            try {
                inputMsg = ctx != null ? ctx.getMessageFactory().createMessage(msg) : s_msgFactory.createMessage(msg);
                inputMsg.removeAllParts();
                XQMessageBulkOperation.deleteAllHeaders(inputMsg);
            }
            catch (XQMessageException e) {
                throw new MappingException("Error while creating a new copy of the message", e);
            }
        }
        ExpressionContext exprContext = MappingUtils.getExpressionContext(msg, mappingCtx);
        mappingCtx.addObject(ExpressionContext.class, exprContext);
        exprContext.setValue("esbpStepInMsg", inputMsg);
        exprContext.putContextObject(MappingContext.class, mappingCtx);
        ParameterValueMap inputParameters = new ParameterValueMap();
        if (ctx != null) {
            InvocationContext invCtx = (InvocationContext)ctx.getInvocationContext();
            invCtx.setInputParameterValues(inputParameters);
        }
        Iterator<MappingRule> rulesIter = this.m_rulesList.getMappingRules();
        if (!cloneMessage) {
            rulesIter = this.sortedIterator(rulesIter);
        }
        while (rulesIter.hasNext()) {
            InputMappingRule mapRule = (InputMappingRule)rulesIter.next();
            ParameterValue inputParam = mapRule.mapToInput(mappingCtx);
            inputParameters.add(inputParam);
        }
        if (cloneMessage && ctx != null) {
            ctx.getFirstIncoming().setMessage(inputMsg);
        }
        mappingCtx.addObject(DefaultOutputMappingRule.RESPONSE_MSG, inputMsg);
        return inputParameters;
    }

    private Iterator<MappingRule> sortedIterator(Iterator<MappingRule> it) {
        ArrayList<MappingRule> list = new ArrayList<MappingRule>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, new Comparator<MappingRule>(){

            @Override
            public int compare(MappingRule o1, MappingRule o2) {
                if (o1.getMappingAction() instanceof XQMsgBulkOperationAction) {
                    return 1;
                }
                if (o2.getMappingAction() instanceof XQMsgBulkOperationAction) {
                    return -1;
                }
                return 0;
            }
        });
        return list.iterator();
    }
}

