/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.model.impl;

import com.sonicsw.esb.process.model.Action;
import com.sonicsw.esb.process.model.ActionList;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.List;

public class DefaultActionList
implements ActionList {
    private static XQLog m_log = XQLogImpl.getCategoryLog((int)32768);
    private Action.Type m_type;
    private String m_id;
    private List<Action> m_actions = new ArrayList<Action>(2);

    public DefaultActionList() {
    }

    public DefaultActionList(String id, Action.Type type) {
        this.m_id = id;
        this.m_type = type;
    }

    @Override
    public void addAction(Action action) {
        this.m_actions.add(action);
    }

    @Override
    public void removeAction(Action action) {
        this.m_actions.remove(action);
    }

    public List<Action> getActions() {
        return this.m_actions;
    }

    public void setActions(List<Action> actions) {
        this.m_actions = actions;
    }

    @Override
    public void execute(Token token, ActivityNode targetNode, ActivityEdge targetEdge) {
        if (m_log.isDebugLoggingEnabled()) {
            m_log.logDebug("Executing Action list `" + (Object)((Object)this.m_type) + "` on " + (targetNode != null ? targetNode.getDisplayName() : targetEdge));
        }
        for (int i = 0; i < this.m_actions.size(); ++i) {
            Action action = this.m_actions.get(i);
            action.execute(token, this.m_type, targetNode, targetEdge);
        }
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    public void setId(String mId) {
        this.m_id = mId;
    }

    public String getTypeStr() {
        return this.m_type.toString();
    }

    public void setTypeStr(String type) {
        this.m_type = Action.Type.valueOf(type);
    }
}

