/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.routingList.impl;

import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.configuration.RoutingDestination;
import com.sonicsw.xq.service.xcbr.configuration.RoutingListConfiguration;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingContext;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingEndpoint;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingEndpointFactory;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingList;
import java.util.ArrayList;

public class RoutingListImpl
implements RoutingList {
    private ArrayList<RoutingEndpoint> routingList_;
    private String exceptionClass_;
    private String exceptionMessage_;

    public RoutingListImpl(RoutingListConfiguration argRoutingListConfig) throws RoutingRuleException {
        try {
            if (argRoutingListConfig.isException()) {
                this.exceptionClass_ = argRoutingListConfig.getExceptionClass();
                this.exceptionMessage_ = argRoutingListConfig.getExceptionMessage();
            } else {
                this.routingList_ = new ArrayList();
                int destinations = argRoutingListConfig.getNumberOfRoutingDestinations();
                for (int i = 0; i < destinations; ++i) {
                    RoutingDestination destination = argRoutingListConfig.getDestination(i);
                    RoutingEndpoint endpoint = RoutingEndpointFactory.create(destination);
                    this.routingList_.add(endpoint);
                }
            }
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    @Override
    public void route(InvocationContext argMessage, RoutingContext routingContext) throws RoutingRuleException {
        try {
            if (this.isExceptionEndpoint()) {
                Class<?> exceptionClass = Class.forName(this.exceptionClass_);
                Object exceptionObject = exceptionClass.newInstance();
                Exception t = (Exception)exceptionObject;
                t.initCause(new Exception(this.exceptionMessage_));
                routingContext.trace(t);
                if (!routingContext.getRoutingDisabled()) {
                    throw t;
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    RoutingEndpoint endpoint = this.get(i);
                    routingContext.trace(endpoint);
                    if (routingContext.getRoutingDisabled()) continue;
                    endpoint.route(argMessage);
                }
            }
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    private RoutingEndpoint get(int argIndex) {
        return this.routingList_.get(argIndex);
    }

    private int size() throws RoutingRuleException {
        return this.routingList_.size();
    }

    private boolean isExceptionEndpoint() throws RoutingRuleException {
        boolean returnValue = false;
        if (this.routingList_ == null) {
            returnValue = true;
        }
        return returnValue;
    }
}

