/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.ExpressionException;
import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.XQMsgExpressionDef;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.esb.expression.def.el.FunctionDef;
import com.sonicsw.esb.expression.def.el.IndexConstructProcessor;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XQMsgExpressionDefProcessor
extends ExpressionDefProcessorBase
implements ExpressionDefProcessor,
IndexConstructProcessor.Callback {
    private XQMsgExpressionDef m_expressionDef;
    private static String[] s_expressionPrefixes = new String[]{"esbmsg", "esbpStepInMsg", "esbpStepOutMsg"};
    private static final String PART_HEADER_PATTERN = "parts\\[['\\w\\d]+\\]\\.header\\['(.+)'\\]";
    private static final String FULL_PART_HEADER_PATTER = "\\$\\{(esbmsg|esbpStepOutMsg|esbpStepInMsg)\\.parts\\[['\\w\\d]+\\]\\.header\\['(.+)'\\]\\}";

    public XQMsgExpressionDefProcessor() {
    }

    public XQMsgExpressionDefProcessor(String scheme, String remaining) {
        super(remaining);
        this.m_expressionDef = new XQMsgExpressionDef();
        int xqMsgType = Arrays.binarySearch(s_expressionPrefixes, scheme);
        this.m_expressionDef.setXQMsgType(xqMsgType);
    }

    @Override
    public ExpressionDef getExpressionDef(String strExpression, boolean isRValue) {
        Pattern pattern;
        Matcher matcher;
        this.m_expressionDef.setRValue(isRValue);
        IndexConstructProcessor.processIndexConstruct(this.m_remaining, this, true);
        if (this.m_expressionDef.getSubType() == 7 && (matcher = (pattern = Pattern.compile(FULL_PART_HEADER_PATTER)).matcher(strExpression)).matches()) {
            this.m_expressionDef.setPartHeaderName(matcher.group(2));
        }
        return this.m_expressionDef;
    }

    @Override
    public String getStringRepresentation(ExpressionDef expressionDef) {
        assert (expressionDef instanceof XQMsgExpressionDef);
        XQMsgExpressionDef xqMsgExpressionDef = (XQMsgExpressionDef)expressionDef;
        StringBuilder sbuf = this.createBuilder(xqMsgExpressionDef);
        if (xqMsgExpressionDef.getSubType() == 0) {
            assert (this.isDefined(xqMsgExpressionDef.getHeaderName()));
            this.addIndex(sbuf, "headers", xqMsgExpressionDef.getHeaderName(), false);
        } else if (xqMsgExpressionDef.getSubType() == 1) {
            this.addIndex(sbuf, xqMsgExpressionDef);
        } else if (xqMsgExpressionDef.getSubType() == 5) {
            this.appendHeaders(expressionDef, sbuf, xqMsgExpressionDef);
        } else if (xqMsgExpressionDef.getSubType() == 6) {
            this.appendParts(expressionDef, sbuf, xqMsgExpressionDef);
        } else if (xqMsgExpressionDef.getSubType() == 2) {
            this.appendAndAddFunction(sbuf, xqMsgExpressionDef);
        } else if (xqMsgExpressionDef.getSubType() == 3) {
            this.appendNewParts(sbuf, xqMsgExpressionDef);
        } else if (xqMsgExpressionDef.getSubType() == 4) {
            this.appendData(sbuf, xqMsgExpressionDef);
        } else if (xqMsgExpressionDef.getSubType() == 7) {
            this.addIndex(sbuf, xqMsgExpressionDef);
            sbuf.append(".header['").append(xqMsgExpressionDef.getPartHeaderName()).append("']");
        } else {
            throw new ExpressionException("Required information has not been populated to generate a valid XQMessage expression");
        }
        return this.appendContent(sbuf, xqMsgExpressionDef);
    }

    private void appendAndAddFunction(StringBuilder sbuf, XQMsgExpressionDef xqMsgExpressionDef) {
        sbuf.append("parts[");
        Object newPartIndex = xqMsgExpressionDef.getNewPartIndex();
        if (newPartIndex instanceof Integer && (Integer)newPartIndex >= 0 || xqMsgExpressionDef.getNewPartIndex() instanceof ExpressionDef) {
            FunctionDef.addFunction(sbuf, "xq:newPartAt", xqMsgExpressionDef.getNewPartIndex(), xqMsgExpressionDef.getNewPartContentID(), xqMsgExpressionDef.getNewPartContentType());
        } else {
            FunctionDef.addFunction(sbuf, "xq:newPart", xqMsgExpressionDef.getNewPartContentID(), xqMsgExpressionDef.getNewPartContentType());
        }
        sbuf.append("]");
    }

    private StringBuilder createBuilder(XQMsgExpressionDef xqMsgExpressionDef) {
        StringBuilder sbuf = new StringBuilder();
        assert (xqMsgExpressionDef.getXQMsgType() <= 2);
        sbuf.append("${");
        sbuf.append(s_expressionPrefixes[xqMsgExpressionDef.getXQMsgType()]);
        sbuf.append('.');
        return sbuf;
    }

    private String appendContent(StringBuilder sbuf, XQMsgExpressionDef xqMsgExpressionDef) {
        if (!xqMsgExpressionDef.isRValue() && xqMsgExpressionDef.getSubType() > 0 && xqMsgExpressionDef.getSubType() < 5) {
            sbuf.append(".content");
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    private void appendData(StringBuilder sbuf, XQMsgExpressionDef xqMsgExpressionDef) {
        this.addIndex(sbuf, xqMsgExpressionDef);
        sbuf.append("[");
        XQMsgExpressionDef.XmlManipulation xmlMan = xqMsgExpressionDef.getXMLManipulation();
        assert (xmlMan != null);
        this.populateFunction(sbuf, xqMsgExpressionDef);
        sbuf.append("]");
    }

    private void appendHeaders(ExpressionDef expressionDef, StringBuilder sbuf, XQMsgExpressionDef xqMsgExpressionDef) {
        if (expressionDef.isRValue()) {
            sbuf.append("headers");
        } else {
            assert (this.isDefined(xqMsgExpressionDef.getHeaderSelectExpression()));
            this.addIndex(sbuf, "selectHeaders", xqMsgExpressionDef.getHeaderSelectExpression(), xqMsgExpressionDef.isCollection());
        }
    }

    private void appendParts(ExpressionDef expressionDef, StringBuilder sbuf, XQMsgExpressionDef xqMsgExpressionDef) {
        if (expressionDef.isRValue()) {
            sbuf.append("parts");
        } else {
            assert (this.isDefined(xqMsgExpressionDef.getPartSelectExpression()));
            this.addIndex(sbuf, "selectParts", xqMsgExpressionDef.getPartSelectExpression(), xqMsgExpressionDef.isCollection());
        }
    }

    private void appendNewParts(StringBuilder sbuf, XQMsgExpressionDef xqMsgExpressionDef) {
        this.addIndex(sbuf, xqMsgExpressionDef);
        sbuf.append("[");
        FunctionDef.addFunction(sbuf, "xq:newPart", xqMsgExpressionDef.getNewPartContentID(), xqMsgExpressionDef.getNewPartContentType());
        sbuf.append("]");
    }

    private void addIndex(StringBuilder sbuf, XQMsgExpressionDef xqMsgExpressionDef) {
        if (this.isDefined(xqMsgExpressionDef.getPartName())) {
            this.addIndex(sbuf, "parts", xqMsgExpressionDef.getPartName(), false);
        } else {
            this.addIndex(sbuf, "parts", xqMsgExpressionDef.getPartIndex(), false);
        }
    }

    private void addIndex(StringBuilder sbuf, String tokenName, Object indexName, boolean isCollection) {
        sbuf.append(tokenName);
        if (indexName instanceof String) {
            sbuf.append("['");
            sbuf.append(indexName);
            sbuf.append("']");
        } else if (indexName instanceof Integer) {
            sbuf.append("[");
            sbuf.append(indexName);
            sbuf.append("]");
        } else if (indexName instanceof ExpressionDef) {
            sbuf.append("[");
            sbuf.append(XQMsgExpressionDefProcessor.getString(indexName));
            sbuf.append("]");
        }
        if (isCollection) {
            sbuf.append(".each");
        }
    }

    private void populateFunction(StringBuilder sbuf, XQMsgExpressionDef expressionDef) {
        XQMsgExpressionDef.XmlManipulation xmlMan = expressionDef.getXMLManipulation();
        if (xmlMan != null) {
            if (xmlMan.getNewAttributeName() != null) {
                FunctionDef.addFunction(sbuf, "xq:newXMLAttribute", xmlMan.getTargetElementXpath(), xmlMan.getNewAttributeName());
            } else {
                FunctionDef.addFunction(sbuf, "xq:newXMLElement", xmlMan.getTargetElementXpath(), xmlMan.getNewElementName(), xmlMan.isDeleteChildElements());
            }
        } else {
            FunctionDef.addFunction(sbuf, "xq:newPart", expressionDef.getNewPartContentID(), expressionDef.getNewPartContentType());
        }
    }

    @Override
    public void setIndex(int index) {
        this.m_expressionDef.setPartIndex(index);
    }

    @Override
    public void setIndex(String indexName) {
        if (this.m_expressionDef.getSubType() == 0) {
            this.m_expressionDef.setHeaderName(indexName);
        } else if (this.m_expressionDef.getSubType() == 1) {
            this.m_expressionDef.setPartName(indexName);
        } else if (this.m_expressionDef.getSubType() == 5) {
            this.m_expressionDef.setHeaderSelectExpression(indexName);
        } else if (this.m_expressionDef.getSubType() == 6) {
            this.m_expressionDef.setPartSelectExpression(indexName);
        }
    }

    @Override
    public void setSource(String source) {
        if ("headers".equals(source)) {
            this.m_expressionDef.setSubType(0);
        } else if ("parts".equals(source)) {
            this.m_expressionDef.setSubType(1);
        } else if ("selectHeaders".startsWith(source)) {
            this.m_expressionDef.setSubType(5);
        } else if ("selectParts".startsWith(source)) {
            this.m_expressionDef.setSubType(6);
        }
        if ("bulk-headers".equals(source)) {
            this.m_expressionDef.setSubType(5);
        } else if ("bulk-parts".equals(source)) {
            this.m_expressionDef.setSubType(6);
        } else if (source.matches(PART_HEADER_PATTERN)) {
            this.m_expressionDef.setSubType(7);
        }
        if (source.endsWith(".each")) {
            this.m_expressionDef.setCollectionType(true);
        }
    }

    @Override
    public void setFunction(String function) {
        FunctionDef functionDef = FunctionDef.parse(function);
        String functionName = functionDef.getName();
        Object[] params = functionDef.getParams();
        if ("xq:newXMLElement".equals(functionName)) {
            this.populateXmlMan(params);
            this.m_expressionDef.setSubType(4);
        } else if ("xq:newXMLAttribute".equals(functionName)) {
            this.populateData(params);
        } else if ("xq:newPart".equals(functionName)) {
            this.populateExpressionDef(params);
        } else if ("xq:newPartAt".equals(functionName)) {
            this.populateExpressionDefData(params);
        } else {
            this.setEmbeddedExpression(function);
        }
    }

    private void populateExpressionDef(Object[] params) {
        this.m_expressionDef.setNewPartContentID(XQMsgExpressionDefProcessor.getExpressionObjOrStr(params[0]));
        this.m_expressionDef.setNewPartContentType(XQMsgExpressionDefProcessor.getExpressionObjOrStr(params[1]));
        Object partIndex = this.m_expressionDef.getPartIndex();
        if ((partIndex == null || partIndex instanceof Integer && (Integer)partIndex < 0) && this.m_expressionDef.getPartName() == null) {
            this.m_expressionDef.setSubType(2);
        } else {
            this.m_expressionDef.setSubType(3);
        }
    }

    private void populateXmlMan(Object[] params) {
        XQMsgExpressionDef.XmlManipulation xmlMan = this.m_expressionDef.createXMLManipulation();
        xmlMan.setTargetElementXpath(XQMsgExpressionDefProcessor.getExpressionObjOrStr(params[0]));
        xmlMan.setNewElementName(XQMsgExpressionDefProcessor.getExpressionObjOrStr(params[1]));
        xmlMan.setDeleteChildElements(Boolean.valueOf((String)params[2]));
    }

    private void populateData(Object[] params) {
        XQMsgExpressionDef.XmlManipulation xmlMan = this.m_expressionDef.createXMLManipulation();
        xmlMan.setTargetElementXpath(XQMsgExpressionDefProcessor.getExpressionObjOrStr(params[0]));
        xmlMan.setNewAttributeName(XQMsgExpressionDefProcessor.getExpressionObjOrStr(params[1]));
        this.m_expressionDef.setSubType(4);
    }

    private void populateExpressionDefData(Object[] params) {
        this.m_expressionDef.setNewPartIndex(XQMsgExpressionDefProcessor.getExpressionObjOrInt(params[0]));
        this.m_expressionDef.setNewPartContentID(XQMsgExpressionDefProcessor.getExpressionObjOrStr(params[1]));
        this.m_expressionDef.setNewPartContentType(XQMsgExpressionDefProcessor.getExpressionObjOrStr(params[2]));
        this.m_expressionDef.setSubType(2);
    }

    public static boolean matchesPrefix(String scheme) {
        return Arrays.binarySearch(s_expressionPrefixes, scheme) >= 0;
    }

    @Override
    public void setEmbeddedExpression(String expression) {
        ExpressionDef expressionDef = this.parseAsExpressionDef("${" + expression + "}");
        if (this.m_expressionDef.getSubType() == 0) {
            this.m_expressionDef.setHeaderName(expressionDef != null ? expressionDef : expression);
        } else if (this.m_expressionDef.getSubType() == 1) {
            this.m_expressionDef.setPartName(expressionDef != null ? expressionDef : expression);
        } else if (this.m_expressionDef.getSubType() == 5) {
            this.m_expressionDef.setHeaderSelectExpression(expressionDef != null ? expressionDef : expression);
        } else if (this.m_expressionDef.getSubType() == 6) {
            this.m_expressionDef.setPartSelectExpression(expressionDef != null ? expressionDef : expression);
        }
    }
}

