/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.esb.run.RunRuntimeException;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQException;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.script.ScriptEngine;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import java.util.Hashtable;

public abstract class BaseScriptService
implements XQService {
    protected ScriptEngine m_engine;

    public BaseScriptService() {
        this.m_engine = this.getScriptEngine(null);
    }

    public BaseScriptService(Hashtable env) {
        this.m_engine = this.getScriptEngine(env);
    }

    private ScriptEngine getScriptEngine(Hashtable env) {
        if (env == null) {
            return this.createScriptEngine(XQConfigManager.getInstance(null).getComponentContext());
        }
        return this.createScriptEngine(XQConfigManager.getInstance((Hashtable)env).getDirectoryProxy());
    }

    public void init(XQInitContext initial) throws XQServiceException {
        this.internalInit(initial);
    }

    public void service(XQServiceContext context) throws XQServiceException {
        XQEnvelope envelope = context.getFirstIncoming();
        XQMessage message = envelope.getMessage();
        try {
            message = this.m_engine.executeCommand(message, context.getParameters());
            context.addOutgoing(message);
        }
        catch (XQException e) {
            e.printStackTrace();
            throw new XQServiceException((Throwable)e);
        }
        catch (ScriptEngineException e) {
            Throwable t = e.getLinkedException();
            if (t != null) {
                throw new XQServiceException(t);
            }
            throw new XQServiceException((Throwable)e);
        }
        catch (RunRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    public void destroy() {
        this.internalDestroy();
    }

    protected abstract void internalInit(XQInitContext var1) throws XQServiceException;

    protected abstract void internalDestroy();

    protected abstract ScriptEngine createScriptEngine(DirectoryServiceProxy var1);

    protected abstract ScriptEngine createScriptEngine(IComponentContext var1);
}

