/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.esb.ws.invocation.ESBWSException;
import com.sonicsw.esb.ws.invocation.ESBWSParameter;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.wsdl.PortInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.script.wsdl.WSDLUtils;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;

public class WSDLParameterInfo
implements ESBWSParameter {
    private String m_name;
    private String m_baseType;
    private ParameterDirection m_direction;
    private boolean m_isSoapHeader = false;
    private boolean m_isElement = false;
    private String m_typeURI = null;
    private String m_typeLocalName = null;
    private String m_nspaceURI = null;
    private String m_typePrefix = null;
    private IParameterValue m_value = null;

    public WSDLParameterInfo(String baseType, String typePrefix, Part part, ParameterDirection direction) throws WSDLHelperException {
        this.m_name = part.getName();
        this.m_direction = direction;
        this.m_baseType = baseType;
        this.m_isElement = WSDLUtils.isElement(part);
        QName typeName = WSDLUtils.getPartTypeName(part);
        this.m_typeURI = typeName.getNamespaceURI();
        this.m_typeLocalName = typeName.getLocalPart();
        this.m_typePrefix = typePrefix;
    }

    WSDLParameterInfo(String name, String prefix, String typeURI, String localName, String baseType, ParameterDirection direction) {
        this.m_name = name;
        this.m_direction = direction;
        this.m_typePrefix = prefix;
        this.m_typeURI = typeURI;
        this.m_typeLocalName = localName;
        this.m_baseType = baseType;
    }

    public void setIsSoapHeader(boolean b) {
        this.m_isSoapHeader = b;
    }

    @Override
    public boolean isSoapHeader() {
        return this.m_isSoapHeader;
    }

    @Override
    public boolean isElement() {
        return this.m_isElement;
    }

    @Override
    public String getNamespaceURI() {
        return this.m_nspaceURI;
    }

    public void setSOAPProperties(PortInfo portInfo, Operation op, Part part) throws WSDLHelperException {
        this.m_isElement = WSDLUtils.isElement(part);
        if (!this.m_isElement) {
            this.m_typeURI = WSDLUtils.getTypeURI(part);
        }
        this.m_nspaceURI = portInfo.getNamespaceURI(op, part, this.m_direction.toString(), this.m_isSoapHeader);
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("     <parameter name=\"" + this.m_name + "\"");
        xml.append(" direction=\"" + this.m_direction + "\"");
        xml.append(" displayType=\"" + this.getDisplayType() + "\"");
        xml.append(" baseType=\"" + this.m_baseType + "\"/>\n");
        return xml.toString();
    }

    public String getParameterInfoXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("         <parameterInfo");
        xml.append(" name=\"" + this.m_name + "\"");
        xml.append(" isSoapHeader=\"" + this.m_isSoapHeader + "\"");
        xml.append(" isElement=\"" + this.m_isElement + "\"");
        if (this.m_typeURI != null) {
            xml.append(" typeURI=\"" + this.m_typeURI + "\"");
        }
        if (this.m_nspaceURI != null) {
            xml.append(" namespaceURI=\"" + this.m_nspaceURI + "\"");
        }
        xml.append("/>\n");
        return xml.toString();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getBaseType() {
        return this.m_baseType;
    }

    @Override
    public String getDisplayType() {
        StringBuilder buff = new StringBuilder();
        String prefix = this.m_typePrefix;
        if (prefix == null && "http://www.w3.org/2001/XMLSchema".equals(this.m_typeURI)) {
            prefix = "xsd";
        }
        if (prefix != null && !"".equals(prefix)) {
            buff.append(prefix + ":");
        }
        buff.append(this.m_typeLocalName);
        return buff.toString();
    }

    public ParameterDirection getDirection() {
        return this.m_direction;
    }

    @Override
    public String getParameterDirection() {
        return this.m_direction.toString();
    }

    @Override
    public String getTypeURI() {
        return this.m_typeURI;
    }

    @Override
    public String getTypeLocalName() {
        return this.m_typeLocalName;
    }

    public String getSchema() throws ESBWSException {
        return null;
    }

    public boolean isSchemaAvailable() throws ESBWSException {
        return false;
    }

    @Override
    public boolean isComplexType() {
        return "xsd:anyType".equals(this.getBaseType());
    }

    public boolean isDiscard() {
        return false;
    }

    public String getTypeNamespaceURI() {
        return this.getTypeURI();
    }

    @Override
    public void setParameterValue(IParameterValue iParamValue) {
        this.m_value = iParamValue;
    }

    @Override
    public IParameterValue getParameterValue() {
        return this.m_value;
    }
}

