/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import modelobjects.expr.EvaluationResult;
import modelobjects.expr.PostEvalConverter;
import modelobjects.util.Lexer;

public abstract class Expression {
    public static final int JAVA_EVAL = 1;
    public static final int SCRIPT_EVAL = 2;

    public EvaluationResult evaluate(Object rootObject) {
        return this.evaluate(rootObject, 2);
    }

    public EvaluationResult evaluate(Object rootObject, int rule) {
        return new EvaluationResult(this, rootObject, rule);
    }

    public EvaluationResult evaluate(Object rootObject, PostEvalConverter converter, int rule) {
        return new EvaluationResult(this, rootObject, converter, rule);
    }

    public final Object eval(Object rootObject, int rule) throws Exception {
        return this.eval(rootObject, null, rule);
    }

    public final Object eval(Object rootObject, PostEvalConverter converter, int rule) throws Exception {
        Object result = this.eval1(rootObject, converter, rule);
        return converter == null ? result : converter.postEvalConvert(result);
    }

    protected abstract Object eval1(Object var1, PostEvalConverter var2, int var3) throws Exception;

    public boolean isPropertyExpression() {
        return false;
    }

    protected static Boolean asBoolean(boolean val) {
        return val ? Boolean.TRUE : Boolean.FALSE;
    }

    protected static String opName(int op) {
        return Lexer.getOperatorName(op);
    }
}

