/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.template.ElseFragment;
import modelobjects.template.TagParser;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;

class ElseTagParser
extends TagParser {
    private static final String tagStart = "<ELSE";
    private static final int tagStartLength = "<ELSE".length();

    ElseTagParser() {
    }

    @Override
    TemplateFragment extractFragment(TemplateParser parser, int startPos) {
        int sourceLen;
        char[] source = parser.getTemplateSource();
        if (!this.tagNameMatches(source, startPos, sourceLen = source.length, "ELSE", "else")) {
            return null;
        }
        int endPos = ElseTagParser.tagEndPos(startPos + tagStartLength, source, source.length);
        this.collectTagInfo(source, startPos, endPos);
        return new ElseFragment(startPos, endPos);
    }

    private void collectTagInfo(char[] source, int startPos, int endPos) {
        String attributesString = new String(source, startPos + tagStartLength, endPos - startPos - tagStartLength);
        TagParser.TagAttribute[] attributes = this.collectAttributes(attributesString, source, startPos);
        int n = attributes.length;
        for (int i = 0; i < n; ++i) {
            String attrName = attributes[i].getAttrName();
            String attrValue = attributes[i].getAttrValue();
            System.err.println("Unrecognized <ELSE> attibute: " + attrName + " on line " + TemplateParser.lineNumber(source, startPos));
        }
    }
}

