/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.ExpressionDefProcessorFactory;
import com.sonicsw.esb.expression.def.el.ELExpressionDefProcessFactory;

public class ExpressionDefProcessorBase {
    protected static ExpressionDefProcessorFactory s_expressionDefProcessorFactory = new ELExpressionDefProcessFactory(false);
    protected String m_remaining;

    public ExpressionDefProcessorBase() {
    }

    public ExpressionDefProcessorBase(String remaining) {
        this.m_remaining = remaining;
    }

    protected boolean isDefined(Object value) {
        return value instanceof String && ((String)value).trim().length() > 0 || value != null;
    }

    protected ExpressionDef parseAsExpressionDef(String expression) {
        ExpressionDef expressionDef = null;
        try {
            expressionDef = s_expressionDefProcessorFactory.getExpressionDefProcessor(expression).getExpressionDef(expression, false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return expressionDef;
    }

    public static Object getExpressionObjOrStr(Object value) {
        if (value == null || value instanceof ExpressionDef) {
            return value;
        }
        assert (value instanceof String);
        String string = ((String)value).trim();
        if (string.length() > 4 && ELExpressionDefProcessFactory.startWithSupportedExpressionPrefix(string)) {
            String fullExpression = "${" + string + "}";
            try {
                ExpressionDefProcessor expressionDefProcessor = s_expressionDefProcessorFactory.getExpressionDefProcessor(fullExpression);
                if (expressionDefProcessor != null) {
                    return expressionDefProcessor.getExpressionDef(fullExpression, false);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return string;
    }

    public static Object getExpressionObjOrInt(Object value) {
        if (value == null || value instanceof ExpressionDef) {
            return value;
        }
        if (value instanceof Integer) {
            return value;
        }
        assert (value instanceof String);
        String string = (String)value;
        if (string.trim().length() > 4 && ELExpressionDefProcessFactory.startWithSupportedExpressionPrefix(string)) {
            String fullExpression = "${" + string + "}";
            try {
                return s_expressionDefProcessorFactory.getExpressionDefProcessor(fullExpression).getExpressionDef(fullExpression, false);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return Integer.parseInt(string);
    }

    public static String getString(Object value) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return value + "";
        }
        if (value instanceof Boolean) {
            return value + "";
        }
        assert (value instanceof ExpressionDef);
        ExpressionDef expressionDef = (ExpressionDef)value;
        ExpressionDefProcessor expressionDefProcessor = s_expressionDefProcessorFactory.getExpressionDefProcessor(expressionDef);
        if (expressionDefProcessor != null) {
            String strExpression = expressionDefProcessor.getStringRepresentation(expressionDef);
            return strExpression.substring(2, strExpression.length() - 1);
        }
        return null;
    }
}

