/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.SystemPropertyExpressionDef;
import com.sonicsw.esb.expression.def.UnsupportedExpressionDef;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.esb.expression.def.el.IndexConstructProcessor;

public class SystemPropertyExpressionDefProcessor
extends ExpressionDefProcessorBase
implements ExpressionDefProcessor,
IndexConstructProcessor.Callback {
    private SystemPropertyExpressionDef m_expressionDef;

    public SystemPropertyExpressionDefProcessor() {
    }

    public SystemPropertyExpressionDefProcessor(String remaining) {
        super(remaining);
        this.m_expressionDef = new SystemPropertyExpressionDef();
    }

    @Override
    public ExpressionDef getExpressionDef(String strExpression, boolean isRValue) {
        if (isRValue) {
            return new UnsupportedExpressionDef("System property expressions cannot be R-Values");
        }
        IndexConstructProcessor.processIndexConstruct(this.m_remaining, this);
        return this.m_expressionDef;
    }

    @Override
    public String getStringRepresentation(ExpressionDef expressionDef) {
        assert (expressionDef instanceof SystemPropertyExpressionDef);
        SystemPropertyExpressionDef systemVarExpression = (SystemPropertyExpressionDef)expressionDef;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("${system['");
        sbuf.append(SystemPropertyExpressionDefProcessor.getString(systemVarExpression.getPropertyName()));
        sbuf.append("']}");
        return sbuf.toString();
    }

    @Override
    public void setIndex(int index) {
    }

    @Override
    public void setIndex(String indexName) {
        this.m_expressionDef.setPropertyName(indexName);
    }

    @Override
    public void setSource(String source) {
    }

    @Override
    public void setFunction(String function) {
    }

    @Override
    public void setEmbeddedExpression(String expression) {
        ExpressionDef expressionDef = this.parseAsExpressionDef(expression);
        this.m_expressionDef.setPropertyName(expressionDef != null ? expressionDef : expression);
    }
}

