/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.ExpressionFactory;
import com.sonicsw.esb.itinerary.mapping.MappingUtils;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingRule;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.util.ClassUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;

public class BaseMappingRule
implements MappingRule {
    protected static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);
    protected static boolean s_debugLogEnabled = s_log.isDebugLoggingEnabled();
    protected Expression m_sourceExpression;
    protected Expression m_targetExpression;
    protected String m_source;
    protected String m_target;
    protected MappingAction m_action;
    protected String[] m_actionResources;
    protected boolean m_isCollection;

    public BaseMappingRule(ExpressionFactory expFactory, String source, String target, MappingAction action, String[] actionResource) {
        this.m_source = source;
        ExpressionContext exprCtx = MappingUtils.getStaticExpressionContext();
        this.m_sourceExpression = expFactory != null ? expFactory.createExpression(exprCtx, source) : null;
        this.m_target = target;
        this.m_targetExpression = expFactory != null ? expFactory.createExpression(exprCtx, target) : null;
        this.m_action = action;
        this.m_actionResources = (String[])ClassUtils.arrayCopy((Object[])actionResource);
    }

    @Override
    public String getSource() {
        return this.m_source;
    }

    @Override
    public String getTarget() {
        return this.m_target;
    }

    @Override
    public MappingAction getMappingAction() {
        return this.m_action;
    }

    @Override
    public String[] getMappingActionResource() {
        return this.m_actionResources;
    }

    public Expression getSourceExpression() {
        return this.m_sourceExpression;
    }

    public Expression getTargetExpression() {
        return this.m_targetExpression;
    }

    public void setCollectionType(boolean isCollection) {
        this.m_isCollection = isCollection;
    }

    public boolean isCollectionType() {
        return this.m_isCollection;
    }

    public String toString() {
        return "|" + this.m_source + "| ---" + (this.m_action == null ? "none" : this.m_action) + "(" + (this.m_actionResources != null && this.m_actionResources.length > 0 ? this.m_actionResources[0] : "") + ")---> |" + this.m_target + "|";
    }
}

