/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQConnectionTypeConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.jca.JCA1_0DeploymentDescriptor;
import com.sonicsw.xqimpl.endpoint.container.jca.JCA1_0Endpoint;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnection;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnectionManager;
import com.sonicsw.xqimpl.endpoint.container.jca.XQJCADeploymentDescriptor;
import java.net.URLClassLoader;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class JCA1_0Connection
extends JCAConnection {
    private ManagedConnectionFactory m_managedConnectionFactory;
    private Object m_connectionFactory;

    protected JCA1_0Connection(URLClassLoader parentClassLoader, XQConnectionConfig config, XQConnectionTypeConfig typeConfig, XQLog log, JCAConnectionManager connectionManager, XQJCADeploymentDescriptor deploymentDescriptor, XQMessageFactory messageFactory) throws XQEndpointCreationException {
        super(parentClassLoader, config, typeConfig, log, connectionManager, deploymentDescriptor, messageFactory);
        this.initConnection(connectionManager);
    }

    private void initConnection(JCAConnectionManager connectionManager) throws XQEndpointCreationException {
        this.initializeManagedConnectionFactory();
        this.initializeConnectionFactory(connectionManager);
    }

    public JCA1_0Connection(URLClassLoader parentClassLoader, XQConnectionConfig config, XQConnectionTypeConfig typeConfig, XQLog log, JCAConnectionManager connectionManager, XQMessageFactory messageFactory) throws XQEndpointCreationException {
        this(parentClassLoader, config, typeConfig, log, connectionManager, new JCA1_0DeploymentDescriptor(), messageFactory);
    }

    @Override
    public Endpoint createEndpoint(XQEndpointConfig config, XQEndpointTypeConfig typeConfig) throws XQEndpointCreationException {
        return new JCA1_0Endpoint(config, typeConfig, this.m_log, this, this.m_messageFactory, this.m_connectionManager);
    }

    protected void initializeManagedConnectionFactory() throws XQEndpointCreationException {
        this.m_managedConnectionFactory = (ManagedConnectionFactory)this.createBean(this.m_deploymentDescriptor.getManagedConnectionFactoryClass(), this.m_deploymentDescriptor.getManagedConnectionConnectionFactoryProperties(), ManagedConnectionFactory.class);
        try {
            this.m_managedConnectionFactory.setLogWriter(this.m_log.getPrintWriter());
        }
        catch (ResourceException re) {
            this.m_log.logWarning("The ResourceAdapter is failing when setting the log...No ResourceAdapter logging enabled");
            this.m_log.logWarning((Throwable)re);
        }
    }

    protected void initializeConnectionFactory(ConnectionManager manager) throws XQEndpointCreationException {
        try {
            this.m_connectionFactory = this.m_managedConnectionFactory.createConnectionFactory(manager);
        }
        catch (ResourceException re) {
            throw new XQEndpointCreationException((Throwable)re);
        }
    }

    @Override
    public Object getConnectionFactory() {
        return this.m_connectionFactory;
    }

    @Override
    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.m_managedConnectionFactory;
    }
}

