/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.ws.rm;

import com.sonicsw.esb.ws.rm.IWSEndpointReference;
import com.sonicsw.esb.ws.rm.IWSRMSequence;
import com.sonicsw.esb.ws.rm.IWSRMSequenceMap;
import com.sonicsw.esb.ws.rm.WSRMException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.addressing.WSEndpointReferenceImpl;
import com.sonicsw.xqimpl.ws.rm.SequenceCapsule;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SequenceMap
extends HashMap
implements IWSRMSequenceMap {
    private static XQLog log = XQLogImpl.getCategoryLog((int)16384);

    public SequenceMap() {
    }

    public SequenceMap(String data) throws WSRMException {
        this.deserialize(data);
    }

    public IWSRMSequence getSequence(IWSEndpointReference sequenceKey) {
        return (IWSRMSequence)this.get(sequenceKey);
    }

    public void putSequence(IWSEndpointReference sequenceKey, IWSRMSequence sequence) {
        log.logDebug("Adding new sequence:" + sequence + " with key=" + sequenceKey);
        this.put(sequenceKey, sequence);
    }

    private void deserialize(String data) throws WSRMException {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("Deserializing sequence map: " + data);
        }
        if (data == null) {
            return;
        }
        Element mapElem = null;
        try {
            InputSource src = new InputSource(new StringReader(data));
            mapElem = DOMUtils.getDocumentBuilder().parse(src).getDocumentElement();
        }
        catch (Exception e) {
            throw new WSRMException((Throwable)e);
        }
        List entries = DOMUtils.getImmediateChildElementsByName((Element)mapElem, (String)"sequence");
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (Element sequenceElem : entries) {
            Object key = null;
            Element eprElem = DOMUtils.getImmediateChildElementByName((Element)sequenceElem, (String)"epr");
            if (eprElem != null) {
                try {
                    key = new WSEndpointReferenceImpl(DOMUtils.getFirstChildElement((Element)eprElem));
                }
                catch (Exception e) {
                    throw new WSRMException((Throwable)e);
                }
            } else {
                key = DOMUtils.getFirstTextValueOfChild((Element)sequenceElem, (String)"url");
            }
            Element capsuleElem = DOMUtils.getImmediateChildElementByName((Element)sequenceElem, (String)"capsule");
            SequenceCapsule capsule = new SequenceCapsule(capsuleElem);
            this.put(key, capsule);
        }
    }

    public String serialize() {
        StringBuilder buff = new StringBuilder();
        buff.append("<sequencemap>");
        Set entrySet = this.entrySet();
        for (Map.Entry entry : entrySet) {
            IWSEndpointReference key = (IWSEndpointReference)entry.getKey();
            buff.append("<sequence>");
            buff.append("<epr>");
            buff.append(key.serialize());
            buff.append("</epr>");
            SequenceCapsule cap = (SequenceCapsule)entry.getValue();
            cap.serialize(buff);
            buff.append("</sequence>");
        }
        buff.append("</sequencemap>");
        String seqMapSerialized = buff.toString();
        return seqMapSerialized;
    }

    @Override
    public String toString() {
        return this.serialize();
    }
}

