/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.impl;

import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingContext;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingEndpoint;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStream;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStreamFactory;
import javax.xml.namespace.NamespaceContext;

public class RoutingContextImpl
implements RoutingContext {
    private NamespaceContext namespaces_;
    private String version_;
    private int processingType_;
    private int tracingLevel_ = 0;
    private XMLOutputStream tracingXMLStream_ = null;
    private boolean routingDisabled_ = false;

    public RoutingContextImpl() {
    }

    public RoutingContextImpl(NamespaceContext argNamespaces) throws RoutingRuleException {
        this.namespaces_ = argNamespaces;
    }

    @Override
    public NamespaceContext getNamespaces() throws RoutingRuleException {
        return this.namespaces_;
    }

    @Override
    public NamespaceContext setNamespaces(NamespaceContext nc) {
        NamespaceContext oldnc = this.namespaces_;
        this.namespaces_ = nc;
        return oldnc;
    }

    @Override
    public String getVersion() {
        return this.version_;
    }

    @Override
    public void setVersion(String version) {
        this.version_ = version;
    }

    @Override
    public int getProcessingType() {
        return this.processingType_;
    }

    @Override
    public int setProcessingType(int pt) {
        int oldpt = this.processingType_;
        this.processingType_ = pt;
        return oldpt;
    }

    @Override
    public int getTracingLevel() {
        return this.tracingLevel_;
    }

    @Override
    public int setTracingLevel(int tl) throws RoutingRuleException {
        int oldtl = this.tracingLevel_;
        this.tracingLevel_ = tl;
        if (this.tracingLevel_ == 0) {
            this.tracingXMLStream_ = null;
        }
        if (this.tracingLevel_ > 0 && this.tracingXMLStream_ == null) {
            try {
                this.tracingXMLStream_ = XMLOutputStreamFactory.create();
                this.tracingXMLStream_.startDocument();
                this.tracingXMLStream_.startTag("XCBR_TRACE");
            }
            catch (Exception e) {
                throw new RoutingRuleException("trace initialization failed", e);
            }
        }
        return oldtl;
    }

    @Override
    public boolean getRoutingDisabled() {
        return this.routingDisabled_;
    }

    @Override
    public boolean setRoutingDisabled(boolean rd) {
        boolean oldrd = this.routingDisabled_;
        this.routingDisabled_ = rd;
        return oldrd;
    }

    @Override
    public void trace(Throwable t) throws RoutingRuleException {
        if (this.tracingXMLStream_ != null) {
            this.writeThrowable(this.tracingXMLStream_, t);
        }
    }

    private void writeThrowable(XMLOutputStream stream, Throwable t) throws RoutingRuleException {
        try {
            Throwable cause;
            stream.startTag("Throwable");
            stream.addAttribute("Class", t.getClass().getName());
            String message = t.getMessage();
            if (message != null) {
                this.tracingXMLStream_.writeTag(null, "Message", null, message);
            }
            if ((cause = t.getCause()) != null) {
                stream.startTag("Cause");
                this.writeThrowable(stream, cause);
                stream.endTag();
            }
            stream.endTag();
        }
        catch (Exception e2) {
            throw new RoutingRuleException("trace error", e2);
        }
    }

    @Override
    public void trace(RoutingEndpoint re) throws RoutingRuleException {
        if (this.tracingXMLStream_ != null) {
            this.writeEndpoint(this.tracingXMLStream_, re);
        }
    }

    private void writeEndpoint(XMLOutputStream stream, RoutingEndpoint re) throws RoutingRuleException {
        try {
            stream.startTag("Endpoint");
            stream.addAttribute("Type", re.getRoutingType());
            stream.writeTagData(re.getName());
            stream.endTag();
        }
        catch (Exception e) {
            throw new RoutingRuleException("trace error", e);
        }
    }

    @Override
    public void sendTraceMessage(InvocationContext context) throws RoutingRuleException {
        if (this.tracingXMLStream_ != null) {
            try {
                this.tracingXMLStream_.endTag();
                this.tracingXMLStream_.endDocument();
                String trace = this.tracingXMLStream_.toString();
                XQMessageFactory msgFactory = context.getMessageFactory();
                XQMessage msg = msgFactory.createMessage();
                XQPart part = msg.createPart((Object)trace, "text/xml");
                msg.addPart(part);
                XQEnvelopeFactory envFactory = context.getEnvelopeFactory();
                XQEnvelope env = envFactory.createDefaultEnvelope();
                env.setMessage(msg);
                context.addOutgoing(env);
            }
            catch (Exception e) {
                throw new RoutingRuleException("trace error", e);
            }
        }
    }
}

