/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.def.ExpressionDefProcessorFactory;
import com.sonicsw.esb.expression.def.el.ELExpressionDefProcessFactory;
import com.sonicsw.esb.expression.el.ELUtils;
import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.mapping.MappingUtils;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ProcessModelException;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQProcessContextImpl;
import com.sonicsw.xqimpl.service.XQRegistry;

public class DynamicAddressStepNode
extends EsbStepNode {
    private static ExpressionDefProcessorFactory s_expressionDefFactory = new ELExpressionDefProcessFactory();
    private Expression m_expression;

    public DynamicAddressStepNode(String id, ActivityGroup parent) {
        super(id, parent);
    }

    @Override
    public void setEndpointRef(XQAddress endpointRef) {
        super.setEndpointRef(endpointRef);
        String expression = this.m_endpointRef.getName();
        if (!s_expressionDefFactory.isValidExpression(expression)) {
            throw new ProcessModelException("Expression `" + expression + "` is not a valid EL expression");
        }
        ExpressionContext exprCtx = MappingUtils.getStaticExpressionContext();
        this.m_expression = MappingUtils.getStaticExpressionFactory().createExpression(exprCtx, expression);
    }

    @Override
    public XQAddress getEndpointRef(Token token) {
        String addressKey;
        if (token == null) {
            return this.m_endpointRef;
        }
        XQAbstractAddressImpl endpointRef = null;
        if (this.m_endpointRef.getType() == 4 && (endpointRef = (XQAbstractAddressImpl)token.getProperty(addressKey = this.m_id + ".AddressVariable")) == null) {
            ExpressionContext exprCtx = MappingUtils.getExpressionContext(((EsbMessageExchange)token.getData()).getInputMessage(), (XQServiceContext)null);
            XQParameters params = DynamicAddressStepNode.populateBasicXQParameters(token, this, null);
            exprCtx.setValue("esbp", new XQProcessContextImpl(params));
            endpointRef = ELUtils.getAddress(exprCtx, this.m_expression, token, s_log);
            if (endpointRef != null) {
                token.setProperty(addressKey, endpointRef);
                token.setProperty("NextAddrDynamic", "VariableEPRef");
                s_log.logInformation("Resolved the address of step `" + this + "` to `" + endpointRef + "`");
            }
        }
        if (token != null && endpointRef == null) {
            throw new ItineraryException("Cannot determine target address for step " + this.m_displayName, token);
        }
        return endpointRef;
    }

    @Override
    protected XQDispatcher validateMessageExchange(Token token) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        assert (mex != null);
        XQAddress destXQAddress = mex.getDestinationAddress();
        if (destXQAddress == null) {
            throw new ItineraryException("Cannot process message as destination address not found", token);
        }
        XQDispatcher dispatcher = null;
        XQAddress endpointRef = this.getEndpointRef(token);
        if (endpointRef.getType() == 1) {
            String serviceName = endpointRef.getName();
            dispatcher = XQRegistry.instance().lookupService(serviceName);
            if (dispatcher == null) {
                throw new ItineraryException("The address: `" + endpointRef + "` for step: `" + this + "` cannot be executed in this container", token);
            }
        }
        mex.setInProcess(true);
        return dispatcher;
    }

    public static boolean isExpressionAddress(XQAbstractAddressImpl endpointRef) {
        return endpointRef.getType() == 4;
    }
}

