/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl;

import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.invk.ESBEndpoint;
import com.sonicsw.xqimpl.invk.ESBException;
import com.sonicsw.xqimpl.invk.ESBOperation;
import com.sonicsw.xqimpl.invk.ESBServiceFactory;
import com.sonicsw.xqimpl.invkimpl.ESBOperationImpl;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.esb.ESBWSIFJMSDestination;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.esb.ESBWSIFPort;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFService;

public class ESBEndpointImpl
implements ESBEndpoint {
    protected WSIFPort m_wsifPort;
    protected WSIFMessage m_portContext;
    protected ESBServiceFactory m_factory;

    public ESBEndpointImpl(ESBServiceFactory factory, String port, XQConnectionConfig connectionConfig, WSIFService wsifService, String endpointURL) throws ESBException {
        this.m_factory = factory;
        try {
            this.m_wsifPort = port != null ? wsifService.getPort(port) : wsifService.getPort();
            if (endpointURL != null && this.m_wsifPort instanceof ESBWSIFPort) {
                ESBWSIFJMSDestination dest = ((ESBWSIFPort)this.m_wsifPort).getDestination();
                dest.m_locationURL = endpointURL;
            }
            this.m_portContext = this.m_wsifPort.getContext();
            if (connectionConfig != null) {
                this.m_portContext.setObjectPart("ConnectionConfig", (Object)connectionConfig);
            }
            if (this.m_factory.getDefaultJMSConnectionConfig() != null) {
                this.m_portContext.setObjectPart("DefaultJMSConnectionConfig", (Object)this.m_factory.getDefaultJMSConnectionConfig());
            }
            if (this.m_factory.getDefaultHTTPConnectionConfig() != null) {
                this.m_portContext.setObjectPart("DefaultHTTPConnectionConfig", (Object)this.m_factory.getDefaultHTTPConnectionConfig());
            }
            if (this.m_factory.getEnvironmentProperties() != null) {
                this.m_portContext.setObjectPart("ConfigManagerProps", (Object)this.m_factory.getEnvironmentProperties());
            }
            if (this.m_factory.getProxy() != null) {
                this.m_portContext.setObjectPart("DirectoryServiceProxy", (Object)this.m_factory.getProxy());
            }
            this.m_wsifPort.setContext(this.m_portContext);
        }
        catch (WSIFException ex) {
            ESBException esbEx = new ESBException(ex.getLocalizedMessage(), 4);
            esbEx.setLinkedException(ex);
            throw esbEx;
        }
    }

    void setConnection(XQConnectionConfig connectionConfig) throws ESBException {
        try {
            this.m_portContext.setObjectPart("ConnectionConfig", (Object)connectionConfig);
            this.m_wsifPort.setContext(this.m_portContext);
        }
        catch (WSIFException ex) {
            ESBException esbEx = new ESBException(ex.getLocalizedMessage(), 4);
            esbEx.setLinkedException(ex);
            throw esbEx;
        }
    }

    @Override
    public ESBOperation getOperation(String operation) throws ESBException {
        return new ESBOperationImpl(operation, this.m_wsifPort);
    }

    @Override
    public ESBOperation getOperation(String operation, String input, String output) throws ESBException {
        return new ESBOperationImpl(operation, input, output, this.m_wsifPort);
    }

    @Override
    public void close() throws ESBException {
        try {
            this.m_wsifPort.close();
        }
        catch (WSIFException ex) {
            ESBException esbEx = new ESBException(ex.getLocalizedMessage(), 4);
            esbEx.setLinkedException(ex);
            throw esbEx;
        }
    }
}

