/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.connector.jms.XQJMSMessage;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseEsbWsifJmsDestination;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.xml.soap.MimeHeader;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.wsif.WSIFException;

public class ESBWSIFJMSDestination
extends BaseEsbWsifJmsDestination {
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);

    public ESBWSIFJMSDestination(String location) throws WSIFException {
        super(location);
    }

    @Override
    public String getDefaultConnectionKey() {
        if (this.isHTTPDestination()) {
            return "DefaultHTTPConnectionConfig";
        }
        return "DefaultJMSConnectionConfig";
    }

    public boolean isHTTPDestination() {
        return this.m_locationURL.startsWith("http://") || this.m_locationURL.startsWith("https://");
    }

    @Override
    public Endpoint getEndpointInternal(Hashtable configMgrProps) throws WSIFException {
        if (!this.isHTTPDestination()) {
            return super.getEndpointInternal(configMgrProps);
        }
        try {
            String routingNode = this.getRoutingNode();
            routingNode = routingNode != null ? routingNode : "sonic.http";
            String routingDestination = routingNode + "::" + this.m_locationURL;
            log.logDebug("getEndpointInternal: routingNode=" + routingNode);
            log.logDebug("getEndpointInternal: routingDestination=" + routingDestination);
            return this.createHTTPXQEndpoint(this.createHTTPXQEndpointConfig(routingNode, routingDestination, "QUEUE", this.getConnectionConfig()), this.getConnectionConfig(), configMgrProps);
        }
        catch (Throwable ex) {
            throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
        }
    }

    private XQEndpointConfig createHTTPXQEndpointConfig(String routingNode, String destinationName, String destinationType, XQConnectionConfig connectionConfig) throws XQEndpointCreationException, JMSException {
        String endpointName = destinationName;
        log.logDebug("ESBWSIFJMSDestination: Creating XQEndpointConfig for name=" + endpointName);
        log.logDebug("ESBWSIFJMSDestination: m_locationURL=" + this.m_locationURL);
        String connectionName = "http_defaultConnection";
        if (connectionConfig != null) {
            connectionName = connectionConfig.getName();
        }
        XQEndpointConfig endpointConfig = EndpointManager.getInstance().createXQEndpointConfig(endpointName, destinationName, destinationType, connectionName);
        XQParametersImpl params = endpointConfig.getParameters();
        params.setIntParameter("jmsPriority", 1, -1);
        if (this.inProps.get("timeToLive") != null) {
            params.setLongParameter("timeToLive", 1, ((Long)this.inProps.get("timeToLive")).longValue());
        }
        return endpointConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Endpoint createHTTPXQEndpoint(XQEndpointConfig endpointConfig, XQConnectionConfig config, Hashtable props) throws XQEndpointCreationException, JMSException {
        Object object = m_endpointManagerLock;
        synchronized (object) {
            this.m_runningInContainer = props == null;
            Endpoint xqEndpoint = null;
            EndpointManager endpointManager = EndpointManager.getInstance();
            if (endpointManager.isEndpointDefined(endpointConfig.getName())) {
                xqEndpoint = (Endpoint)endpointManager.getEndpoint(endpointConfig.getName());
            } else {
                endpointManager.createEndpoint(endpointConfig, false, config, props);
                xqEndpoint = (Endpoint)endpointManager.getEndpoint(endpointConfig.getName());
            }
            if (!this.m_runningInContainer) {
                Integer counter = (Integer)m_endpointInstanceTracker.get(xqEndpoint);
                if (counter == null) {
                    counter = new Integer(0);
                }
                counter = new Integer(counter + 1);
                m_endpointInstanceTracker.put(xqEndpoint, counter);
            }
            return xqEndpoint;
        }
    }

    public XQMessage createXQMessage(MessageContext msgContext) throws WSIFException {
        XQJMSMessage xqMsg = null;
        Message requestMessage = null;
        XQPart soapPart = null;
        try {
            xqMsg = new XQJMSMessage();
            xqMsg = this.setJMSProperties(xqMsg);
            XQAddress ESBReplyTo = (XQAddress)this.inProps.get("ESBReplyTo");
            String ESBCorrelationId = (String)this.inProps.get("{http://www.sonicsw.com/esb}ESBCorrelationId");
            xqMsg.setReplyTo(ESBReplyTo);
            if (ESBCorrelationId != null) {
                xqMsg.setCorrelationId(ESBCorrelationId);
            }
            requestMessage = msgContext.getRequestMessage();
            requestMessage.getContentType(msgContext.getSOAPConstants());
            Message axisMessage = msgContext.getRequestMessage();
            String soapPartContents = axisMessage.getSOAPPartAsString();
            String content_type = (Integer)this.inProps.get("com_sonicsw_xqimpl_invk_ESBConstants_RequestMessageType") == 1 ? "text/plain" : "text/xml";
            soapPart = this.isHTTPDestination() ? xqMsg.createPart(soapPartContents, "text/xml") : xqMsg.createPart(soapPartContents, content_type);
            xqMsg.addPartAt(soapPart, 0);
        }
        catch (XQMessageException ex) {
            throw new GeneralWSInvocationException("xq-message-create-failed", null, ex);
        }
        catch (IOException ioe) {
            throw new GeneralWSInvocationException(ioe.toString(), null);
        }
        return xqMsg;
    }

    private XQPart setPartHeaders(XQPart xqPart, Iterator headers) {
        while (headers.hasNext()) {
            MimeHeader header = (MimeHeader)headers.next();
            xqPart.getHeader().setValue(header.getName(), header.getValue());
        }
        return xqPart;
    }
}

