/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.xqimpl.script.wsdl.All;
import com.sonicsw.xqimpl.script.wsdl.Assertion;
import com.sonicsw.xqimpl.script.wsdl.ExactlyOne;
import com.sonicsw.xqimpl.script.wsdl.Policy;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

abstract class PolicyElement {
    protected Element m_elem = null;
    protected List m_children = new ArrayList();

    static PolicyElement createPolicyElement(Element e) {
        QName qname = new QName(e.getNamespaceURI(), e.getLocalName());
        if (qname.equals(Policy.WSP_POLICY_QNAME)) {
            return new All(e);
        }
        if (qname.equals(Policy.WSP_POLICY_EXACTLY_ONE_QNAME)) {
            return new ExactlyOne(e);
        }
        if (qname.equals(Policy.WSP_POLICY_ALL_QNAME)) {
            return new All(e);
        }
        return new Assertion(e);
    }

    PolicyElement() {
    }

    PolicyElement(Element e) {
        this.m_elem = e;
    }

    PolicyElement(List list) {
        this.m_children = list;
    }

    void addChild(Object o) {
        PolicyElement.addToResult(this.m_children, o);
    }

    void normalize() throws WSDLHelperException {
    }

    List getChildren() {
        return this.m_children;
    }

    boolean isOptional() {
        return false;
    }

    void processChildren() throws WSDLHelperException {
        if (this.m_elem == null) {
            return;
        }
        List childNodes = DOMUtils.getImmediateChildElements((Element)this.m_elem);
        for (int i = 0; i < childNodes.size(); ++i) {
            Element child = (Element)childNodes.get(i);
            PolicyElement p = PolicyElement.createPolicyElement(child);
            p.normalize();
            this.addChild(p);
        }
    }

    void applyAssociativity() {
        ArrayList<PolicyElement> newChildren = new ArrayList<PolicyElement>();
        for (int i = 0; i < this.m_children.size(); ++i) {
            PolicyElement e = (PolicyElement)this.m_children.get(i);
            if (e.getClass().isAssignableFrom(this.getClass())) {
                newChildren.addAll(e.getChildren());
                continue;
            }
            newChildren.add(e);
        }
        this.m_children = newChildren;
    }

    void normalizeOptionalAssertions() throws WSDLHelperException {
        ArrayList<PolicyElement> newChildren = new ArrayList<PolicyElement>();
        for (int i = 0; i < this.m_children.size(); ++i) {
            PolicyElement e = (PolicyElement)this.m_children.get(i);
            if (e.isOptional()) {
                Assertion newAssertion = ((Assertion)e).clone(false);
                e = new ExactlyOne();
                e.addChild(newAssertion);
                e.addChild(new All());
            }
            newChildren.add(i, e);
        }
        this.m_children = newChildren;
    }

    private static void addToResult(List list, Object obj) {
        if (obj instanceof List) {
            list.addAll((List)obj);
        } else {
            list.add(obj);
        }
    }

    public static List computeCrossProduct(List input) {
        if (input.isEmpty()) {
            return new ArrayList();
        }
        ArrayList results = (ArrayList)input.get(0);
        List tail = input.subList(1, input.size());
        if (!tail.isEmpty()) {
            List r = PolicyElement.computeCrossProduct(tail);
            ArrayList mergedResults = new ArrayList();
            for (int i = 0; i < results.size(); ++i) {
                for (int j = 0; j < r.size(); ++j) {
                    ArrayList s2 = new ArrayList();
                    PolicyElement.addToResult(s2, results.get(i));
                    PolicyElement.addToResult(s2, r.get(j));
                    mergedResults.add(s2);
                }
            }
            results = mergedResults;
        }
        return results;
    }

    static List computeVectorProduct(List op1, List op2) {
        ArrayList<All> retval = new ArrayList<All>();
        for (int i = 0; i < op2.size(); ++i) {
            ArrayList sublist = new ArrayList();
            sublist.addAll(op1);
            sublist.add(op2.get(i));
            All a = new All(sublist);
            retval.add(a);
        }
        return retval;
    }

    abstract String serialize(String var1);

    protected String serializeChildren(String indent) {
        String s = "";
        for (int i = 0; i < this.m_children.size(); ++i) {
            s = s + ((PolicyElement)this.m_children.get(i)).serialize(indent) + "\n";
        }
        return s;
    }
}

