/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.process.model.impl.DataToken;
import com.sonicsw.esb.run.RunContext;
import com.sonicsw.esb.run.impl.util.RunUtils;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.visitor.ESBVisitorContext;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointContextContainer;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.endpoint.container.EndpointUtils;
import com.sonicsw.xqimpl.envelope.Envelope;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import com.sonicsw.xqimpl.service.CriticalException;
import com.sonicsw.xqimpl.service.InvalidStateException;
import com.sonicsw.xqimpl.service.MessageAlreadyRejected;
import com.sonicsw.xqimpl.service.RejectedMessageDispatcher;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQRegistry;
import com.sonicsw.xqimpl.service.XQServiceConstants;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MessageSendingHelper {
    public static final String ENABLE_CLEAR_REPLY_TO_IN_PROCESS = "SonicESB.Process.ClearReplyTo";
    private static XQLog log = XQLogImpl.getCategoryLog((int)128);
    private static RejectedMessageDispatcher rejectedMessageDispatcher = new RejectedMessageDispatcher();
    private static ThreadLocal<HashMap<String, String>> s_exoConnectionMapContext = new ThreadLocal<HashMap<String, String>>(){

        @Override
        protected HashMap<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };

    public static void sendToAddress(EsbMessageExchange mex, String sender) throws Throwable {
        XQMessage message = mex.getInputMessage();
        XQAddress address = mex.getDestinationAddress();
        XQAddress resolvedAddress = MessageSendingHelper.resolveReplyTo(address, message, true);
        if (resolvedAddress != address) {
            mex.setDestinationAddress(resolvedAddress);
        }
        if (resolvedAddress == null) {
            XQServiceException ex = new XQServiceException("Attempt to send to null address by " + sender + "Please check the endpoints associated with the process");
            log.logError((Throwable)ex);
            throw ex;
        }
        switch (resolvedAddress.getType()) {
            case 0: {
                if (mex.isExchangeImmediate()) {
                    MessageSendingHelper.sendToEndpointImmediate(mex, sender);
                    break;
                }
                MessageSendingHelper.sendToEndpoint(mex, sender);
                break;
            }
            case 1: {
                MessageSendingHelper.sendToService(mex, sender);
                break;
            }
            case 2: {
                MessageSendingHelper.sendToProcess(mex, sender);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendToEndpoint(EsbMessageExchange mex, String sender) throws Exception {
        XQAddress address = mex.getDestinationAddress();
        XQMessage message = mex.getInputMessage();
        EndpointContextContainer endpointContext = mex.getEndpointContext();
        String endpointName = address.getName();
        Endpoint transientEndpoint = null;
        XQDispatcher dispatcher = null;
        transientEndpoint = EndpointUtils.getTransientEndpoint(address);
        if (transientEndpoint == null) {
            dispatcher = MessageSendingHelper.getEndpointDispatcher(endpointName);
        }
        if (dispatcher != null) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("MessageSendingHelper.sendToEndpoint sending in-container message: Sender=" + sender + " endpointName=" + endpointName + " JMSDestination=" + message.getHeaderValue("JMSDestination"));
            }
            MessageSendingHelper.setEntryEndpoint(message, address.getName());
            MessageSendingHelper.setSender(message, sender);
            mex.setXQParameters(null);
            dispatcher.onMessage(mex);
            return;
        }
        XQQualityofService qos = null;
        if (mex.getXQParameters() != null) {
            qos = XQQualityofService.valueOf((String)mex.getXQParameters().getParameter("PARAM_SEND_IMMEDIATELY_WITH_QOS", 1));
        }
        String debugInfo = "";
        if (XQContainer.isTestContainer()) {
            MessageSendingHelper.reserializeRunInfo(message, false);
        }
        if (log.isDebugLoggingEnabled()) {
            debugInfo = "Sender=" + sender + " QoS=" + qos + " to endpoint=" + endpointName + " JMSDestination=" + message.getHeaderValue("JMSDestination");
        }
        Endpoint endpoint = null;
        if (transientEndpoint != null) {
            endpoint = transientEndpoint;
            endpointContext.registerTransientSendEndpoint(endpointName, endpoint);
        } else {
            endpoint = (Endpoint)endpointContext.getEndpoint(endpointName);
        }
        try {
            ESBVisitor visitor = ((XQMessageInternal)message).getVisitor();
            HashMap<String, String> visitorParams = null;
            if (visitor != null) {
                visitorParams = new HashMap<String, String>();
                visitorParams.put("ESBVisitor.PARAM_ENDPOINT_NAME", endpointName);
                visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", (String)message);
                visitor.sentToEndpoint(visitorParams);
            }
            if (qos != null) {
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("MessageSendingHelper.sendToEndpoint sending message immediately: " + debugInfo);
                }
                if (visitor != null) {
                    visitor.receivedFromEndpoint(visitorParams);
                }
                endpoint.sendWithQoS(null, true, qos, message);
                EndpointManager.getInstance().removeEndpointIfTemporary(endpointName);
            } else {
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("MessageSendingHelper.sendToEndpoint sending message: " + debugInfo);
                }
                if (visitor != null) {
                    visitor.receivedFromEndpoint(visitorParams);
                }
                endpointContext.send(endpointName, message);
            }
        }
        finally {
            if (transientEndpoint != null) {
                endpointContext.unregisterTransientSendEndpoint(endpointName);
            }
        }
    }

    private static void sendToEndpointImmediate(EsbMessageExchange mex, String sender) throws Throwable {
        ESBVisitor v;
        Endpoint transientEndpoint = null;
        Endpoint endpoint = null;
        XQDispatcher dispatcher = null;
        XQAddress address = mex.getDestinationAddress();
        XQMessage message = mex.getInputMessage();
        XQQualityofService qos = mex.getQOS();
        String endpointName = address.getName();
        transientEndpoint = EndpointUtils.getTransientEndpoint(address);
        if (transientEndpoint == null) {
            dispatcher = MessageSendingHelper.getEndpointDispatcher(endpointName);
        }
        if (dispatcher != null) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("MessageSendingHelper: sendToEndpointImmediate: sending in-container message to " + endpointName + "with qos=" + qos.toString());
            }
            MessageSendingHelper.setEntryEndpoint(message, endpointName);
            MessageSendingHelper.setSender(message, sender);
            dispatcher.onMessageImmediate(mex);
            return;
        }
        if (qos == null) {
            qos = XQQualityofService.BEST_EFFORT;
        }
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("MessageSendingHelper.sendToEndpointImmediate sending message: Sender=" + sender + " QoS=" + qos + " to endpoint=" + endpointName + " JMSDestination=" + message.getHeaderValue("JMSDestination"));
        }
        endpoint = transientEndpoint == null ? (Endpoint)mex.getEndpointRegistry().getEndpoint(endpointName) : transientEndpoint;
        if (XQContainer.isTestContainer() && !message.doesPartExist("SonicESB.RME")) {
            MessageSendingHelper.reserializeRunInfo(message, true);
        }
        if ((v = ((XQMessageInternal)message).getVisitor()) != null) {
            HashMap<String, String> visitorParams = new HashMap<String, String>();
            visitorParams.put("ESBVisitor.PARAM_ENDPOINT_NAME", endpointName);
            visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", (String)message);
            v.sentToEndpoint(visitorParams);
            v.receivedFromEndpoint(visitorParams);
        }
        HashMap<String, String> connectionMap = endpoint.sendWithQoS(mex.getSessionName(), mex.getCommitFlag(), qos, message);
        MessageSendingHelper.setConnectionMap(connectionMap);
        EndpointManager.getInstance().removeEndpointIfTemporary(endpointName);
    }

    private static void setConnectionMap(HashMap<String, String> connectionMap) {
        HashMap<String, String> exoThreadLocalMap = s_exoConnectionMapContext.get();
        exoThreadLocalMap.putAll(connectionMap);
    }

    public static HashMap<String, String> getConnectionMap() {
        return s_exoConnectionMapContext.get();
    }

    static XQDispatcher getServiceDispatcher(String serviceName) {
        if (XQContainer.useIntraContainer() || XQContainer.isInternalContainerComponent(serviceName)) {
            XQDispatcher dispatcher = XQRegistry.instance().lookupService(serviceName);
            return dispatcher;
        }
        return null;
    }

    static XQDispatcher getEndpointDispatcher(String endpointName) {
        if (XQContainer.useIntraContainer()) {
            XQDispatcher dispatcher = XQRegistry.instance().lookupEndpoint(endpointName);
            return dispatcher;
        }
        return null;
    }

    private static void sendToService(EsbMessageExchange mex, String sender) throws Throwable {
        String serviceName = mex.getDestinationAddress().getName();
        XQMessage message = mex.getInputMessage();
        XQDispatcher dispatcher = MessageSendingHelper.getServiceDispatcher(serviceName);
        if (dispatcher != null) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("MessageSendingHelper.sendToService sending in-container message: Sender=" + sender + " serviceName=" + serviceName + " JMSDestination=" + message.getHeaderValue("JMSDestination"));
            }
            MessageSendingHelper.setSender(message, sender);
            mex.setXQParameters(null);
            if (mex.isExchangeImmediate()) {
                dispatcher.onMessageImmediate(mex);
            } else {
                dispatcher.onMessage(mex);
            }
            return;
        }
        XQConfigManager configManager = XQConfigManager.getInstance(null);
        XQServiceConfig serviceConfig = configManager.lookupServiceConfig(serviceName);
        if (serviceConfig.getEntryEndpoint() == null) {
            throw new XQEndpointException("Unable to send to `" + serviceName + "` service. Entry endpoint is not defined and intra-container is disabled.");
        }
        mex.setDestinationAddress(new XQAddressImpl(serviceConfig.getEntryEndpoint(), 0));
        if (mex.isExchangeImmediate()) {
            MessageSendingHelper.sendToEndpointImmediate(mex, sender);
        } else {
            MessageSendingHelper.sendToEndpoint(mex, sender);
        }
    }

    private static void sendToProcess(EsbMessageExchange mex, String sender) throws Throwable {
        XQMessage message = mex.getInputMessage();
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("MessageSendingHelper.sendToProcess sending to: Process address=" + mex.getDestinationAddress().getName() + " Sender=" + sender + " JMSDestination=" + message.getHeaderValue("JMSDestination"));
        }
        DataToken token = new DataToken(null, null, mex);
        ((ItineraryEngine)XQContainer.getProcessEngine()).handleToken(token);
    }

    public static <T extends EsbMessageExchange> void populateFaultbox(T mex, List<XQEnvelope> faultBoxList, XQDispatcher dispatcher, List<T> mexList) throws Throwable {
        if (mex.isExchangeImmediate()) {
            MessageSendingHelper.sendEnvelopesImmediate(faultBoxList, mex, dispatcher.toString(), mexList);
        } else {
            dispatcher.incrementFaultStatistic();
            MessageSendingHelper.sendEnvelopes(faultBoxList, mex, dispatcher.toString(), mexList);
        }
    }

    public static <T extends EsbMessageExchange> void populateOutbox(T mex, List<XQEnvelope> outBoxList, XQDispatcher dispatcher, List<T> mexList) throws Throwable {
        if (mex.isExchangeImmediate()) {
            MessageSendingHelper.sendEnvelopesImmediate(outBoxList, mex, dispatcher.toString(), mexList);
        } else {
            int count = MessageSendingHelper.sendEnvelopes(outBoxList, mex, dispatcher.toString(), mexList);
            dispatcher.updateOutboxStatistic(count);
        }
    }

    public static <T extends EsbMessageExchange> int sendEnvelopes(List<XQEnvelope> mailbox, T mex, String sender, List<T> mexList) throws Throwable {
        boolean inProcess = mexList != null;
        int count = 0;
        Iterator<XQEnvelope> envelopes = mailbox.iterator();
        RunContext originalRunContext = null;
        ESBVisitorContext visitorContext = null;
        while (envelopes.hasNext()) {
            XQEnvelope envelope = envelopes.next();
            XQMessage message = envelope.getMessage();
            Iterator addresses = envelope.getAddresses();
            if (!addresses.hasNext()) {
                MessageSendingHelper.rejectNullAddress(sender, mex, message, mexList);
                continue;
            }
            while (addresses.hasNext()) {
                XQAddress address = (XQAddress)addresses.next();
                if (address == null) {
                    MessageSendingHelper.rejectNullAddress(sender, mex, message, mexList);
                    continue;
                }
                try {
                    XQAddress resolvedAddress;
                    XQMessage oldMsg = message;
                    boolean clearReplyTo = !inProcess || Boolean.getBoolean(ENABLE_CLEAR_REPLY_TO_IN_PROCESS);
                    XQAddress xQAddress = resolvedAddress = mex.isInFaultProcess() ? address : MessageSendingHelper.resolveReplyTo(address, message, clearReplyTo);
                    if (addresses.hasNext() && (mex.isInProcess() || MessageSendingHelper.isDestinationIntraContainer(resolvedAddress))) {
                        message = (XQMessage)oldMsg.clone();
                    }
                    originalRunContext = MessageSendingHelper.retrieveRunContext(originalRunContext, message);
                    visitorContext = MessageSendingHelper.cloneRunAndVisitorContexts(message, originalRunContext, visitorContext);
                    ++count;
                    EsbMessageExchange newMex = (EsbMessageExchange)mex.clone();
                    newMex.setDestinationAddress(resolvedAddress);
                    newMex.setInputMessage(message);
                    newMex.setResponseToReplyTo(resolvedAddress != address);
                    if (inProcess) {
                        mexList.add(newMex);
                    } else {
                        MessageSendingHelper.sendToAddress(newMex, sender);
                    }
                    message = oldMsg;
                }
                catch (CriticalException e) {
                    throw e;
                }
                catch (MessageAlreadyRejected msgRejected) {
                }
                catch (Throwable thrown) {
                    String errorCode = mex.getQOS().toString().equals("EXACTLY_ONCE") ? "EXACTLY_ONCE_FAILURE" : "XQ_ENDPOINT_EXCEPTION";
                    rejectedMessageDispatcher.handleRME(sender, thrown, message, mex, mexList, errorCode);
                }
            }
        }
        return count;
    }

    private static <T extends EsbMessageExchange> void rejectNullAddress(String sender, T mex, XQMessage outboundMsg, List<T> mexList) {
        String errMsg = "A message that we attempted to send had no XQAddress. Please check the endpoints associated with the service.";
        if (mex.getRMEAddress() != null) {
            rejectedMessageDispatcher.handleRME(sender, new Exception(errMsg), outboundMsg, mex, mexList, "SEND_NULL_ADDRESS");
        } else {
            log.logError(errMsg);
            log.logError("Rejected message with code SEND_NULL_ADDRESS could not be created, as no RME address defined for the service");
        }
    }

    public static <T extends EsbMessageExchange> void sendEnvelopesImmediate(List<XQEnvelope> mailbox, T mex, String sender, List<T> mexList) throws Throwable {
        Iterator<XQEnvelope> envelopes = mailbox.iterator();
        RunContext originalRunContext = null;
        ESBVisitorContext visitorContext = null;
        while (envelopes.hasNext()) {
            XQEnvelope envelope = envelopes.next();
            XQMessage message = envelope.getMessage();
            Iterator addresses = envelope.getAddresses();
            if (!addresses.hasNext()) continue;
            while (addresses.hasNext()) {
                XQAddress address = (XQAddress)addresses.next();
                if (address == null) continue;
                try {
                    Envelope env = (Envelope)envelope;
                    XQMessage oldMsg = message;
                    if (addresses.hasNext() && (mex.isInProcess() || MessageSendingHelper.isDestinationIntraContainer(address))) {
                        message = (XQMessage)oldMsg.clone();
                    }
                    originalRunContext = MessageSendingHelper.retrieveRunContext(originalRunContext, message);
                    visitorContext = MessageSendingHelper.cloneRunAndVisitorContexts(message, originalRunContext, visitorContext);
                    boolean clearReplyTo = mexList == null || Boolean.getBoolean(ENABLE_CLEAR_REPLY_TO_IN_PROCESS);
                    XQAddress resolvedAddress = MessageSendingHelper.resolveReplyTo(address, message, clearReplyTo);
                    EsbMessageExchange newMex = (EsbMessageExchange)mex.clone();
                    newMex.setDestinationAddress(resolvedAddress);
                    newMex.setInputMessage(message);
                    newMex.setResponseToReplyTo(resolvedAddress != address);
                    if (mexList != null) {
                        mexList.add(newMex);
                    } else {
                        MessageSendingHelper.sendToAddress(newMex, sender);
                    }
                    message = oldMsg;
                }
                catch (InvalidStateException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (mex.getQOS() != XQQualityofService.EXACTLY_ONCE) continue;
                    throw e;
                }
            }
        }
    }

    private static RunContext retrieveRunContext(RunContext originalRunContextParam, XQMessage message) {
        RunContext originalRunContext = originalRunContextParam;
        if (originalRunContext == null) {
            originalRunContext = (RunContext)((XQMessageInternal)message).getSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        }
        return originalRunContext;
    }

    private static ESBVisitorContext cloneRunAndVisitorContexts(XQMessage message, RunContext originalRunContext, ESBVisitorContext visitorContextParam) {
        ESBVisitorContext visitorContext = visitorContextParam;
        MessageSendingHelper.cloneRunContext(message, originalRunContext);
        if (visitorContext == null) {
            visitorContext = (ESBVisitorContext)((XQMessageInternal)message).getSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT");
        }
        MessageSendingHelper.cloneVisitorContext(message, visitorContext);
        return visitorContext;
    }

    private static void setEntryEndpoint(XQMessage message, String endpoint) {
        if (message instanceof XQMessageInternal) {
            ((XQMessageInternal)message).addSidebandProperty("SonicESB.CurrentEntryEndpoint", endpoint);
        }
    }

    public static void setSender(XQMessage message, String sender) {
        if (message instanceof XQMessageInternal) {
            ((XQMessageInternal)message).addSidebandProperty("SonicESB.IntraContainerSender", sender);
        }
    }

    public static XQAddress resolveReplyTo(XQAddress address, XQMessage message) throws XQEndpointException, XQMessageException {
        return MessageSendingHelper.resolveReplyTo(address, message, false);
    }

    private static XQAddress resolveReplyTo(XQAddress address, XQMessage message, boolean clear) throws XQEndpointException, XQMessageException {
        if (address != null && address.getType() == 3) {
            XQAddress replyTo = message.getReplyTo();
            if (replyTo == null) {
                throw new XQEndpointException("ReplyTo does not exist for this message");
            }
            if (replyTo.getType() == 3) {
                throw new XQEndpointException("ReplyTo address for message is also ReplyTo");
            }
            if (clear) {
                message.setReplyTo(null);
            }
            return replyTo;
        }
        return address;
    }

    private static void reserializeRunInfo(XQMessage msg, boolean immediate) throws XQMessageException {
        XQMessageInternal internalMsg = (XQMessageInternal)msg;
        String jeriUUID = (String)internalMsg.getSidebandProperty("SonicESB.JERI_UUID");
        RunContext runContext = (RunContext)internalMsg.getSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        Integer type = (Integer)internalMsg.getSidebandProperty("SonicESB.BOX_TYPE");
        if (runContext != null && jeriUUID != null) {
            byte[] testContextBytes = null;
            try {
                testContextBytes = RunUtils.serializeRunContext(runContext);
                if (immediate && type == null) {
                    RunUtils.addExitRunContextPart(msg, testContextBytes);
                } else if (type.equals(XQServiceConstants.INBOX)) {
                    RunUtils.addInboxRunContextPart(msg, testContextBytes);
                } else if (type.equals(XQServiceConstants.OUTBOX)) {
                    RunUtils.addExitRunContextPart(msg, testContextBytes);
                } else if (type.equals(XQServiceConstants.FAULTBOX)) {
                    RunUtils.addFaultRunContextPart(msg, testContextBytes);
                }
            }
            catch (IOException e) {
                log.logDebug((Throwable)e);
                return;
            }
            internalMsg.setStringHeader("SonicESB.REMOTE_JERI_UUID", jeriUUID);
        }
    }

    private static void cloneRunContext(XQMessage msg, RunContext runContext) {
        XQMessageInternal internalMsg = (XQMessageInternal)msg;
        if (runContext != null) {
            com.sonicsw.esb.run.impl.RunContext newContext = new com.sonicsw.esb.run.impl.RunContext((com.sonicsw.esb.run.impl.RunContext)runContext);
            internalMsg.addSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID", newContext);
        }
    }

    private static void cloneVisitorContext(XQMessage message, ESBVisitorContext visitorContext) {
        XQMessageInternal internalMsg = (XQMessageInternal)message;
        if (visitorContext != null) {
            ESBVisitorContext newContext = (ESBVisitorContext)visitorContext.clone();
            internalMsg.addSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT", newContext);
        }
    }

    static boolean isDestinationIntraContainer(XQAddress address) {
        if (address == null) {
            return false;
        }
        return address.getType() == 1 && MessageSendingHelper.getServiceDispatcher(address.getName()) != null || address.getType() == 0 && MessageSendingHelper.getEndpointDispatcher(address.getName()) != null || address.getType() == 2;
    }
}

