/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.envelope.XQPartImpl;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.misc.TypeConverterImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.el.ELException;

public class XQPartConverter
implements TypeConverter {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";

    public <T> T convert(Object value, Class<T> type) throws ELException {
        return this.convert(value, type, DEFAULT_CONTENT_TYPE);
    }

    public <T> T convert(Object value, Class<T> type, String contentType) throws ELException {
        if (value instanceof XQPart) {
            return (T)this.coerceToType((XQPart)value, type);
        }
        if (type == XQPart.class) {
            return (T)this.coerceToXQPart(value, contentType);
        }
        return null;
    }

    private XQPart coerceToXQPart(Object obj, String contentType) {
        if (obj instanceof byte[]) {
            return new XQPartImpl(obj, "application/octet-stream");
        }
        return new XQPartImpl(TypeConverter.DEFAULT.convert(obj, String.class), contentType == null ? DEFAULT_CONTENT_TYPE : contentType);
    }

    private Object coerceToType(XQPart part, Class<?> type) {
        if (type.isInstance(part)) {
            return part;
        }
        if (type == InputStream.class) {
            return this.coerceToInputStream(part);
        }
        if (type == byte[].class) {
            return this.coerceToByteArray(part);
        }
        return TypeConverterImpl.DEFAULT.convert(part.getContent(), type);
    }

    private byte[] coerceToByteArray(XQPart part) {
        Object content = part.getContent();
        if (content instanceof byte[]) {
            return (byte[])content;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            part.getDataHandler().writeTo((OutputStream)bOut);
            return bOut.toByteArray();
        }
        catch (IOException excp) {
            throw new ELException("Failed to convert XQPart to byte[]: ", (Throwable)excp);
        }
    }

    private InputStream coerceToInputStream(XQPart part) {
        try {
            return part.getDataHandler().getInputStream();
        }
        catch (IOException excp) {
            throw new ELException("Failed to convert XQPart to InputStream: ", (Throwable)excp);
        }
    }
}

