/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.itinerary.mapping.DefaultMappingRuleList;
import com.sonicsw.esb.itinerary.mapping.DefaultOutputMappingRule;
import com.sonicsw.esb.process.mapping.FaultMappingRule;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.MappingRule;
import com.sonicsw.esb.process.mapping.MappingRuleList;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FaultMapperHelper {
    private Map<String, MappingRuleList> m_rulesMap = new HashMap<String, MappingRuleList>();
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);

    public void addFaultMappingRule(String name, FaultMappingRule mapRule) {
        MappingRuleList list = this.m_rulesMap.get(name);
        if (list == null) {
            list = new DefaultMappingRuleList(2);
            this.m_rulesMap.put(name, list);
        }
        list.addMappingRule(mapRule);
    }

    public boolean mapFromFault(String name, XQMessage faultMsg, MappingContext mapCtx) {
        MappingRuleList list = this.m_rulesMap.get(name);
        boolean result = true;
        if (list == null) {
            s_log.logWarning("Not applying fault mapping as no rules found for this fault `" + name + "`");
            result = false;
        } else {
            XQMessage busMessage = (XQMessage)mapCtx.getObject(XQMessage.class, true);
            ExpressionContext exprCtx = (ExpressionContext)mapCtx.getObject(ExpressionContext.class, true);
            boolean multipleOutboxMsgs = false;
            Boolean bool = (Boolean)mapCtx.getObject("MultipleMessages", false);
            if (bool != null) {
                multipleOutboxMsgs = bool;
            }
            if (multipleOutboxMsgs) {
                busMessage = (XQMessage)busMessage.clone();
                exprCtx.setValue(0, busMessage);
            }
            mapCtx.addObject(DefaultOutputMappingRule.RESPONSE_MSG, busMessage);
            exprCtx.putContextObject(FaultMapperHelper.class, name);
            exprCtx.setValue("esbpStepOutMsg", faultMsg);
            Iterator<MappingRule> faultRulesIter = list.getMappingRules();
            while (faultRulesIter.hasNext()) {
                FaultMappingRule faultRule = (FaultMappingRule)faultRulesIter.next();
                faultRule.mapFromOutput(faultMsg, mapCtx);
            }
        }
        return result;
    }

    public Map<String, MappingRuleList> getFaultRules() {
        return this.m_rulesMap;
    }
}

