/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.model.impl;

import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.FaultHandler;
import com.sonicsw.esb.process.model.ProcessModelException;
import com.sonicsw.esb.process.model.Scope;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.HashMap;
import java.util.Map;

public class DefaultFaultHandler
implements FaultHandler {
    protected FaultHandler.CatchClause m_defaultCatchClause;
    private Map<String, FaultHandler.CatchClause> m_catchClauses;
    private ExecutableNode m_target;
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);

    public DefaultFaultHandler(ExecutableNode target) {
        this.m_target = target;
        this.m_target.getScope().setFaultHandlers(this);
    }

    @Override
    public ExecutableNode getTarget() {
        return this.m_target;
    }

    @Override
    public Scope getScope() {
        return this.m_target.getScope();
    }

    @Override
    public void addCatchClause(String faultType, ActivityNode faultHandler) {
        if (this.m_catchClauses == null) {
            this.m_catchClauses = new HashMap<String, FaultHandler.CatchClause>();
        }
        FaultHandler.CatchClause clause = this.createCatchClause(faultType, faultHandler);
        this.m_catchClauses.put(clause.getFaultType(), clause);
        if (s_log.isDebugLoggingEnabled()) {
            s_log.logDebug("Adding catch clause " + clause);
        }
    }

    @Override
    public void setDefaultCatchClause(ActivityNode faultHandler) {
        if (this.m_defaultCatchClause != null) {
            throw new ProcessModelException("A default catch clause has already been defined for" + this.m_target.getId());
        }
        this.m_defaultCatchClause = this.createCatchClause(null, faultHandler);
    }

    @Override
    public FaultHandler.CatchClause getCatchClause(String faultType, Token token) {
        FaultHandler.CatchClause fh = null;
        if (this.m_catchClauses != null && this.m_catchClauses.size() > 0) {
            fh = this.m_catchClauses.get(faultType);
        }
        return fh == null ? this.m_defaultCatchClause : fh;
    }

    public FaultHandler.CatchClause getDefaultCatchClause() {
        return this.m_defaultCatchClause;
    }

    protected FaultHandler.CatchClause createCatchClause(String faultType, ActivityNode faultHandler) {
        FaultHandler.CatchClause catchCls = new FaultHandler.CatchClause(faultType, faultHandler);
        return catchCls;
    }

    @Override
    public ActivityNode getFaultHandlerActivityNode(String faultType, Token token) {
        FaultHandler.CatchClause catchClause = this.getCatchClause(faultType, token);
        if (catchClause == null) {
            return null;
        }
        return catchClause.getActivityNode(token);
    }
}

