/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xq.connector.jms.messagingbean.MessagingBean;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointContext;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQServiceConstants;
import java.util.HashMap;
import java.util.Iterator;
import progress.message.jclient.DeliveryMode;

public class JMSEndpointContext
extends EndpointContext {
    private static final boolean DEBUG = false;
    private final String m_name;
    private final String m_qos;
    private final String m_entryEndpointConnection;
    private final HashMap<String, Endpoint> m_endpoints;
    private final int m_deliveryMode;
    private final int m_ackMode;
    private final boolean m_transacted;
    private final String m_mfContainerName;
    private final String m_mfFailoverIdentity;
    private final String m_serviceName;
    private final String m_serviceAppName;
    private JMSEndpoint m_entryEndpoint;

    public JMSEndpointContext(String name, String qos, XQDispatcher dispatcher, String entryEndpointConnection) {
        this.m_name = name;
        this.m_qos = qos;
        this.m_entryEndpointConnection = entryEndpointConnection;
        this.m_mfContainerName = dispatcher.getMFContainerName();
        this.m_mfFailoverIdentity = dispatcher.getMFFailoverIdentity();
        this.m_serviceName = dispatcher.getServiceName();
        this.m_serviceAppName = dispatcher.getServiceAppName();
        this.m_endpoints = new HashMap();
        if (this.m_qos.equals("EXACTLY_ONCE")) {
            this.m_deliveryMode = 2;
            this.m_ackMode = 1004;
            this.m_transacted = true;
        } else if (this.m_qos.equals("AT_LEAST_ONCE")) {
            this.m_deliveryMode = 2;
            this.m_ackMode = 1004;
            this.m_transacted = false;
        } else if (this.m_qos.equals("AT_LEAST_ONCE_FAST")) {
            this.m_deliveryMode = DeliveryMode.NON_PERSISTENT_REPLICATED;
            this.m_ackMode = 1004;
            this.m_transacted = false;
        } else if (this.m_qos.equals("BEST_EFFORT_DISCARDABLE")) {
            this.m_deliveryMode = DeliveryMode.DISCARDABLE;
            this.m_ackMode = 3;
            this.m_transacted = false;
        } else {
            this.m_deliveryMode = 1;
            this.m_ackMode = 3;
            this.m_transacted = false;
        }
    }

    public final String toString() {
        return "JMSEndpointContext[" + this.m_name + ", " + this.m_qos + "," + this.m_entryEndpointConnection + "]";
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getQoS() {
        return this.m_qos;
    }

    @Override
    public XQQualityofService getQualityofService() {
        return XQQualityofService.valueOf((String)this.m_qos);
    }

    @Override
    protected void setEntryEndpoint(Endpoint endpoint) {
        this.m_entryEndpoint = (JMSEndpoint)endpoint;
    }

    @Override
    protected void setMessageListener(String endpointName, IXQMessageListener msgListener) throws Exception {
        JMSEndpoint endpoint = (JMSEndpoint)this.m_endpoints.get(endpointName);
        if (endpoint == null) {
            throw new Exception("Invalid Endpoint Name");
        }
        HashMap<String, Object> subscriptionSpec = new HashMap<String, Object>();
        subscriptionSpec.put("ackMode", this.m_ackMode);
        subscriptionSpec.put("transacted", this.m_transacted);
        subscriptionSpec.put("mfContainerName", this.m_mfContainerName);
        subscriptionSpec.put("mfFailoverIdentity", this.m_mfFailoverIdentity);
        subscriptionSpec.put("serviceName", this.m_serviceName);
        subscriptionSpec.put("serviceAppName", this.m_serviceAppName);
        endpoint.setMessageListener(this.m_name, msgListener, subscriptionSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String endpointName, XQMessage msg) throws Exception {
        JMSEndpoint endpoint = (JMSEndpoint)this.m_endpoints.get(endpointName);
        if (this.m_transacted) {
            endpoint.sendExactlyOnce(this.m_name, this.m_deliveryMode, msg);
        } else {
            MessagingBean bean = endpoint.getConnection().getBusConnection();
            if (bean == null) {
                bean = endpoint.getConnection().getConnection();
            }
            boolean useReceiveSession = false;
            if (msg instanceof XQMessageInternal) {
                Integer boxType = (Integer)((XQMessageInternal)msg).getSidebandProperty("SonicESB.BOX_TYPE");
                boolean bl = useReceiveSession = XQServiceConstants.OUTBOX.equals(boxType) || XQServiceConstants.FAULTBOX.equals(boxType);
            }
            if (useReceiveSession && this.m_entryEndpoint != null && this.m_entryEndpoint.getConnection(this.m_name).getConnection() == bean) {
                endpoint.sendWithUnbound(this.m_name, this.m_deliveryMode, msg);
            } else {
                String sessionName = bean.getSessionFromPool(this.m_qos, endpoint.getSendTimeout());
                if (sessionName == null) {
                    throw new RuntimeException("No session available to deliver the outgoing message.  This may be due to an in progress broker reconnect.");
                }
                try {
                    endpoint.sendWithUnbound(sessionName, this.m_deliveryMode, msg);
                }
                finally {
                    bean.returnSessionToPool(sessionName);
                }
            }
        }
    }

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    protected void addEndpoint(Endpoint endpoint) throws Exception {
        if (!(endpoint instanceof JMSEndpoint)) {
            throw new IllegalArgumentException("Endpoint is not an JMS endpoint.");
        }
        this.m_endpoints.put(endpoint.getName(), endpoint);
    }

    @Override
    protected void removeEndpoints() {
        EndpointManager em = EndpointManager.getInstance();
        Iterator<Endpoint> endpoints = this.m_endpoints.values().iterator();
        try {
            while (endpoints.hasNext()) {
                em.removeEndpointIfTemporary(((JMSEndpoint)endpoints.next()).getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_endpoints.clear();
    }
}

