/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.expressions;

import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.configuration.RoutingExpressionConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingExpressionOperatorConfiguration;
import com.sonicsw.xq.service.xcbr.routingRules.expressions.RoutingExpression;
import java.util.HashMap;

public class RoutingExpressionFactory {
    private static HashMap<String, Class<? extends RoutingExpression>> sCompoundOperators_;
    private static HashMap<String, Class<? extends RoutingExpression>> sDistinctExpressions_;
    private static String[] COMPOUND_OPERATOR_TYPES;
    private static String[] COMPOUND_OPERATOR_CLASSES;
    private static String[] DISTINCT_EXPRESSION_TYPES;
    private static String[] DISTINCT_EXPRESSION_CLASSES;

    public static RoutingExpression create(RoutingExpressionConfiguration argExpressionConfig) throws RoutingRuleException {
        try {
            RoutingExpression returnValue = null;
            if (argExpressionConfig instanceof RoutingExpressionOperatorConfiguration) {
                RoutingExpressionOperatorConfiguration config = (RoutingExpressionOperatorConfiguration)argExpressionConfig;
                returnValue = RoutingExpressionFactory.create(config);
            } else {
                String type = argExpressionConfig.getType();
                Class<? extends RoutingExpression> clazz = sDistinctExpressions_.get(type);
                if (clazz == null) {
                    throw new RoutingRuleException("Cannot create an instance of the Routing Expression type " + type);
                }
                returnValue = clazz.newInstance();
                returnValue.initialize(argExpressionConfig);
            }
            return returnValue;
        }
        catch (Exception e) {
            if (e instanceof RoutingRuleException) {
                throw (RoutingRuleException)e;
            }
            throw new RoutingRuleException(e);
        }
    }

    private static RoutingExpression create(RoutingExpressionOperatorConfiguration argCompoundExpression) throws RoutingRuleException {
        try {
            Class<? extends RoutingExpression> classname = sCompoundOperators_.get(argCompoundExpression.getOperator());
            if (classname == null) {
                throw new RoutingRuleException("Cannot create a Routing Expression for the operator " + argCompoundExpression.getOperator() + " valid values are " + RoutingExpressionFactory.getCompoundOperatorList());
            }
            RoutingExpression returnValue = classname.newInstance();
            returnValue.initialize(argCompoundExpression);
            return returnValue;
        }
        catch (Exception e) {
            if (e instanceof RoutingRuleException) {
                throw (RoutingRuleException)e;
            }
            throw new RoutingRuleException(e);
        }
    }

    private static String getCompoundOperatorList() {
        StringBuilder returnValue = new StringBuilder();
        for (int i = 0; i < COMPOUND_OPERATOR_TYPES.length; ++i) {
            if (i > 0) {
                returnValue.append(",");
            }
            returnValue.append(COMPOUND_OPERATOR_TYPES[i]);
        }
        return returnValue.toString();
    }

    private static synchronized void initCompoundOperators() {
        try {
            HashMap returnValue = new HashMap();
            for (int i = 0; i < COMPOUND_OPERATOR_TYPES.length; ++i) {
                Class<?> clazz = Class.forName(COMPOUND_OPERATOR_CLASSES[i]);
                returnValue.put(COMPOUND_OPERATOR_TYPES[i], clazz);
            }
            sCompoundOperators_ = returnValue;
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static synchronized void initDistinctExpressions() {
        try {
            HashMap returnValue = new HashMap();
            for (int i = 0; i < DISTINCT_EXPRESSION_TYPES.length; ++i) {
                Class<?> clazz = Class.forName(DISTINCT_EXPRESSION_CLASSES[i]);
                returnValue.put(DISTINCT_EXPRESSION_TYPES[i], clazz);
            }
            sDistinctExpressions_ = returnValue;
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
    }

    static {
        COMPOUND_OPERATOR_TYPES = new String[]{"AND", "OR"};
        COMPOUND_OPERATOR_CLASSES = new String[]{"com.sonicsw.xq.service.xcbr.routingRules.expressions.impl.RoutingANDOperatorImpl", "com.sonicsw.xq.service.xcbr.routingRules.expressions.impl.RoutingOROperatorImpl"};
        DISTINCT_EXPRESSION_TYPES = new String[]{"XPath", "NumericProperty", "StringProperty"};
        DISTINCT_EXPRESSION_CLASSES = new String[]{"com.sonicsw.xq.service.xcbr.routingRules.expressions.impl.XPathRoutingExpressionImpl", "com.sonicsw.xq.service.xcbr.routingRules.expressions.impl.NumericRoutingExpressionImpl", "com.sonicsw.xq.service.xcbr.routingRules.expressions.impl.StringParameterRoutingExpressionImpl"};
        RoutingExpressionFactory.initCompoundOperators();
        RoutingExpressionFactory.initDistinctExpressions();
    }
}

