/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointContext;
import com.sonicsw.xqimpl.endpoint.container.jca.JCABaseEndpoint;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAInterimEndpoint;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import com.sonicsw.xqimpl.util.EndpointConstants;
import java.util.HashMap;

public class JCAEndpointContext
extends EndpointContext {
    private String m_name = null;
    private String m_qos = null;
    private HashMap<String, Endpoint> m_endpoints = null;
    private int m_transactionLevel;
    private Integer m_transactionLevelInteger;
    private static final ThreadLocal<Integer> m_qosLocal = new ThreadLocal();

    public JCAEndpointContext(String name, String qos) throws Exception {
        this.m_name = name;
        this.m_qos = qos;
        this.m_endpoints = new HashMap();
        this.m_transactionLevel = EndpointConstants.getQoSAsInt((String)this.m_qos);
        if (this.m_transactionLevel == 2) {
            throw new Exception("EXACTLY_ONCE QoS for a JCA endpoint is not available in this release");
        }
        this.m_transactionLevelInteger = new Integer(this.m_transactionLevel);
    }

    static int getQoSLevel() {
        Integer qos = m_qosLocal.get();
        if (qos == null) {
            return 0;
        }
        return qos;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getQoS() {
        return this.m_qos;
    }

    @Override
    protected void setEntryEndpoint(Endpoint endpoint) {
    }

    @Override
    public XQQualityofService getQualityofService() {
        return XQQualityofService.valueOf((String)this.m_qos);
    }

    @Override
    protected void setMessageListener(String endpointName, IXQMessageListener msgListener) throws Exception {
        Endpoint endpoint = this.m_endpoints.get(endpointName);
        if (endpoint == null) {
            throw new Exception("Invalid Endpoint Name");
        }
        if (!(endpoint instanceof JCAInterimEndpoint)) {
            throw new Exception("XQResourceAdapter must be specified for JCA Endpoints used as entries");
        }
        endpoint.setMessageListener(this.m_name, msgListener, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String endpointName, XQMessage msg) throws Exception {
        JCABaseEndpoint endpoint = (JCABaseEndpoint)this.m_endpoints.get(endpointName);
        if (endpoint == null) {
            throw new Exception("Invalid Endpoint Name");
        }
        try {
            m_qosLocal.set(this.m_transactionLevelInteger);
            endpoint.send(this.m_name, msg);
        }
        finally {
            m_qosLocal.set(null);
        }
    }

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    protected void addEndpoint(Endpoint endpoint) throws Exception {
        JCABaseEndpoint jcaEndpoint = (JCABaseEndpoint)endpoint;
        if (!this.supportsThisQoS(jcaEndpoint)) {
            throw new XQEndpointException("The transaction-support specified in the adapter deployment descriptor is inappropriate for the current QoS setting.");
        }
        this.m_endpoints.put(endpoint.getName(), endpoint);
    }

    private boolean supportsThisQoS(JCABaseEndpoint jcaEndpoint) {
        String support = jcaEndpoint.getConnection().getDeploymentDescriptor().getTransactionSupport();
        switch (this.m_transactionLevel) {
            case 1: 
            case 3: {
                return support.equals("LocalTransaction");
            }
            case 2: {
                return support.equals("XATransaction");
            }
        }
        return true;
    }

    @Override
    protected void removeEndpoints() {
        this.m_endpoints.clear();
    }
}

