/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import java.util.Calendar;
import modelobjects.expr.BinaryExpression;
import modelobjects.expr.Expression;
import modelobjects.expr.PostEvalConverter;
import modelobjects.util.LexerTokenTypes;

class ComparisonExpression
extends BinaryExpression
implements LexerTokenTypes {
    ComparisonExpression(int operator, Expression operand1, Expression operand2) {
        super(operator, operand1, operand2);
    }

    @Override
    protected Object eval1(Object rootObject, PostEvalConverter cvtr, int rule) throws Exception {
        Object a = this.operand1.eval(rootObject, cvtr, rule);
        Object b = this.operand2.eval(rootObject, cvtr, rule);
        if (this.operator == -21 || this.operator == -22) {
            boolean equal = rule == 1 ? a == b : (a == null ? b == null || "".equals(b) : (b == null ? "".equals(a) : a.equals(b)));
            if (this.operator == -21) {
                return ComparisonExpression.asBoolean(equal);
            }
            return ComparisonExpression.asBoolean(!equal);
        }
        if (a instanceof Number && b instanceof Number) {
            double valA = ((Number)a).doubleValue();
            double valB = ((Number)b).doubleValue();
            switch (this.operator) {
                case -23: {
                    return ComparisonExpression.asBoolean(valA < valB);
                }
                case -24: {
                    return ComparisonExpression.asBoolean(valA > valB);
                }
                case -25: {
                    return ComparisonExpression.asBoolean(valA <= valB);
                }
                case -26: {
                    return ComparisonExpression.asBoolean(valA >= valB);
                }
            }
        } else {
            if (rule == 1) {
                throw new RuntimeException("Illegal operands for " + ComparisonExpression.opName(this.operator) + ": " + a + " and " + b);
            }
            if ((a == null || a instanceof String) && (b == null || b instanceof String)) {
                String valA = a == null ? "" : (String)a;
                String valB = b == null ? "" : (String)b;
                int comparison = valA.compareTo(valB);
                switch (this.operator) {
                    case -25: 
                    case -23: {
                        return ComparisonExpression.asBoolean(comparison < 0);
                    }
                    case -26: 
                    case -24: {
                        return ComparisonExpression.asBoolean(comparison > 0);
                    }
                }
            } else if (a instanceof Calendar && b instanceof Calendar) {
                boolean aBeforeB = ((Calendar)a).before(b);
                switch (this.operator) {
                    case -25: 
                    case -23: {
                        return ComparisonExpression.asBoolean(aBeforeB);
                    }
                    case -26: 
                    case -24: {
                        return ComparisonExpression.asBoolean(!aBeforeB);
                    }
                }
            }
        }
        throw new RuntimeException("Illegal operands for " + ComparisonExpression.opName(this.operator) + ": " + a + " and " + b);
    }
}

