/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.def;

import com.sonicsw.esb.itinerary.def.Caching;
import com.sonicsw.esb.itinerary.def.Common;
import com.sonicsw.esb.itinerary.def.Decision;
import com.sonicsw.esb.itinerary.def.ESBProcessXmlResource;
import com.sonicsw.esb.itinerary.def.ESBProcessXmlStreamResource;
import com.sonicsw.esb.itinerary.def.Fanout;
import com.sonicsw.esb.itinerary.def.FaultHandlerSerializer;
import com.sonicsw.esb.itinerary.def.FlowTermination;
import com.sonicsw.esb.itinerary.def.Itinerary;
import com.sonicsw.esb.itinerary.def.MessageMapperSerializer;
import com.sonicsw.esb.itinerary.def.Params;
import com.sonicsw.esb.itinerary.def.Step;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.MappingCapable;
import com.sonicsw.esb.itinerary.model.TransformationStepNode;
import com.sonicsw.esb.process.def.ProcessResource;
import com.sonicsw.esb.process.engine.ProcessEngineActionManager;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.DecisionNode;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.FaultHandler;
import com.sonicsw.esb.process.model.ForkNode;
import com.sonicsw.esb.process.model.MergeNode;
import com.sonicsw.esb.process.model.ProcessModelException;
import com.sonicsw.xqimpl.service.XQContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;

public class XQProcess {
    public static final String PROCESS = "process";
    public static final String NAME = "name";
    public static final String QOS = "qualityOfService";
    public static final String TTL = "timeToLive";
    public static final String EXIT_EP_LIST = "exitEndpoint_list";
    public static final String EXIT_EP = "exitEndpoint";
    public static final String ENDPOINT_REF = "endpoint_ref";
    public static final String FAULT_EP = "faultEndpoint";
    public static final String RME_EP = "rejectEndpoint";
    public static final String ENTRY_REF = "entry_ref";
    public static final String TYPE = "type";
    static final String XML_INPUT_FACTORY_CLASS = "com.ctc.wstx.stax.WstxInputFactory";
    static final String XML_INPUT_FACTORY_MIN_TEXT_SEGMENT = "com.ctc.wstx.minTextSegment";

    public static ESBProcess parse(ProcessResource esbpResource) throws IOException, XMLStreamException {
        ESBProcess process = null;
        ItineraryEngine itinEngine = (ItineraryEngine)XQContainer.getProcessEngine();
        if (esbpResource instanceof ESBProcessXmlResource) {
            Element processRootElem = ((ESBProcessXmlResource)esbpResource).getRootElement();
            process = new ESBProcess(esbpResource.getName(), esbpResource.getLocation());
            process.registerRejectedTokenHandler(itinEngine);
            Itinerary.parse(process, processRootElem);
        } else {
            XMLStreamReader xsr = null;
            if (esbpResource instanceof ESBProcessXmlStreamResource) {
                xsr = ((ESBProcessXmlStreamResource)esbpResource).getXMLStreamReader();
            } else {
                InputStream resourceInput = esbpResource.getInputStream();
                if (resourceInput == null) {
                    throw new ProcessModelException("Error creating process " + esbpResource.getName() + " using STAX");
                }
                XMLInputFactory xif = XMLInputFactory.newInstance();
                if (xif.getClass().getName().equals(XML_INPUT_FACTORY_CLASS)) {
                    xif.setProperty(XML_INPUT_FACTORY_MIN_TEXT_SEGMENT, Integer.MAX_VALUE);
                }
                xsr = xif.createXMLStreamReader(resourceInput);
            }
            process = new ESBProcess(esbpResource.getName(), esbpResource.getLocation());
            process.registerRejectedTokenHandler(itinEngine);
            Itinerary.parse(process, xsr);
        }
        ProcessEngineActionManager actionMgr = itinEngine.getProcessEngineActionManager();
        process.setGlobalOnEntryAction(actionMgr.getActivityNodeEntryActionList());
        process.setGlobalOnExitAction(actionMgr.getActivityNodeExitActionList());
        process.setOnEntryAction(actionMgr.getProcessEntryActionList());
        process.setOnExitAction(actionMgr.getProcessExitActionList());
        return process;
    }

    public static void serialize(boolean includeXQPrefixInRoot, ActivityNode currentNode, Writer writer, boolean isCurrentProcInst, boolean includeCurrentStep) throws IOException {
        if (includeXQPrefixInRoot) {
            writer.append("<xq:itinerary");
            Common.marshallAttribute("xmlns:xq", "http://www.sonicsw.com/sonicxq", writer);
            writer.append(">");
        } else {
            Common.marshallOpenElement("itinerary", writer);
        }
        if (currentNode != null) {
            if (includeCurrentStep && currentNode instanceof EsbNode) {
                XQProcess.marshallActivityNode(currentNode, writer);
            }
            if (currentNode instanceof EsbNode || !isCurrentProcInst) {
                XQProcess.writePendingSteps(currentNode, writer);
            }
        }
        if (includeXQPrefixInRoot) {
            Common.marshallCloseElement("xq:itinerary", writer);
        } else {
            Common.marshallCloseElement("itinerary", writer);
        }
        if (isCurrentProcInst && currentNode != null && currentNode instanceof EsbNode) {
            Params.serialize(((EsbNode)currentNode).getXQParameters(), writer);
            MessageMapper msgMapper = null;
            if (currentNode instanceof MappingCapable && (msgMapper = ((MappingCapable)((Object)currentNode)).getMessageMapper()) != null) {
                MessageMapperSerializer.marshall(msgMapper, writer);
            }
            FaultHandler fh = null;
            if (currentNode instanceof ExecutableNode && (fh = ((ExecutableNode)currentNode).getScope().getFaultHandlers()) != null) {
                FaultHandlerSerializer.marshallFHStep(fh, writer, true);
            }
            if (currentNode instanceof EsbStepNode) {
                Caching.serialize((EsbStepNode)currentNode, writer);
            }
        }
    }

    static void writePendingSteps(ActivityNode startNode, Writer writer) throws IOException {
        ActivityNode currentNode = startNode;
        while (currentNode != null && !(currentNode instanceof FlowTerminationNode)) {
            ActivityEdge edge = currentNode.getOutgoingEdges()[0];
            currentNode = edge.getDestination();
            currentNode = XQProcess.marshallActivityNode(currentNode, writer);
        }
    }

    static ActivityNode marshallActivityNode(ActivityNode node, Writer writer) throws IOException {
        if (!(node instanceof FlowTerminationNode) || !FlowTermination.serialize(node, writer)) {
            if (node instanceof TransformationStepNode) {
                Step.serializeTransformStep((TransformationStepNode)node, writer);
            } else if (node instanceof EsbNode) {
                Step.serialize((EsbNode)node, writer);
            } else if (!(node instanceof MergeNode)) {
                if (node instanceof ForkNode) {
                    return Fanout.serialize((ForkNode)node, writer);
                }
                if (node instanceof DecisionNode) {
                    return Decision.serialize((DecisionNode)node, writer);
                }
            }
        }
        return node;
    }
}

