/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr;

import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQParameterInfo;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xq.service.xcbr.configuration.CBRConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.CBRConfigurationFactory;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.context.impl.InvocationContextImpl;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingContext;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingContextFactory;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingRules;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingRulesFactory;

public class XCBRService
implements XQService {
    private String initPartId_;
    private String initRules_;
    private String initRulesURL_;
    private int defaultTracingLevel_ = 0;
    private boolean defaultDisableRouting_ = false;
    private boolean defaultUseCachedRules_ = true;

    public void init(XQInitContext argInitialContext) throws XQServiceException {
        this.setInitialContext(argInitialContext);
    }

    private void setInitialContext(XQInitContext argContext) throws XQServiceException {
        String url;
        if (argContext == null) {
            throw new XQServiceException("The initial context cannot be set to null");
        }
        XQParameters initParams = argContext.getParameters();
        this.setInitPartId(initParams.getParameter("xcbrRuleInfoPartId", 1));
        XQParameterInfo paramInfo = initParams.getInfo("ruleInfo", 2);
        if (paramInfo != null && (url = paramInfo.getRef()) != null && !"".equals(url) && !url.endsWith(".cbr")) {
            this.initRulesURL_ = url;
            this.setInitRules(initParams.getParameter("ruleInfo", 2));
        }
    }

    public void setInitPartId(String partId) {
        if (partId != null && !"".equals(partId)) {
            this.initPartId_ = partId;
        }
    }

    public void setInitRules(String rules) {
        this.initRules_ = rules;
    }

    public void setDefaultTracingLevel(int i) {
        this.defaultTracingLevel_ = i;
    }

    public void setDefaultDisableRouting(boolean d) {
        this.defaultDisableRouting_ = d;
    }

    public void setDefaultUseCachedRules(boolean u) {
        this.defaultUseCachedRules_ = u;
    }

    public void destroy() {
    }

    public boolean isXCBR(XQServiceContext ctx) {
        String url;
        XQParameters runtimeParams = ctx.getParameters();
        XQParameterInfo paramInfo = runtimeParams.getInfo("ruleInfo", 2);
        if (paramInfo != null && (url = paramInfo.getRef()) != null && !"".equals(url)) {
            return !url.endsWith(".cbr");
        }
        return this.initPartId_ != null || this.initRulesURL_ != null;
    }

    public void service(XQServiceContext argContext) throws XQServiceException {
        try {
            if (argContext.hasNextIncoming()) {
                XQEnvelope incoming = argContext.getNextIncoming();
                InvocationContextImpl context = new InvocationContextImpl(null);
                context.initialize(argContext, incoming);
                this.service(context);
                context.endServiceCall();
            }
        }
        catch (XQServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    public void service(InvocationContext argContext) throws XQServiceException {
        try {
            int tracingLevel = this.defaultTracingLevel_;
            boolean disableRouting = this.defaultDisableRouting_;
            String content = null;
            boolean useCachedRules = this.defaultUseCachedRules_;
            XQServiceContext context = argContext.getServiceContext();
            XQParameters params = context.getParameters();
            if (argContext.getProcessContext() != null) {
                XQParameterInfo ruleInfo;
                if (params.containsParameter("xcbrTracingLevel", 1)) {
                    tracingLevel = params.getIntParameter("xcbrTracingLevel", 1);
                }
                if (params.containsParameter("xcbrDisableRouting", 1)) {
                    disableRouting = params.getBooleanParameter("xcbrDisableRouting", 1);
                }
                if (params.containsParameter("ruleInfo", 2) && (ruleInfo = params.getInfo("ruleInfo", 2)) != null) {
                    String url = ruleInfo.getRef();
                    content = params.getParameter("ruleInfo", 2);
                    this.checkRules(content, url);
                }
            }
            if (content == null && this.initRulesURL_ != null) {
                this.checkRules(this.initRules_, this.initRulesURL_);
                content = this.initRules_;
            }
            if (content == null && this.initPartId_ != null) {
                if (argContext.isPartPresent(this.initPartId_)) {
                    content = argContext.getMessagePartAsString(this.initPartId_);
                    if (!disableRouting) {
                        argContext.getNextIncoming().getMessage().removePart(this.initPartId_);
                    }
                    useCachedRules = false;
                } else {
                    throw new XQServiceException("XCBR rules message part not found: " + this.initPartId_);
                }
            }
            if (content == null) {
                throw new XQServiceException("XCBR rules not specified");
            }
            RoutingRules routingRules = null;
            if (useCachedRules) {
                routingRules = RoutingRulesFactory.getRoutingRulesFromCache(content);
            } else {
                CBRConfiguration config = CBRConfigurationFactory.create(content);
                routingRules = RoutingRulesFactory.create(config);
            }
            argContext.getNextIncoming().clearAddresses();
            RoutingContext routingContext = RoutingContextFactory.create();
            routingContext.setTracingLevel(tracingLevel);
            routingContext.setRoutingDisabled(disableRouting);
            routingRules.route(argContext, routingContext);
            if (!disableRouting) {
                argContext.addIncomingToOutbox();
            }
            if (tracingLevel > 0) {
                routingContext.sendTraceMessage(argContext);
            }
        }
        catch (XQServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    private void checkRules(String initRules_, String initRulesURL_) throws XQServiceException {
        if (initRules_ == null) {
            throw new XQServiceException("XCBR rules URL could not be resolved: " + initRulesURL_);
        }
    }
}

