/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.routingList.impl;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.BaseRoutingEndpointImpl;

public class ESBEndpointByPropertyNameImpl
extends BaseRoutingEndpointImpl {
    public ESBEndpointByPropertyNameImpl(String argName) throws RoutingRuleException {
        super(argName);
    }

    @Override
    public String getRoutingType() {
        return "ESBEndpoint";
    }

    @Override
    public void route(InvocationContext argMessage) throws RoutingRuleException {
        super.route(argMessage);
        try {
            String destinationName = argMessage.getNextIncoming().getMessage().getStringHeader(this.getName());
            if (destinationName == null) {
                throw new RoutingRuleException("The message property " + this.getName() + " must specify a valid value");
            }
            if (destinationName.length() == 0) {
                throw new RoutingRuleException("The message property " + this.getName() + " must specify a valid value");
            }
            if (this.isDefaultOutbox(destinationName)) {
                argMessage.addDefaultAddressesToIncoming();
            } else {
                XQAddress outgoingAddress = this.getOutgoingAddress(argMessage, destinationName);
                argMessage.addAddressToIncoming(outgoingAddress);
            }
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    private XQAddress getOutgoingAddress(InvocationContext argMessage, String argDestinationName) throws RoutingRuleException {
        try {
            XQAddress returnValue = null;
            returnValue = this.isReplyTo(argDestinationName) ? argMessage.getAddressFactory().getReplyToAddress() : argMessage.getAddressFactory().createEndpointAddress(argDestinationName);
            return returnValue;
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    private boolean isReplyTo(String argName) throws RoutingRuleException {
        return argName.compareToIgnoreCase("replyto") == 0 || argName.compareToIgnoreCase("reply_to") == 0;
    }

    private boolean isDefaultOutbox(String argName) throws RoutingRuleException {
        return argName.compareToIgnoreCase("outbox") == 0 || argName.compareToIgnoreCase("default") == 0 || argName.compareToIgnoreCase("exit") == 0;
    }
}

