/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.esb.ws.invocation.ESBWSCommand;
import com.sonicsw.esb.ws.invocation.ESBWSParameter;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.HRefUtils;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.SoapParameters;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SoapBodyFactory {
    public static SOAPEnvelope createSOAPEnvelope(MessageContext msgContext, List bodies) {
        SOAPEnvelope env;
        if (bodies.isEmpty()) {
            env = new SOAPEnvelope();
        } else {
            Object[] params = bodies.toArray();
            env = new SOAPEnvelope(msgContext.getSOAPConstants(), msgContext.getSchemaVersion());
            for (int i = 0; i < params.length; ++i) {
                env.addBodyElement((SOAPBodyElement)params[i]);
            }
        }
        return env;
    }

    public static SOAPEnvelope createSOAPEnvelope(String xml) throws GeneralWSInvocationException {
        try {
            SOAPEnvelope env = new SOAPEnvelope((InputStream)new ByteArrayInputStream(xml.getBytes()));
            return env;
        }
        catch (SAXException e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    public static List createDocLitBody(ESBWSCommand scriptCommand, SoapParameters soapParameters) throws GeneralWSInvocationException {
        try {
            Document doc = DOMUtils.createDocument();
            List inputValues = SoapBodyFactory.getInputMessageValues(scriptCommand);
            ArrayList<SOAPBodyElement> soapBodies = new ArrayList<SOAPBodyElement>();
            for (IParameterValue paramValue : inputValues) {
                if (paramValue.isDiscard() || !paramValue.isXML()) continue;
                Element el = soapParameters.createElementFromComplexDoc(paramValue.getParamName(), paramValue.getAsElement(), doc);
                soapBodies.add(new SOAPBodyElement(el));
            }
            return soapBodies;
        }
        catch (ScriptEngineException e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    public static List createFaultBody(ESBWSCommand scriptCommand, SoapParameters soapParams) throws GeneralWSInvocationException {
        try {
            String value;
            Document doc = DOMUtils.createDocument();
            Element el = HRefUtils.CreateRPCWrapper(doc, "http://schemas.xmlsoap.org/soap/envelope/", "Fault", scriptCommand.getSOAPInfo().getInputEncodingStyle());
            List inputValues = SoapBodyFactory.getInputMessageValues(scriptCommand);
            ArrayList<SOAPBodyElement> soapBodies = new ArrayList<SOAPBodyElement>();
            Iterator iter = inputValues.iterator();
            while (iter.hasNext()) {
                IParameterValue paramValue = (IParameterValue)iter.next();
                String parameterName = paramValue.getParamName();
                if (!parameterName.equals("faultcode") && !parameterName.equals("faultactor") && !parameterName.equals("faultstring")) continue;
                value = paramValue.getAsString();
                Element parameterElement = soapParams.createElementFromSimple(parameterName, value, true, doc);
                el.appendChild(parameterElement);
                iter.remove();
            }
            Element detailElem = doc.createElement("detail");
            for (IParameterValue paramValue : inputValues) {
                if (paramValue.isDiscard()) continue;
                if (paramValue.isXML()) {
                    Node valueNode = doc.importNode(paramValue.getAsElement(), true);
                    detailElem.appendChild(valueNode);
                    continue;
                }
                value = paramValue.getAsString();
                Text textNode = doc.createTextNode(value);
                detailElem.appendChild(textNode);
            }
            el.appendChild(detailElem);
            soapBodies.add(new SOAPBodyElement(el));
            return soapBodies;
        }
        catch (ScriptEngineException e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    public static List createRPCBody(ESBWSCommand scriptCommand, SoapParameters soapParameters) throws GeneralWSInvocationException {
        try {
            String opName = scriptCommand.getOperationName();
            if (scriptCommand.getCommandType() == 1) {
                opName = opName + "Response";
            } else if (scriptCommand.getCommandType() == 3) {
                opName = opName + "Unwrap";
            }
            Document doc = DOMUtils.createDocument();
            Element el = HRefUtils.CreateRPCWrapper(doc, scriptCommand.getSOAPInfo().getInputNamespace(), opName, scriptCommand.getSOAPInfo().getInputEncodingStyle());
            List inputValues = SoapBodyFactory.getInputMessageValues(scriptCommand);
            ArrayList<SOAPBodyElement> soapBodies = new ArrayList<SOAPBodyElement>();
            for (IParameterValue paramValue : inputValues) {
                String parameterName;
                if (paramValue.isDiscard()) continue;
                if (paramValue.isXML()) {
                    if (HRefUtils.isMultiRef(paramValue.getAsElement())) {
                        soapBodies.add(new SOAPBodyElement(paramValue.getAsElement()));
                        continue;
                    }
                    parameterName = paramValue.getParamName();
                    Element parameterElement = soapParameters.createElementFromComplexParam(parameterName, paramValue.getAsElement(), doc);
                    el.appendChild(parameterElement);
                    continue;
                }
                if (paramValue != null) {
                    String value;
                    parameterName = paramValue.getParamName();
                    Element parameterElement = soapParameters.createElementFromSimple(parameterName, value = paramValue.getAsString(), true, doc);
                    if (parameterElement == null) {
                        throw new GeneralWSInvocationException("parameter-name-not-defined-in-wsdl", new Object[]{parameterName});
                    }
                    el.appendChild(parameterElement);
                    continue;
                }
                throw new GeneralWSInvocationException("unexpected-input-type", new Object[]{paramValue});
            }
            soapBodies.add(new SOAPBodyElement(el));
            return soapBodies;
        }
        catch (ScriptEngineException e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    private static List getInputMessageValues(ESBWSCommand scriptCommand) {
        ArrayList<IParameterValue> axisInputs = new ArrayList<IParameterValue>();
        List params = scriptCommand.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            ESBWSParameter param = (ESBWSParameter)params.get(i);
            if (param.getParameterDirection().equals("OUT") || param.isSoapHeader()) continue;
            axisInputs.add(param.getParameterValue());
        }
        return axisInputs;
    }
}

