/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.esb.ws.invocation.ESBWSException;
import com.sonicsw.esb.ws.invocation.ESBWSGenerator;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import com.sonicsw.xqimpl.script.wsdl.TypeHelper;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelper;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Stack;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WSDLSkeletonCreator {
    private TypeHelper m_typeHelper;
    private WSDLHelper m_wsdlHelper;
    private static final String s_xsiNamespace = "http://www.w3.org/2001/XMLSchema-instance/";
    private static final String s_xmlNsNamespace = "http://www.w3.org/2000/xmlns/";
    private static final String s_xmlSoapNamespace = "http://schemas.xmlsoap.org/soap/encoding/";
    private IndexedStack m_stack = new IndexedStack();

    public WSDLSkeletonCreator(WSDLHelper wsdlHelper, TypeHelper typeHelper) {
        this.m_wsdlHelper = wsdlHelper;
        this.m_typeHelper = typeHelper;
    }

    private Element createSkeletonXML(QName elementName, QName typeName, boolean includeTemplates) throws WSDLHelperException {
        Document parentDocument = DOMUtils.createDocument();
        SchemaType t = this.m_typeHelper.getType(typeName);
        return (Element)this.createNode(elementName, t, parentDocument, includeTemplates);
    }

    public static Element createSkeletonXML(ESBWSGenerator generator, String prefixedType, QName elementName, boolean includeTemplates) throws ESBWSException {
        if (!(generator instanceof WSDLHelper)) {
            throw new IllegalArgumentException("Generator is not an instance of WSDLHelper");
        }
        WSDLHelper helper = (WSDLHelper)generator;
        Definition def = helper.getDefinition();
        TypeHelper typeHelper = (TypeHelper)helper.getTypeLibrary();
        String typePrefix = XMLTypeUtils.getTypePrefix(prefixedType);
        String typeLocalName = XMLTypeUtils.getTypeName(prefixedType);
        String typeNamespace = def.getNamespace(typePrefix);
        QName typeQname = new QName(typeNamespace, typeLocalName);
        if (typeHelper.isSimpleType(typeQname)) {
            throw new WSDLHelperException("no-simple-skeleton", null);
        }
        WSDLSkeletonCreator skeletonCreator = new WSDLSkeletonCreator(helper, typeHelper);
        return skeletonCreator.createSkeletonXML(elementName, typeQname, includeTemplates);
    }

    private Node createNode(QName elementName, SchemaType type, Document parentDocument, boolean includeTemplates) {
        if (type != null) {
            if (type.isSimpleType()) {
                return this.createSimple(elementName, type, parentDocument, includeTemplates);
            }
            return this.createComplex(elementName, type, parentDocument, includeTemplates);
        }
        return null;
    }

    private Node createSimple(QName pname, SchemaType t, Document parentDocument, boolean includeTemplates) {
        String elementNamespace = pname.getNamespaceURI();
        Element e = null;
        if (elementNamespace != null && !"".equals(elementNamespace)) {
            String prefix = this.m_wsdlHelper.getPrefixForURI(elementNamespace);
            e = parentDocument.createElementNS(elementNamespace, prefix + ":" + pname.getLocalPart());
        } else {
            e = parentDocument.createElementNS("", pname.getLocalPart());
        }
        QName typeName = t.getName();
        String prefix = this.m_wsdlHelper.getPrefixForURI(typeName.getNamespaceURI());
        WSDLSkeletonCreator.configNsAttributes(e, prefix, typeName);
        SchemaProperty[] attributes = t.getAttributeProperties();
        this.addAttributesToNode(e, attributes, parentDocument, includeTemplates);
        Text textNode = null;
        textNode = includeTemplates ? parentDocument.createTextNode("%Insert text here, DT: " + t.getName() + "%") : parentDocument.createTextNode("DUMMY");
        e.appendChild(textNode);
        return e;
    }

    private void addAttributesToNode(Node n, SchemaProperty[] attributes, Document parentDocument, boolean includeTemplates) {
        if (attributes != null && n != null) {
            for (int count = 0; count < attributes.length; ++count) {
                QName name = attributes[count].getName();
                String namespace = name.getNamespaceURI();
                String prefix = null;
                if (namespace != null && !"".equals(namespace)) {
                    prefix = this.m_wsdlHelper.getPrefixForURI(namespace);
                }
                if (namespace != null && namespace.equals(s_xmlSoapNamespace)) {
                    if ("arrayType".equals(name.getLocalPart())) {
                        if (prefix == null) {
                            prefix = "wsinvk-soap-enc";
                        }
                        Element e = (Element)n;
                        e.setAttributeNS(s_xmlNsNamespace, "xmlns:" + prefix, s_xmlSoapNamespace);
                        if (includeTemplates) {
                            e.setAttributeNS(s_xmlSoapNamespace, prefix + ":arrayType", "%type%[%size%]");
                            continue;
                        }
                        e.setAttributeNS(s_xmlSoapNamespace, prefix + ":arrayType", "DUMMY");
                        continue;
                    }
                    this.addAttributeComment(n, attributes[count], parentDocument, prefix);
                    continue;
                }
                this.addAttributeComment(n, attributes[count], parentDocument, prefix);
            }
        }
    }

    private void addAttributeComment(Node n, SchemaProperty attribute, Document parentDocument, String prefix) {
        QName name = attribute.getName();
        BigInteger minOccurs = attribute.getMinOccurs();
        BigInteger maxOccurs = attribute.getMaxOccurs();
        String comment = null;
        comment = prefix == null || "".equals(prefix) ? "%Attribute- " + name.getLocalPart() + "=%fill in value% " : "%Attribute- " + prefix + ":" + name.getLocalPart() + "=%fill in value% ";
        comment = comment + " minOccurs: " + minOccurs + " maxOccurs: " + maxOccurs + " %";
        Comment commentNode = parentDocument.createComment(comment);
        n.appendChild(commentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node createComplex(QName elementName, SchemaType t, Document parentDocument, boolean includeTemplates) {
        boolean wasPushed = false;
        SchemaParticle particle = t.getContentModel();
        SchemaProperty[] elements = t.getElementProperties();
        SchemaProperty[] attributes = t.getAttributeProperties();
        Element e = null;
        try {
            String prefix;
            if (elementName != null) {
                String elementNamespace = elementName.getNamespaceURI();
                if (elementNamespace != null && !"".equals(elementNamespace)) {
                    prefix = this.m_wsdlHelper.getPrefixForURI(elementNamespace);
                    e = parentDocument.createElementNS(elementNamespace, prefix + ":" + elementName.getLocalPart());
                    e.setAttributeNS(s_xmlNsNamespace, "xmlns:" + prefix, elementNamespace);
                } else {
                    e = parentDocument.createElementNS("", elementName.getLocalPart());
                }
            }
            QName typeName = null;
            typeName = t.getName();
            if (typeName == null && particle != null) {
                typeName = particle.getName();
            }
            prefix = null;
            if (typeName != null) {
                prefix = this.m_wsdlHelper.getPrefixForURI(typeName.getNamespaceURI());
                if (e != null) {
                    WSDLSkeletonCreator.configNsAttributes(e, prefix, typeName);
                }
                this.addAttributesToNode(e, attributes, parentDocument, includeTemplates);
                if (this.m_stack.contains(t)) {
                    Element element = e;
                    return element;
                }
                this.m_stack.push(t);
                wasPushed = true;
            }
            if (particle == null) return e;
            switch (particle.getParticleType()) {
                case 2: {
                    int count = 0;
                    while (count < elements.length) {
                        QName childElementName = elements[count].getName();
                        SchemaType type = elements[count].getType();
                        Node n = this.createNode(childElementName, type, parentDocument, includeTemplates);
                        if (e != null) {
                            Comment comment = parentDocument.createComment("%CHOICE%");
                            e.appendChild(comment);
                            e.appendChild(n);
                        } else {
                            e = (Element)n;
                        }
                        ++count;
                    }
                    return e;
                }
                case 1: 
                case 3: {
                    int count = 0;
                    while (count < elements.length) {
                        QName childElementName = elements[count].getName();
                        SchemaType type = elements[count].getType();
                        Node n = this.createNode(childElementName, type, parentDocument, includeTemplates);
                        e = WSDLSkeletonCreator.retrieveE(e, n);
                        ++count;
                    }
                    return e;
                }
                case 4: {
                    QName childElementName = elements[0].getName();
                    SchemaType type = elements[0].getType();
                    Node n = this.createNode(childElementName, type, parentDocument, includeTemplates);
                    e = WSDLSkeletonCreator.retrieveE(e, n);
                    return e;
                }
            }
            return e;
        }
        finally {
            if (wasPushed) {
                this.m_stack.pop();
            }
        }
    }

    private static Element retrieveE(Element eParam, Node n) {
        Element e = eParam;
        if (e != null) {
            e.appendChild(n);
        } else {
            e = (Element)n;
        }
        return e;
    }

    private static void configNsAttributes(Element e, String prefix, QName typeName) {
        e.setAttributeNS(s_xsiNamespace, "xsi:type", prefix + ":" + typeName.getLocalPart());
        e.setAttributeNS(s_xmlNsNamespace, "xmlns:" + prefix, typeName.getNamespaceURI());
        e.setAttributeNS(s_xmlNsNamespace, "xmlns:xsi", s_xsiNamespace);
    }

    static class IndexedStack {
        Object EMPTY = new Object();
        private Stack m_stack = new Stack();
        private HashSet m_set = new HashSet();

        IndexedStack() {
        }

        public void push(Object obj) {
            this.m_stack.push(obj);
            this.m_set.add(obj);
        }

        public Object pop() {
            Object result = this.m_stack.pop();
            this.m_set.remove(result);
            return result;
        }

        public boolean contains(Object obj) {
            return this.m_set.contains(obj);
        }
    }
}

