/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.client.impl.interior;

import com.sonicsw.esb.client.Exchange;
import com.sonicsw.esb.client.ExchangePattern;
import com.sonicsw.esb.client.impl.ExchangeImpl;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.envelope.XQMessageImpl;

public class ColocExchangeImpl
extends ExchangeImpl
implements Exchange {
    private String m_savedCorrId = null;
    private XQAddress m_savedReplyToAddr = null;
    private IEndpointRegistry m_savedEndpointRegistry = null;
    private IEndpointRegistry m_serviceEndpointRegistry = null;

    public ColocExchangeImpl(ExchangePattern pattern) {
        super(pattern);
    }

    @Override
    public void setInput(XQMessage in) {
        super.setInput(in);
        this.saveCallerContext(in);
    }

    @Override
    public void setInputAsAddressedEnvelope(XQEnvelope in) {
        super.setInputAsAddressedEnvelope(in);
        this.saveCallerContext(in);
    }

    private void saveCallerContext(XQMessage msg) {
        try {
            this.m_savedReplyToAddr = msg.getReplyTo();
            this.m_savedCorrId = msg.getCorrelationId();
            this.m_savedEndpointRegistry = ((XQMessageImpl)msg).getEndpointRegistry();
        }
        catch (XQMessageException xQMessageException) {
            // empty catch block
        }
    }

    void setServiceEndpointRegistry(IEndpointRegistry serviceEndpointRegistry) {
        this.m_serviceEndpointRegistry = serviceEndpointRegistry;
    }

    void saveCallerContext(XQEnvelope env) {
        if (env == null) {
            return;
        }
        this.saveCallerContext(env.getMessage());
    }

    void applyCallerContext(XQMessage msg) {
        if (msg == null) {
            return;
        }
        if (this.m_savedEndpointRegistry != null) {
            ((XQMessageImpl)msg).setEndpointRegistry(this.m_savedEndpointRegistry);
        }
        try {
            msg.setReplyTo(this.m_savedReplyToAddr);
            msg.setCorrelationId(this.m_savedCorrId);
        }
        catch (XQMessageException xQMessageException) {
            // empty catch block
        }
    }
}

