/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.ExpressionException;
import com.sonicsw.esb.expression.el.ExpressionActionExecutor;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;

public class ELExpression
implements Expression {
    private ValueExpression target;

    ELExpression(ValueExpression target) {
        this.target = target;
    }

    @Override
    public Object getValue(ExpressionContext context) {
        ExpressionActionExecutor.setThreadLocalELContext(context);
        try {
            Object object = this.target.getValue((ELContext)context);
            return object;
        }
        catch (ELException excp) {
            throw new ExpressionException("Failed to evaluate expression: " + this.target.getExpressionString(), excp);
        }
        finally {
            ExpressionActionExecutor.setThreadLocalELContext(null);
        }
    }

    @Override
    public boolean isReadOnly(ExpressionContext context) {
        ExpressionActionExecutor.setThreadLocalELContext(context);
        try {
            boolean bl = this.target.isReadOnly((ELContext)context);
            return bl;
        }
        catch (ELException excp) {
            throw new ExpressionException("Failed to evaluate expression: " + this.target.getExpressionString(), excp);
        }
        finally {
            ExpressionActionExecutor.setThreadLocalELContext(null);
        }
    }

    @Override
    public void setValue(ExpressionContext context, Object value) {
        ExpressionActionExecutor.setThreadLocalELContext(context);
        try {
            this.target.setValue((ELContext)context, value);
        }
        catch (ELException excp) {
            throw new ExpressionException("Failed to evaluate and set expression: '" + this.target.getExpressionString() + "'", excp);
        }
        finally {
            ExpressionActionExecutor.setThreadLocalELContext(null);
        }
    }

    public String toString() {
        return this.target.getExpressionString();
    }
}

