/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.mapping.DefaultMessageMapper;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.RunDebugUtil;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Scope;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultFinalNode;
import com.sonicsw.esb.process.model.impl.DefaultScope;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.service.MessageSendingHelper;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ItineraryEndNode
extends DefaultFinalNode
implements EsbNode,
FlowTerminationNode {
    protected MessageMapper m_messageMapper;
    private boolean m_isImplicit;
    private XQAddress m_endpointRef;
    private Scope m_scope;
    protected XQParameters m_stepParams;

    public ItineraryEndNode(ActivityGroup parent) {
        super("finalNode", parent);
        this.m_isImplicit = true;
        this.m_scope = new DefaultScope("finalNode");
    }

    public ItineraryEndNode(String id, String stepName, ActivityGroup parent) {
        super(id, parent);
        this.m_endpointRef = new XQAbstractAddressImpl("InternalStep.Exit", 1, stepName);
        this.m_scope = new DefaultScope(id);
    }

    @Override
    public Token execute(Token token) {
        Token resultToken = null;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        try {
            if (!(this.m_isImplicit || token.isTokenOfType(Token.Type.RME, false) || token.isTokenOfType(Token.Type.FAULT, false))) {
                boolean result;
                if (XQContainer.isTestContainer() && !mex.isExchangeImmediate() && (result = RunDebugUtil.execute(mex, token, this))) {
                    XQMessageInternal msgInternal = (XQMessageInternal)((EsbMessageExchange)token.getData()).getInputMessage();
                    return (Token)msgInternal.getSidebandProperty("TOKEN");
                }
                if (this.m_messageMapper != null) {
                    DefaultMessageMapper.mapInputMessage(this.m_messageMapper, mex);
                }
            }
            ItineraryEndNode.dispatchMessage(token);
            resultToken = super.execute(token);
        }
        catch (Throwable e) {
            EsbStepNode.handleException(e, this, token, mex);
        }
        return resultToken;
    }

    static void dispatchMessage(Token token) throws Throwable {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (!procInst.isSubProcess() && !token.isTokenOfType(Token.Type.NULL, false)) {
            if (procInst instanceof FaultProcessInstance) {
                EsbMessageExchange mex = (EsbMessageExchange)token.getData();
                if (mex.isResponseToReplyTo()) {
                    try {
                        if (mex.getInputMessage().getReplyTo() == null) {
                            mex.getInputMessage().setReplyTo(mex.getDestinationAddress());
                        }
                    }
                    catch (XQMessageException xQMessageException) {}
                }
            } else {
                ItineraryEndNode.dispatchMessageToExitorRME(token, procInst);
            }
        }
    }

    static void dispatchMessageToExitorRME(Token token, XQProcessInstance procInst) throws Throwable {
        if (token instanceof CompositeToken) {
            List<Token> tokens = ((CompositeToken)token).getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                ItineraryEndNode.dispatchMessageToExitorRME(tokens.get(i), procInst);
            }
        } else if (token.isTokenOfType(Token.Type.RME, true)) {
            ((ItineraryEngine)XQContainer.getProcessEngine()).sendToRME(procInst.getProcessDefinition().getProcessName(), token);
        } else {
            EsbMessageExchange mex = (EsbMessageExchange)token.getData();
            mex.setInProcess(false);
            if (mex.getDestinationAddress() == null) {
                if (s_debugLogEnabled) {
                    s_log.logDebug("Destination address is null. No exit endpoints might be defined for the process");
                }
            } else {
                MessageSendingHelper.sendToAddress(mex, "");
            }
        }
    }

    @Override
    public void offerOutgoing(Token token) {
        this.deactivate(token);
        if (token.isTokenOfType(Token.Type.NULL, false)) {
            return;
        }
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst.isSubProcess()) {
            ItineraryEndNode.sendToParentProcess(token, procInst);
        } else if (procInst instanceof FaultProcessInstance) {
            this.handleFaultHandlerCompletion(token, (FaultProcessInstance)procInst);
        }
    }

    private void handleFaultHandlerCompletion(Token token, FaultProcessInstance fhProcInst) {
        XQProcessInstance origProcInst = fhProcInst.getOriginalProcessInstance();
        ProcessInstanceProps origProcInstProps = fhProcInst.getOriginalProcessInstanceProps();
        boolean isFHTargetProcess = origProcInstProps.isFaultHandlerTargetProcessNode();
        origProcInstProps.setInflightProperties(fhProcInst.getProcessInstanceProperties().getInflightProps());
        token.setProcessInstance(origProcInst);
        if (token.isTokenOfType(Token.Type.RME, false) || token.isTokenOfType(Token.Type.FAULT, false)) {
            this.handleOutOfBandToken(token);
        } else {
            Token newToken;
            EsbMessageExchange mex = (EsbMessageExchange)token.getData();
            ActivityNode activeNode = null;
            RMEMessage rmeMsg = fhProcInst.getOriginalRMEMsg();
            if (rmeMsg != null) {
                rmeMsg.removeHeaders(mex.getInputMessage());
            } else {
                fhProcInst.removeFaultHeaders(mex.getInputMessage());
            }
            Set<Object> nextAddresses = new HashSet<XQAddress>();
            if (isFHTargetProcess) {
                ESBProcess process = (ESBProcess)origProcInst.getProcessDefinition();
                activeNode = process.getEndNode();
                origProcInst.populateExitEndpoints(nextAddresses, token);
            } else {
                activeNode = origProcInst.getActiveEsbNode(token);
                if (activeNode instanceof EsbStepNode) {
                    nextAddresses = ((EsbStepNode)activeNode).getNextAddresses();
                }
                if (nextAddresses == null) {
                    nextAddresses = new HashSet();
                    origProcInst.computeNextAddresses(activeNode, nextAddresses, token);
                }
            }
            int nAddr = nextAddresses.size();
            if (nAddr == 0) {
                return;
            }
            if (nAddr == 1) {
                newToken = token.changeOwnership(activeNode, false);
                EsbMessageExchange newMex = (EsbMessageExchange)mex.clone();
                newMex.setDestinationAddress((XQAddress)nextAddresses.iterator().next());
                newToken.setData(newMex);
            } else {
                newToken = CompositeToken.createCompositeToken(activeNode, token, mex, nextAddresses);
            }
            if (isFHTargetProcess) {
                activeNode.offerIncoming(newToken);
            } else {
                XQContainer.getProcessEngine().enqueueToken(newToken);
            }
        }
    }

    static void sendToParentProcess(Token token, XQProcessInstance procInst) {
        ActivityNode parentNode = procInst.unwind(token, 1);
        token.tagType(Token.Type.C10N);
        parentNode.offerIncoming(token);
    }

    @Override
    public boolean activate(Token token) {
        XQParameters params = ((EsbMessageExchange)token.getData()).getXQParameters();
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (!this.m_isImplicit) {
            params.setParameter("SonicXQ.ProcessStep", 1, procInst.getCompleteStepName(this.m_displayName));
            params.setParameter("SonicXQ.ProcessName", 1, procInst.getProcessDefinition().getDisplayName());
        }
        params.setParameter("SonicXQ.ProcessName", 1, procInst.getProcessDefinition().getDisplayName());
        this.executeActionList(this.m_onEntry, this.m_process.getGlobalOnEntryAction(), token);
        if (this.m_process.getOnExitAction() != null) {
            this.executeActionList(null, this.m_process.getOnExitAction(), token);
        }
        return super.activate(token);
    }

    @Override
    public boolean deactivate(Token token) {
        this.executeActionList(this.m_onExit, this.m_process.getGlobalOnExitAction(), token);
        return super.deactivate(token);
    }

    @Override
    public void setMessageMapper(MessageMapper msgMapper) {
        this.m_messageMapper = msgMapper;
    }

    @Override
    public MessageMapper getMessageMapper() {
        return this.m_messageMapper;
    }

    public boolean isImplicit() {
        return this.m_isImplicit;
    }

    public XQAddress getEndpointRef() {
        return this.m_endpointRef;
    }

    @Override
    public XQAddress getEndpointRef(Token token) {
        return this.m_endpointRef;
    }

    @Override
    public XQParameters getXQParameters() {
        return this.m_stepParams;
    }

    @Override
    public void setEndpointRef(XQAddress endpointRef) {
        this.m_endpointRef = endpointRef;
    }

    @Override
    public void setXQParameters(XQParameters params) {
        this.m_stepParams = params;
    }

    @Override
    public Scope getScope() {
        return this.m_scope;
    }

    public static Token createTokens(XQProcessInstance procInst, Token token, ActivityNode node) {
        HashSet<XQAddress> nextAddresses = new HashSet<XQAddress>(4);
        procInst.populateExitEndpoints(nextAddresses, token);
        procInst.setNextAddresses(nextAddresses);
        Token resultToken = token;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        if (nextAddresses.isEmpty()) {
            mex.setDestinationAddress(null);
        } else if (nextAddresses.size() == 1) {
            mex.setDestinationAddress((XQAddress)nextAddresses.iterator().next());
        } else {
            resultToken = CompositeToken.createCompositeToken(node, token, mex, nextAddresses);
        }
        return resultToken;
    }
}

