/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.model.impl;

import com.sonicsw.esb.process.model.ActionList;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Guard;
import com.sonicsw.esb.process.model.Token;

public class DefaultActivityEdge
implements ActivityEdge {
    private final ActivityNode m_source;
    private final ActivityNode m_destination;
    private final String m_id;
    protected String m_messageType;
    protected String m_eventType;
    private Guard m_guard;
    private int m_weight;
    protected ActionList m_actionList;

    public DefaultActivityEdge(ActivityNode source, ActivityNode destination) {
        this("[" + source.getId() + "] --> [" + destination.getId() + "]", source, destination);
    }

    protected DefaultActivityEdge(String id, ActivityNode source, ActivityNode destination) {
        this.m_id = id;
        this.m_source = source;
        this.m_destination = destination;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public ActivityNode getSource() {
        return this.m_source;
    }

    @Override
    public ActivityNode getDestination() {
        return this.m_destination;
    }

    @Override
    public final void setGuard(Guard guard) {
        this.m_guard = guard;
    }

    @Override
    public boolean evaluateGuard(Token token) {
        return this.m_guard != null ? this.m_guard.evaluate(token) : true;
    }

    @Override
    public void place(Token token) {
        if (this.m_actionList != null) {
            this.m_actionList.execute(token, null, this);
        }
        this.m_destination.offerIncoming(token);
    }

    public void setMessageType(String type) {
        this.m_messageType = type;
    }

    public String getMessageType() {
        return this.m_messageType;
    }

    public void setEventType(String type) {
        this.m_eventType = type;
    }

    public String getEventType() {
        return this.m_eventType;
    }

    @Override
    public void setWeight(int weight) {
        this.m_weight = weight;
    }

    @Override
    public int getWeight() {
        return this.m_weight;
    }

    public boolean hasGuard() {
        return this.m_guard != null;
    }

    @Override
    public void setActionList(ActionList actionList) {
        this.m_actionList = actionList;
    }

    public String toString() {
        return this.getId();
    }
}

