/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.handlers.service.impl;

import com.sonicsw.esb.run.LocationContext;
import com.sonicsw.esb.run.RemoteValue;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.handlers.service.impl.XQAddressReference;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQQualityofService;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class XQProcessContextReference
extends com.sonicsw.esb.run.impl.RemoteValue
implements com.sonicsw.esb.run.handlers.service.XQProcessContextReference {
    protected final XQProcessContext m_processContext;

    public XQProcessContextReference(LocationContext locationContext, XQProcessContext processContext) {
        super(locationContext);
        this.m_processContext = processContext;
    }

    @Override
    public String getName() throws RemoteException {
        return this.m_processContext.getName();
    }

    @Override
    public String getDescription() throws RemoteException {
        return this.m_processContext.getDescription();
    }

    @Override
    public String getQualityofService() throws RemoteException {
        XQQualityofService qos = this.m_processContext.getQualityofService();
        if (qos == null) {
            return null;
        }
        return qos.toString();
    }

    @Override
    public long getTimestamp() throws RemoteException {
        return this.m_processContext.getTimestamp();
    }

    @Override
    public int getStepType() throws RemoteException {
        return this.m_processContext.getStepType();
    }

    @Override
    public List getNextAddresses() throws RemoteException {
        try {
            LinkedList<RemoteValue> addresses = new LinkedList<RemoteValue>();
            Iterator it = this.m_processContext.getNextAddresses();
            while (it != null && it.hasNext()) {
                XQAddress address = (XQAddress)it.next();
                XQAddressReference addressRef = new XQAddressReference(this.m_locationContext, address);
                addresses.add(this.exportSubObject(addressRef));
            }
            return addresses;
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getNextAddresses' failed", e);
        }
    }

    @Override
    public com.sonicsw.esb.run.handlers.service.XQAddressReference getEventAddress() throws RemoteException {
        try {
            XQAddress address = this.m_processContext.getEventAddress();
            if (address == null) {
                return null;
            }
            XQAddressReference addressRef = new XQAddressReference(this.m_locationContext, address);
            return (com.sonicsw.esb.run.handlers.service.XQAddressReference)this.exportSubObject(addressRef);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getEventAddress' failed", e);
        }
    }

    @Override
    public List getExitEndpoints() throws RemoteException {
        try {
            LinkedList<RemoteValue> addresses = new LinkedList<RemoteValue>();
            Iterator it = this.m_processContext.getExitEndpoints();
            while (it.hasNext()) {
                XQAddress address = (XQAddress)it.next();
                XQAddressReference addressRef = new XQAddressReference(this.m_locationContext, address);
                addresses.add(this.exportSubObject(addressRef));
            }
            return addresses;
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getNextAddresses' failed", e);
        }
    }

    @Override
    public com.sonicsw.esb.run.handlers.service.XQAddressReference getFaultAddress() throws RemoteException {
        try {
            XQAddress address = this.m_processContext.getFaultAddress();
            if (address == null) {
                return null;
            }
            XQAddressReference addressRef = new XQAddressReference(this.m_locationContext, address);
            return (com.sonicsw.esb.run.handlers.service.XQAddressReference)this.exportSubObject(addressRef);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getFaultAddress' failed", e);
        }
    }

    @Override
    public com.sonicsw.esb.run.handlers.service.XQAddressReference getRMEAddress() throws RemoteException {
        try {
            XQAddress address = this.m_processContext.getRMEAddress();
            if (address == null) {
                return null;
            }
            XQAddressReference addressRef = new XQAddressReference(this.m_locationContext, address);
            return (com.sonicsw.esb.run.handlers.service.XQAddressReference)this.exportSubObject(addressRef);
        }
        catch (RunException e) {
            throw new RemoteException("Method 'getRMEAddress' failed", e);
        }
    }

    @Override
    public String getStepName() throws RemoteException {
        return this.m_processContext.getStepName();
    }

    @Override
    public String getTrackingID() throws RemoteException {
        return this.m_processContext.getTrackingID();
    }

    @Override
    public int getTrackingLevel() throws RemoteException {
        return this.m_processContext.getTrackingLevel();
    }

    @Override
    public long getTTL() throws RemoteException {
        return this.m_processContext.getTTL();
    }

    @Override
    public Properties getInflightProperties() throws RemoteException {
        return this.m_processContext.getInflightProperties();
    }

    @Override
    public void setInflightProperties(Properties props) throws RemoteException {
        this.m_processContext.setInflightProperties(props);
    }
}

